/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.swing.plaf.lfm;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.plaf.PlafUtilies;
import com.kingdee.cosmic.ctrl.swing.plaf.ThemeXMLHandler;
import com.kingdee.cosmic.ctrl.swing.plaf.lfm.KDFontUIResource;
import com.kingdee.cosmic.ctrl.swing.plaf.lfm.SystemLFM;
import com.kingdee.cosmic.ctrl.swing.plaf.themes.KingdeeTheme;
import java.awt.Color;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import org.apache.log4j.Logger;

public class BasicLFM {
    private static final Logger logger = LogUtil.getPackageLogger(BasicLFM.class);
    private KingdeeTheme selfTheme = null;
    protected static final FontUIResource renderFont = new FontUIResource("Dialog", 0, 12);
    protected static final FontUIResource editorFont = new FontUIResource("Dialog", 0, 12);

    public void setTheme(KingdeeTheme newTheme) {
        if (newTheme != null) {
            this.selfTheme = newTheme;
        }
    }

    public KingdeeTheme getTheme() {
        return this.selfTheme;
    }

    public SystemLFM getSystemLFM() {
        return this.getTheme().getSystemLFM();
    }

    public String getElementValueOfKingdee(String eleNode) {
        String tempEle = this.getTheme().getKingdeeThemeAlias() + eleNode;
        String eleVal = PlafUtilies.getCacheNode(tempEle);
        if (eleVal == null) {
            eleVal = this.getTheme().getThemeXMLHandler().getElementValue(eleNode);
            PlafUtilies.putCacheNode(tempEle, eleVal);
        }
        return eleVal;
    }

    public String getElementValueOfCustom(String eleNode) {
        String tempEle = this.getTheme().getThemeAlias() + eleNode;
        String eleVal = PlafUtilies.getCacheNode(tempEle);
        if (eleVal == null) {
            eleVal = this.getTheme().getThemeXMLHandler().getElementValue(eleNode);
            PlafUtilies.putCacheNode(tempEle, eleVal);
        }
        return eleVal;
    }

    public String getElementValue(String eleNode) {
        String eleVal = "";
        int themeType = this.getTheme().getThemeType();
        if (themeType == 1 && (eleVal = this.getElementValueOfCustom(eleNode)).length() > 0) {
            return eleVal;
        }
        eleVal = this.getElementValueOfKingdee(eleNode);
        return eleVal;
    }

    public static Color parseColor(String strCol) {
        try {
            if (strCol.length() > 7) {
                String strA = strCol.substring(1, 3);
                String strR = strCol.substring(3, 5);
                String strG = strCol.substring(5, 7);
                String strB = strCol.substring(7, 9);
                return new Color(Integer.parseInt(strR, 16), Integer.parseInt(strG, 16), Integer.parseInt(strB, 16), Integer.parseInt(strA, 16));
            }
            return Color.decode(strCol);
        }
        catch (Exception err) {
            String text = null;
            text = strCol.isEmpty() ? CtrlCommonMessages.getMLS((String)"colorExpressionInvalid", (String)"\u8f93\u5165\u7684\u989c\u8272\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff0c\u6b63\u786e\u683c\u5f0f\u5982\uff1a#00ff99") : strCol + CtrlCommonMessages.getMLS((String)"colorExpressionInvalid", (String)"\u8f93\u5165\u7684\u989c\u8272\u8868\u8fbe\u5f0f\u4e0d\u5408\u6cd5\uff0c\u6b63\u786e\u683c\u5f0f\u5982\uff1a#00ff99");
            throw new IllegalArgumentException(text, err);
        }
    }

    public ColorUIResource getElementAsColor(String eleNode) {
        String value = this.getElementValue(eleNode);
        if (value.length() == 0) {
            return null;
        }
        Color col = PlafUtilies.getCacheColor(value);
        if (col == null) {
            try {
                col = BasicLFM.parseColor(value);
                PlafUtilies.putCacheColor(value, col);
            }
            catch (Exception ex) {
                col = Color.WHITE;
                logger.error((Object)"err", (Throwable)ex);
            }
        }
        if (col instanceof ColorUIResource) {
            return (ColorUIResource)col;
        }
        return new ColorUIResource(col);
    }

    public Color getElementAsAlphaColor(String eleNode) {
        String value = this.getElementValue(eleNode);
        if (value.length() == 0) {
            return null;
        }
        Color col = PlafUtilies.getCacheColor(value);
        if (col == null) {
            try {
                col = BasicLFM.parseColor(value);
                PlafUtilies.putCacheColor(value, col);
            }
            catch (Exception ex) {
                col = null;
                logger.error((Object)"err", (Throwable)ex);
            }
        }
        return col;
    }

    public InsetsUIResource getElementAsInsets(String eleNode) {
        String value = this.getElementValue(eleNode);
        if (value.length() == 0) {
            return new InsetsUIResource(0, 0, 0, 0);
        }
        int[] eleIn = new int[]{0, 0, 0, 0};
        StringTokenizer st = new StringTokenizer(value, ",");
        for (int tempC = 0; st.hasMoreElements() && tempC < 4; ++tempC) {
            try {
                eleIn[tempC] = Integer.parseInt((String)st.nextElement());
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return new InsetsUIResource(eleIn[0], eleIn[1], eleIn[2], eleIn[3]);
    }

    public ThemeXMLHandler getThemeXMLHandler() {
        return this.getTheme().getThemeXMLHandler();
    }

    public String getElementAsIcon(String eleNode) {
        String iconName = this.getElementValue(eleNode);
        String isCache = System.getProperty("isCahceIconResource");
        if ("true".equals(isCache)) {
            eleNode = eleNode.replaceAll(":Look:", ".");
            PlafUtilies.putCacheIconResource(eleNode, iconName);
        }
        return iconName;
    }

    public String[] getElementAsFontArray(String eleNode) {
        String fontName = this.getElementValue(eleNode + ":Name");
        if (fontName.length() == 0) {
            return null;
        }
        String styleStr = this.getElementValue(eleNode + ":Style");
        if (styleStr.length() == 0) {
            return null;
        }
        String sizeStr = this.getElementValue(eleNode + ":Size");
        if (sizeStr.length() == 0) {
            return null;
        }
        return new String[]{fontName.trim(), styleStr.trim(), sizeStr.trim()};
    }

    public FontUIResource getElementAsFont(String eleNode) {
        String[] fontArray = this.getElementAsFontArray(eleNode);
        if (fontArray == null) {
            return null;
        }
        String fontName = fontArray[0];
        String styleStr = fontArray[1];
        String sizeStr = fontArray[2];
        int style = 0;
        if (styleStr.equalsIgnoreCase("PLAIN")) {
            style = 0;
        } else if (styleStr.equalsIgnoreCase("BOLD")) {
            style = 1;
        } else if (styleStr.equalsIgnoreCase("ITALIC")) {
            style = 2;
        }
        int size = -1;
        try {
            size = Integer.parseInt(sizeStr);
        }
        catch (NumberFormatException _ex) {
            size = 12;
        }
        try {
            KDFontUIResource fr = new KDFontUIResource(fontName, style, size);
            return fr;
        }
        catch (Exception ex) {
            logger.error((Object)"err", (Throwable)ex);
            return new KDFontUIResource("Dialog", 0, 12);
        }
    }

    public Boolean getElementAsBoolean(String eleNode) {
        String eleVal = this.getElementValue(eleNode);
        if (eleVal.length() > 0) {
            if ((eleVal = eleVal.trim().toLowerCase(Locale.ENGLISH)).equals("true") || eleVal.equals("1")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Integer getElementAsInteger(String eleNode) {
        String eleVal = this.getElementValue(eleNode);
        try {
            return Integer.valueOf(eleVal);
        }
        catch (NumberFormatException e) {
            logger.error((Object)"err", (Throwable)e);
            return null;
        }
    }
}

