/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.workbench.splash;

import com.kingdee.cosmic.ctrl.workbench.splash.ColorTintFilter;
import com.kingdee.cosmic.ctrl.workbench.splash.ImageUtil;
import com.kingdee.cosmic.ctrl.workbench.splash.ProgressTimingEffect;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JProgressBar;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.timing.TimingTarget;

class SplashProgressBar
extends JProgressBar {
    private ColorTintFilter filter;
    private GradientPaint p1;
    private GradientPaint p2;
    private GradientPaint p3;

    SplashProgressBar(int start, int end) {
        super(start, end);
        Animator animator;
        this.setBackground(Color.white);
        ProgressTimingEffect target = new ProgressTimingEffect(this);
        target.animator = animator = new Animator(600, -1.0, Animator.RepeatBehavior.LOOP, (TimingTarget)target);
        animator.start();
        this.filter = ImageUtil.getColorTintFilter(Color.green, 1.0f);
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        int sh = height - 2;
        if (this.p1 == null || this.p2 == null) {
            this.p1 = new GradientPaint(0.0f, 0.0f, new Color(9680960), 0.0f, height, new Color(3244853));
            this.p2 = new GradientPaint(0.0f, 0.0f, new Color(0xFEFFE8), 0.0f, height, new Color(14080959));
            this.p3 = new GradientPaint(0.0f, 0.0f, new Color(4618125), 0.0f, height, new Color(4618125));
        }
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setPaint(this.p3);
        g2.fillRect(0, 0, width, height);
        g2.setComposite(AlphaComposite.getInstance(5, 0.6f));
        g2.setPaint(this.p2);
        g2.fillRect(1, 1, width, sh);
        g2.setPaint(this.p1);
        g2.fillRect(1, 1, width * this.getValue() / 100, sh);
    }
}

