/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.workbench.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.DefaultButtonModel;
import javax.swing.plaf.basic.BasicButtonListener;

public class ImageButton
extends AbstractButton {
    private Image image;
    private static BasicButtonListener listener = new BasicButtonListener(null);

    public ImageButton(Image image) {
        if (image == null) {
            throw new IllegalArgumentException();
        }
        this.image = image;
        this.init();
    }

    private void init() {
        this.setLayout(new ImageButtonLayout());
        this.setModel(new DefaultButtonModel());
        this.setRolloverEnabled(true);
        this.setCursor(Cursor.getPredefinedCursor(0));
        if (listener != null) {
            this.addMouseListener(listener);
            this.addMouseMotionListener(listener);
            this.addFocusListener(listener);
            this.addPropertyChangeListener(listener);
            this.addChangeListener(listener);
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension d = this.getSize();
        int width = d.width;
        int height = d.height;
        g.drawImage(this.image, 2, 2, this);
        if (this.model.isRollover()) {
            g.setColor(Color.gray);
            g.drawRoundRect(2, 2, width - 4, height - 4, 5, 5);
        } else if (this.model.isPressed()) {
            g.setColor(Color.pink);
            g.drawRoundRect(2, 2, width - 4, height - 4, 5, 5);
        }
    }

    private class ImageButtonLayout
    implements LayoutManager {
        private ImageButtonLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return new Dimension(ImageButton.this.image.getWidth(null) + 4, ImageButton.this.image.getHeight(null) + 4);
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return new Dimension(ImageButton.this.image.getWidth(null) + 4, ImageButton.this.image.getHeight(null) + 4);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

