/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.workbench.ui;

import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.swing.KDMenuBar;
import com.kingdee.cosmic.ctrl.swing.MessageDialog;
import com.kingdee.cosmic.ctrl.workbench.i18n.CtrlWorkbenchMessages;
import com.kingdee.cosmic.ctrl.workbench.logic.TrimWidgetManager;
import com.kingdee.cosmic.ctrl.workbench.persist.IIOProvider;
import com.kingdee.cosmic.ctrl.workbench.persist.TrimDatabase;
import com.kingdee.cosmic.ctrl.workbench.splash.NotifyObject;
import com.kingdee.cosmic.ctrl.workbench.ui.IDockable;
import com.kingdee.cosmic.ctrl.workbench.ui.ITrimWidget;
import com.kingdee.cosmic.ctrl.workbench.ui.TrimWidgetPlaceholder;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class Perspective
extends JPanel
implements IDockable {
    public static final String KEY_PERSPECTIVE_VIEW_ERROR = "perspectiveViewError";
    public static final String KEY_TITLE = "title";
    public static final String KEY_VIEW_RESTORE_ERROR = "viewRestoreError";
    private static final Logger log = LogUtil.getPackageLogger(Perspective.class);
    private static final boolean DEBUG = true;
    private Rectangle dockRect;
    private TrimWidgetManager trimWidgetManager;
    private ITrimWidget exclusiveTrim;
    private String perspectiveName;
    private IIOProvider ioProvider;
    private boolean autoInstantiated = false;
    private String version;
    private String ioCache;
    private HashMap trimInstances = new HashMap();
    private NotifyObject notice = NotifyObject.getCurrentInstance();
    private String[] messages = new String[]{Perspective.getLocalText("parseTemplateFile", "\u89e3\u6790\u6a21\u677f\u6587\u4ef6"), Perspective.getLocalText("parseTemplateFileCompleted", "\u89e3\u6790\u6a21\u677f\u6587\u4ef6\u5b8c\u6bd5"), Perspective.getLocalText("loadDragLayoutManager", "\u52a0\u8f7d\u62d6\u62fd\u5e03\u5c40\u7ba1\u7406\u5668"), Perspective.getLocalText("loadPropertyTable", "\u52a0\u8f7d\u5c5e\u6027\u8868")};
    private int progress = 0;

    public static String getLocalText(String key, String defaultStr) {
        return CtrlWorkbenchMessages.getMLS(key, defaultStr);
    }

    public Perspective(String perspectiveName, String version) {
        if (perspectiveName == null || version == null) {
            throw new NullPointerException(Perspective.getLocalText(KEY_PERSPECTIVE_VIEW_ERROR, "\u900f\u89c6\u56fe\u540d\u79f0\u548c\u7248\u672c\u53f7\u5747\u4e0d\u53ef\u4e3a\u7a7a"));
        }
        this.perspectiveName = perspectiveName;
        this.version = version;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.autoInstantiated = this.instantiate();
    }

    public Perspective(String perspectiveName, String version, IIOProvider ioProvider) {
        if (perspectiveName == null || version == null) {
            throw new NullPointerException(Perspective.getLocalText(KEY_PERSPECTIVE_VIEW_ERROR, "\u900f\u89c6\u56fe\u540d\u79f0\u548c\u7248\u672c\u53f7\u5747\u4e0d\u53ef\u4e3a\u7a7a"));
        }
        this.ioProvider = ioProvider;
        this.perspectiveName = perspectiveName;
        this.version = version;
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.autoInstantiated = this.instantiate();
    }

    public String getIOCache() {
        return this.ioCache;
    }

    public IIOProvider getIOProvider() {
        return this.ioProvider;
    }

    public boolean isAutoInstantiated() {
        return this.autoInstantiated;
    }

    public TrimWidgetManager getTrimWidgetManager() {
        if (this.trimWidgetManager == null) {
            this.trimWidgetManager = new TrimWidgetManager(this);
        }
        return this.trimWidgetManager;
    }

    public Component getPerspectiveRootElement() {
        return this.getComponentCount() == 0 ? null : this.getComponent(0);
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.dockRect != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.setColor(Color.blue.brighter());
            g2d.setStroke(new BasicStroke(3.0f));
            g2d.drawRect(this.dockRect.x, this.dockRect.y, this.dockRect.width, this.dockRect.height);
        }
    }

    @Override
    public void dockingTo(int areaId) {
        int w = this.getWidth();
        int h = this.getHeight();
        int dockx = (int)((double)w * 0.2);
        int docky = (int)((double)h * 0.2);
        switch (areaId) {
            case 3: {
                this.dockRect = new Rectangle(1, 1, dockx - 3, h - 3);
                this.repaint();
                break;
            }
            case 4: {
                this.dockRect = new Rectangle(w - dockx + 1, 1, dockx - 3, h - 3);
                this.repaint();
                break;
            }
            case 1: {
                this.dockRect = new Rectangle(1, 1, w - 3, docky - 3);
                this.repaint();
                break;
            }
            case 2: {
                this.dockRect = new Rectangle(1, h - docky + 1, w - 3, docky - 3);
                this.repaint();
                break;
            }
            default: {
                this.dockRect = null;
                this.repaint();
            }
        }
    }

    public void setExclusiveTrim(ITrimWidget exclusiveTrim) {
        if (exclusiveTrim.getPerspective() == null) {
            return;
        }
        this.persistToCache();
        this.dissociateDescendantTrims();
        this.removeAll();
        exclusiveTrim.setPerspective(this);
        this.exclusiveTrim = exclusiveTrim;
        exclusiveTrim.exclusiveNotify(true);
        this.add((Component)((Object)exclusiveTrim));
        this.revalidate();
        this.repaint();
    }

    private void dissociateDescendantTrims() {
        Component c = this.getPerspectiveRootElement();
        if (c == null) {
            return;
        }
        if (c instanceof TrimWidgetPlaceholder) {
            this.dissociateDescendantTrims((TrimWidgetPlaceholder)c);
        } else {
            ((ITrimWidget)((Object)c)).setPerspective(null);
        }
    }

    private void dissociateDescendantTrims(TrimWidgetPlaceholder pher) {
        Component left = pher.getLeftComponent();
        if (left instanceof TrimWidgetPlaceholder) {
            this.dissociateDescendantTrims((TrimWidgetPlaceholder)left);
        } else {
            ((ITrimWidget)((Object)left)).setPerspective(null);
        }
        Component right = pher.getRightComponent();
        if (right instanceof TrimWidgetPlaceholder) {
            this.dissociateDescendantTrims((TrimWidgetPlaceholder)right);
        } else {
            ((ITrimWidget)((Object)right)).setPerspective(null);
        }
    }

    public void showAllInclusions() {
        if (!this.isExclusiveView()) {
            return;
        }
        this.exclusiveTrim.setPerspective(null);
        this.exclusiveTrim.exclusiveNotify(false);
        this.exclusiveTrim = null;
        this.removeAll();
        this.instantiate(true);
        this.revalidate();
        this.repaint();
    }

    public boolean isExclusiveView() {
        return this.exclusiveTrim != null;
    }

    public ITrimWidget getExclusiveView() {
        return this.exclusiveTrim;
    }

    public String getPerspectiveName() {
        return this.perspectiveName;
    }

    public String getVersion() {
        return this.version;
    }

    public ITrimWidget getTrimWidget(String trimId) {
        Object trim = this.trimInstances.get(trimId);
        if (trim != null) {
            return (ITrimWidget)trim;
        }
        this.nextStage();
        trim = TrimDatabase.createTrimWidget(trimId);
        this.trimInstances.put(trimId, trim);
        return (ITrimWidget)trim;
    }

    public HashMap getTrims() {
        return this.trimInstances;
    }

    private void nextStage() {
        if (this.progress < this.messages.length - 1) {
            ++this.progress;
        }
        this.notice.notice(0, this.messages[this.progress]);
    }

    public void registerTrimWidget(String trimId, ITrimWidget trim) {
        this.trimInstances.put(trimId, trim);
    }

    public boolean instantiate() {
        return this.instantiate(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean instantiate(boolean ignoreExclusive) {
        this.nextStage();
        try {
            long t1 = System.currentTimeMillis();
            if (this.getComponentCount() > 0) {
                this.removeAll();
            }
            if (this.ioCache == null) {
                InputStream is;
                IIOProvider ioProvider = this.getIOProvider();
                if (ioProvider != null) {
                    is = ioProvider.getPersistenceInputStream();
                } else {
                    File configFile = new File(FilenameUtils.normalize((String)(TrimDatabase.CONFIG_DIR + File.separator + this.getPerspectiveName() + ".conf")));
                    if (!configFile.exists()) {
                        return false;
                    }
                    if (configFile.length() == 0L) {
                        return true;
                    }
                    is = new FileInputStream(configFile);
                }
                BufferedReader br = null;
                StringBuilder sb = new StringBuilder();
                InputStreamReader isr = null;
                try {
                    isr = new InputStreamReader(is);
                    br = new BufferedReader(isr);
                    TrimWidgetManager manager = this.getTrimWidgetManager();
                    String line = br.readLine();
                    if (!this.getVersion().equals(line)) {
                        boolean bl = false;
                        return bl;
                    }
                    sb.append(line).append("\n");
                    line = br.readLine();
                    sb.append(line).append("\n");
                    String[] breakUps = line.split("  ");
                    ITrimWidget testPaper = this.getTrimWidget(breakUps[0]);
                    if (testPaper == null) {
                        boolean bl = false;
                        return bl;
                    }
                    manager.addTrim(testPaper);
                    this.nextStage();
                    line = br.readLine();
                    while (line != null) {
                        sb.append(line).append("\n");
                        String[] codeSnippets = line.split("  ");
                        ITrimWidget target = this.getTrimWidget(codeSnippets[0]);
                        ITrimWidget source = this.getTrimWidget(codeSnippets[1]);
                        if (target == null || source == null) {
                            boolean bl = false;
                            return bl;
                        }
                        int orientation = 4;
                        if ("HORIZONTAL_SPLIT".equals(codeSnippets[2])) {
                            orientation = 2;
                        }
                        manager.addTrim(orientation, source, target, new Double(codeSnippets[3]));
                        line = br.readLine();
                    }
                    if (breakUps.length > 1 && !ignoreExclusive) {
                        testPaper = this.getTrimWidget(breakUps[1]);
                        if (testPaper == null) {
                            boolean codeSnippets = false;
                            return codeSnippets;
                        }
                        this.setExclusiveTrim(testPaper);
                    }
                    long t2 = System.currentTimeMillis();
                    System.out.println("perspective(" + this.getPerspectiveName() + ") recovered from the config file. time elapsed " + (t2 - t1));
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                    if (is != null) {
                        is.close();
                    }
                }
                this.ioCache = sb.toString();
                return true;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(this.ioCache.getBytes(StandardCharsets.UTF_8));
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            TrimWidgetManager manager = this.getTrimWidgetManager();
            String line = br.readLine();
            line = br.readLine();
            String[] breakUps = line.split("  ");
            manager.addTrim(this.getTrimWidget(breakUps[0]));
            line = br.readLine();
            this.nextStage();
            while (line != null) {
                String[] codeSnippets = line.split("  ");
                ITrimWidget target = this.getTrimWidget(codeSnippets[0]);
                ITrimWidget source = this.getTrimWidget(codeSnippets[1]);
                int orientation = 4;
                if ("HORIZONTAL_SPLIT".equals(codeSnippets[2])) {
                    orientation = 2;
                }
                manager.addTrim(orientation, source, target, new Double(codeSnippets[3]));
                line = br.readLine();
            }
            if (breakUps.length > 1 && !ignoreExclusive) {
                this.setExclusiveTrim(this.getTrimWidget(breakUps[1]));
            }
            long t2 = System.currentTimeMillis();
            System.out.println("perspective(" + this.getPerspectiveName() + ") recovered from the config cache. time elapsed " + (t2 - t1));
            br.close();
            return true;
        }
        catch (Exception e) {
            this.removeAll();
            MessageDialog.show((Component)this, (Object)Perspective.getLocalText(KEY_VIEW_RESTORE_ERROR, "\u65e0\u6cd5\u6062\u590d\u89c6\u56fe{" + this.getPerspectiveName() + "}\uff0c\u8bf7\u4f7f\u7528<\u89c6\u56fe-\u89c6\u56fe\u7ba1\u7406>\u91cd\u65b0\u5b9a\u4e49\u672c\u89c6\u56fe").replace("#1", this.getPerspectiveName()), (String)Perspective.getLocalText(KEY_TITLE, "\u5de5\u4f5c\u53f0\u6d88\u606f"), (int)-1);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist() {
        this.persistToCache();
        if (this.ioCache != null) {
            OutputStream os = null;
            try {
                IIOProvider ioProvider = this.getIOProvider();
                os = ioProvider != null ? ioProvider.getPersistenceOutputStream() : new FileOutputStream(new File(FilenameUtils.normalize((String)(TrimDatabase.CONFIG_DIR + File.separator + this.getPerspectiveName() + ".conf"))));
                try (PrintStream ps = new PrintStream(os);){
                    ps.print(this.ioCache);
                    ps.flush();
                }
            }
            catch (Exception e) {
            }
            finally {
                try {
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException e) {
                    log.info((Object)"error", (Throwable)e);
                }
            }
        }
    }

    public void persistToCache() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ITrimWidget exclusiveTrim = this.getExclusiveView();
        this.showAllInclusions();
        long t1 = System.currentTimeMillis();
        PrintStream ps = new PrintStream(bos);
        ps.println(this.getVersion());
        Component node = this.getPerspectiveRootElement();
        if (node == null) {
            ps.print("");
            ps.flush();
            ps.close();
            this.ioCache = new String(bos.toByteArray(), StandardCharsets.UTF_8);
            return;
        }
        if (node instanceof ITrimWidget) {
            if (exclusiveTrim == null) {
                ps.println(((ITrimWidget)((Object)node)).getId());
            } else {
                ps.println(((ITrimWidget)((Object)node)).getId() + this.getGap() + exclusiveTrim.getId());
            }
            long t2 = System.currentTimeMillis();
            System.out.println("perspective(" + this.getPerspectiveName() + ") persisted to the config cache. time elapsed " + (t2 - t1));
            ps.flush();
            ps.close();
            this.ioCache = new String(bos.toByteArray(), StandardCharsets.UTF_8);
            return;
        }
        LinkedList<Component> queue = new LinkedList<Component>();
        queue.offer(node);
        Component firstTw = node;
        while (!(firstTw instanceof ITrimWidget)) {
            firstTw = ((TrimWidgetPlaceholder)firstTw).getLeftComponent();
        }
        if (exclusiveTrim == null) {
            ps.println(((ITrimWidget)((Object)firstTw)).getId());
        } else {
            ps.println(((ITrimWidget)((Object)firstTw)).getId() + this.getGap() + exclusiveTrim.getId());
        }
        while (!queue.isEmpty()) {
            node = queue.poll();
            if (!(node instanceof TrimWidgetPlaceholder)) continue;
            TrimWidgetPlaceholder twp = (TrimWidgetPlaceholder)node;
            this.buildInformation4Composite(twp, ps);
            queue.offer(twp.getLeftComponent());
            queue.offer(twp.getRightComponent());
        }
        long t2 = System.currentTimeMillis();
        System.out.println("perspective(" + this.getPerspectiveName() + ") persisted to the config cache. time elapsed " + (t2 - t1));
        ps.flush();
        ps.close();
        this.ioCache = new String(bos.toByteArray(), StandardCharsets.UTF_8);
    }

    public List getToolBars() {
        return null;
    }

    public KDMenuBar getMenuBar() {
        return null;
    }

    private void buildInformation4Composite(TrimWidgetPlaceholder twp, PrintStream ps) {
        Component llEst = twp.getLeftComponent();
        Component rlEst = twp.getRightComponent();
        while (!(llEst instanceof ITrimWidget)) {
            llEst = ((TrimWidgetPlaceholder)llEst).getLeftComponent();
        }
        while (!(rlEst instanceof ITrimWidget)) {
            rlEst = ((TrimWidgetPlaceholder)rlEst).getLeftComponent();
        }
        ps.print(((ITrimWidget)((Object)llEst)).getId());
        ps.print(this.getGap());
        ps.print(((ITrimWidget)((Object)rlEst)).getId());
        ps.print(this.getGap());
        ps.print(this.getOrientation(twp));
        ps.print(this.getGap());
        BigDecimal bd = new BigDecimal(1.0 - twp.getDividerLocation());
        bd = bd.setScale(4, 4);
        ps.println(bd);
    }

    private String getGap() {
        return "  ";
    }

    private String getOrientation(TrimWidgetPlaceholder twp) {
        return twp.getOrientation() == 0 ? "VERTICAL_SPLIT" : "HORIZONTAL_SPLIT";
    }
}

