/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext;

import com.kingdee.cosmic.ctrl.ext.IExtKeyboardManager;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public class ExtKeyboardManager
implements IExtKeyboardManager {
    private KDExt _ext;

    ExtKeyboardManager(KDExt ext) {
        this._ext = ext;
        this.initKeyboardEvents();
    }

    private void initKeyboardEvents() {
        JComponent pane = (JComponent)this._ext.getContentPane();
        this.initContextActionMap(pane.getActionMap());
        this.initContextInputMap(pane.getInputMap(1));
    }

    private void initContextActionMap(ActionMap actionMap) {
        actionMap.put("ext_preview", this._ext.getExtActionManager().getAction("EXT_PREVIEW"));
        actionMap.put("ext_print", new DispatchAction());
        actionMap.put("ext_new", this._ext.getExtActionManager().getAction("EXT_NEW"));
        actionMap.put("ext_save", this._ext.getExtActionManager().getAction("EXT_SAVE"));
    }

    private void initContextInputMap(InputMap inputMap) {
        inputMap.put(KeyStroke.getKeyStroke(120, 0), "ext_preview");
        inputMap.put(KeyStroke.getKeyStroke(80, 2), "ext_print");
        inputMap.put(KeyStroke.getKeyStroke(78, 2), "ext_new");
        inputMap.put(KeyStroke.getKeyStroke(83, 2), "ext_save");
    }

    @Override
    public void removeKeyAction(String key) {
        JComponent pane = (JComponent)this._ext.getContentPane();
        pane.getActionMap().remove(key);
    }

    public class DispatchAction
    extends AbstractAction {
        @Override
        public void actionPerformed(ActionEvent e) {
            MiscUtil.getActiveSpreadContext(ExtKeyboardManager.this._ext).getActionManager().getAction("Show_Print_Wizzard").actionPerformed(e);
        }
    }
}

