/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.ExtActionManager;
import com.kingdee.cosmic.ctrl.ext.IExtWizardManager;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfig;
import com.kingdee.cosmic.ctrl.ext.rd.RptPerspective;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.io.WizardExport;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.showcase.ReportViewConstraintsWizard;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.ext.util.ShowcaseUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.io.BookIOUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.workbench.ui.Perspective;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.AbstractAction;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

class SaveAction
extends AbstractAction {
    private static final Logger logger = LogUtil.getPackageLogger(SaveAction.class);
    private KDExt _ext;
    private ISpreadWizzard wizardViewConstraints;

    SaveAction(KDExt ext) {
        this._ext = ext;
        this.putValue("Name", ExtActionManager.getLocalText("save", "\u4fdd\u5b58"));
        this.putValue("ShortDescription", ExtActionManager.getLocalText("save", "\u4fdd\u5b58"));
        this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_Save.gif"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SpreadContext context = MiscUtil.getActiveSpreadContext(this._ext);
        Book book = context.getBook();
        context.getStateManager().stopEditing();
        Perspective perspective = this._ext.getPerspective("Report Designer", false);
        if (perspective != null) {
            ((RptPerspective)perspective).getBeanBindManager().commitPropertySheetPanels();
        }
        if (book.isEncrypted()) {
            MessageUtil.msgboxInfo((Component)((Object)context), CtrlEXTMessages.getMLS("standardProductTemplateMsg", "\u6807\u51c6\u4ea7\u54c1\u6a21\u677f\u7981\u6b62\u4fdd\u5b58\u3002\n\u8bf7\u4f7f\u7528\"\u6587\u4ef6\" -> \"\u53e6\u5b58\u4e3a\"\u5b8c\u6210\u6301\u4e45\u5316\u64cd\u4f5c\uff01"));
            return;
        }
        try {
            String fileName;
            if (this.wizardViewConstraints == null) {
                this.wizardViewConstraints = this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_ReportViewConstraints);
            }
            ShowcaseConfig config = null;
            if (this.wizardViewConstraints instanceof ReportViewConstraintsWizard) {
                config = ((ReportViewConstraintsWizard)this.wizardViewConstraints).getDefaultShowcaseConfig();
            }
            if (config != null) {
                config.setRowSpans(null);
                config.setColSpans(null);
            }
            book.setUserObject("ShowcaseConfigTemplet", config == null ? ShowcaseUtil.toShowcaseConfig(new ShowcaseConfig().toElement()) : ShowcaseUtil.toShowcaseConfig(config.toElement()));
            String filePath = ((WizardExport)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_Export)).getPersistedFilePath();
            if (filePath != null) {
                File file = new File(FilenameUtils.normalize((String)filePath));
                book.setName(fileName.substring(0, (fileName = file.getName()).lastIndexOf(46) == -1 ? fileName.length() : fileName.lastIndexOf(46)));
            }
            if (this._ext.getExtCallback().saveReportData(BookIOUtil.pack(book), false)) {
                book.getUndoManager().discardAllEdits();
                if (filePath == null) {
                    ReportProperties rp = this._ext.getExtCallback().fetchCurrentReportProperties();
                    fileName = rp.getName();
                    book.setName(fileName);
                }
                this.showStatusMsg(CtrlEXTMessages.getMLS("saveSuccessMsg", "\u4fdd\u5b58\u6210\u529f\uff01"), 1);
            }
        }
        catch (IOException e1) {
            this.showStatusMsg(CtrlEXTMessages.getMLS("saveFailedMsg", "\u4fdd\u5b58\u5931\u8d25\uff01"), 0);
            logger.error((Object)"err", (Throwable)e1);
        }
    }

    private void showStatusMsg(final String msg, final int msgtype) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                SaveAction.this._ext.getExtStatusBarManager().show(null, "", msg, msgtype);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    logger.error((Object)"error:", (Throwable)e);
                }
                SaveAction.this._ext.getExtStatusBarManager().show(null, "", "", 1);
            }
        }).start();
    }
}

