/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.fulfil;

import com.kingdee.cosmic.ctrl.common.hyperlink.HyperLink;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExportUtil;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.cosmic.ctrl.ext.fulfil.SnapReportControlModel;
import com.kingdee.cosmic.ctrl.ext.immit.IRptRuntimeCallback;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.file.KDFException;
import com.kingdee.cosmic.ctrl.kdf.util.kdfsax.KDFSAXException;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ParameterImpl;
import com.kingdee.cosmic.ctrl.kds.io.BookIOUtil;
import com.kingdee.cosmic.ctrl.kds.io.htm.serial.Variant2String;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprMethod;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.ChartRectEmbedment;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.DynamicAccessImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbededImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.IImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ImageFullPath;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ReferredImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ReferredImageResult;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.ReferredPathImageModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.filter.AlgorithmUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.NamedObjectNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class ExecutorUtil {
    private static Logger logger = Logger.getLogger(ExecutorUtil.class);

    public static String buildStringFromDim2Array(double[][] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(data.length * data[0].length << 3);
        sb.append("ARRAY(");
        for (int i = 0; i < data.length; ++i) {
            sb.append('{');
            double[] rowData = data[i];
            int jEnd = data[i].length;
            for (int j = 0; j < jEnd; ++j) {
                sb.append(rowData[j]).append(',');
            }
            sb.setCharAt(sb.length() - 1, '}');
            sb.append(',');
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }

    public static String buildStringFromDim1Array(String[] data) {
        if (data == null || data.length == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder(data.length << 3);
        sb.append("ARRAY(");
        for (int i = 0; i < data.length; ++i) {
            sb.append('\"').append(data[i]).append("\",");
        }
        sb.setCharAt(sb.length() - 1, ')');
        return sb.toString();
    }

    public static byte[] generateSnapShot(Book _book, SnapReportControlModel control) throws IOException, KDFException, KDFSAXException, Exception {
        return BookIOUtil.pack(ExecutorUtil.generateSnapShotBook(_book, control));
    }

    public static Book generateSnapShotBook(Book _book, SnapReportControlModel control) throws IOException, KDFException, KDFSAXException, Exception {
        Sheet dstSheet;
        int sh;
        if (_book == null) {
            throw new NullPointerException(CtrlEXTMessages.getMLS("emptySnapshotBook", "\u5f85\u751f\u6210\u5feb\u7167\u7684_book\u4e3a\u7a7a"));
        }
        _book.setUserObject("isSnapReportSaveHyperLink", control.isSaveHyplink());
        Book dstBook = BookIOUtil.unpack(BookIOUtil.pack(_book));
        MiscUtil.capacitateFiCalculation(dstBook);
        ExportUtil.setEmbedModel(dstBook, _book);
        ExecutionContext ctx = _book.getDataSetManager().getExecutionContext();
        ExecutionContext dstCtx = dstBook.getDataSetManager().getExecutionContext();
        dstCtx.registerDataSetFactories(ctx.getDataSetFactories());
        Boolean saveStringLink = false;
        if (!control.isSaveHyplink()) {
            for (sh = dstBook.getSheetCount() - 1; sh >= 0; --sh) {
                dstSheet = dstBook.getSheet(sh);
                Sheet.ICellsIterator it = dstSheet.getCellsIterator(null, false, false);
                while (it.hasNext()) {
                    String[] arrLinkTo;
                    Cell dstCell = it.next();
                    if (dstCell.getHyperLink() == null || control.isSaveHyplink() && !dstCell.getHyperLink().getLinkTo().startsWith("rptInner:")) continue;
                    boolean clearLink = false;
                    String linkTo = dstCell.getHyperLink().getLinkTo();
                    String text = dstCell.getHyperLink().getText();
                    for (String link : arrLinkTo = linkTo.split(";")) {
                        if (!link.contains("#")) continue;
                        saveStringLink = true;
                        clearLink = true;
                        dstCell.setHyperLink(new HyperLink(text, link));
                        break;
                    }
                    if (!clearLink) {
                        dstCell.clearExtObject("inner_hyperlink");
                    }
                    if (dstCell.getExtProps(false) == null || dstCell.getExtProps(false).getFormulas(false) == null) continue;
                    dstCell.getExtProps(false).getFormulas(false).remove(ExtConst.FORMULA_HYPERLINK);
                }
            }
        }
        for (sh = dstBook.getSheetCount() - 1; sh >= 0; --sh) {
            boolean isSecurity;
            dstSheet = dstBook.getSheet(sh);
            Sheet srcSheet = _book.getSheet(sh);
            EmbedhLayer dstLayer = dstSheet.getEmbedments(false);
            if (dstLayer != null) {
                EmbedhLayer srcLayer = srcSheet.getEmbedments(false);
                int iEnd = dstLayer.size();
                for (int i = 0; i < iEnd; ++i) {
                    EmbedObject dstEO = dstLayer.getEmbed(i);
                    EmbedObject srcEO = srcLayer.getEmbed(i);
                    if (dstEO instanceof EmbedImage) {
                        EmbededImageModel embededImageModel;
                        EmbedImage dstImage = (EmbedImage)dstEO;
                        EmbedImage srcImage = (EmbedImage)srcLayer.getEmbed(i);
                        IImageModel model = dstImage.getModel();
                        if (model instanceof ReferredImageModel) {
                            embededImageModel = new EmbededImageModel();
                            String embedUid = ((ReferredImageModel)model).getEmbedUid();
                            String fileName = ((ReferredImageModel)model).getFileName();
                            byte[] imageData = model.getImageData();
                            if (imageData == null || imageData.length == 0) {
                                String reportId;
                                ExtDataSetManager dataSetManager = _book.getDataSetManager();
                                ExecutionContext executionContext = dataSetManager.getExecutionContext();
                                IRptRuntimeCallback rptRuntimeCallback = executionContext.getRptRuntimeCallback();
                                ReferredImageResult referredImageResult = rptRuntimeCallback.loadReferredImage(reportId = executionContext.getReportId(), embedUid);
                                if (referredImageResult == null) {
                                    referredImageResult = rptRuntimeCallback.loadImageByFileName(fileName);
                                }
                                if (referredImageResult != null) {
                                    embededImageModel.setImageData(referredImageResult.getImageData());
                                }
                            }
                            dstImage.setModel(embededImageModel);
                        } else if (model instanceof ReferredPathImageModel) {
                            ExtDataSetManager dataSetManager;
                            ExecutionContext executionContext;
                            IRptRuntimeCallback rptRuntimeCallback;
                            ReferredImageResult referredImageResult;
                            embededImageModel = new EmbededImageModel();
                            ImageFullPath imageFullPath = ((ReferredPathImageModel)model).getImageFullPath();
                            byte[] imageData = model.getImageData();
                            if ((imageData == null || imageData.length == 0) && (referredImageResult = (rptRuntimeCallback = (executionContext = (dataSetManager = _book.getDataSetManager()).getExecutionContext()).getRptRuntimeCallback()).loadReferredImage(imageFullPath)) != null) {
                                embededImageModel.setImageData(referredImageResult.getImageData());
                            }
                            dstImage.setModel(embededImageModel);
                        } else {
                            dstImage.setModel(new EmbededImageModel(model.getImageData()));
                        }
                        dstImage._placeImageAt(srcImage.getCellPosition());
                    }
                    if (dstEO instanceof FlashChart) {
                        ExecutorUtil.clearChartHyperLink((FlashChart)srcEO, !control.isSaveHyplink());
                        ((FlashChart)dstEO).setModel(((FlashChart)srcEO).getModel());
                        ((FlashChart)dstEO).enableExport4Snap();
                        continue;
                    }
                    if (dstEO instanceof EChart) {
                        ExecutorUtil.clearChartHyperLink((EChart)srcEO, !control.isSaveHyplink());
                        ((EChart)dstEO).setModel(((EChart)srcEO).getModel());
                        ((EChart)dstEO).enableExport4Snap();
                        continue;
                    }
                    if (!(dstEO instanceof QingChart)) continue;
                    ExecutorUtil.clearChartHyperLink((QingChart)srcEO, !control.isSaveHyplink());
                    ((QingChart)dstEO).setModel(((QingChart)srcEO).getModel());
                    ((QingChart)dstEO).enableExport4Snap();
                }
            }
            if (dstBook.isAutoCalculate()) {
                dstBook.setAutoCalculate(false);
                Sheet.ICellsIterator it = dstSheet.getCellsIterator(null, false, false);
                while (it.hasNext()) {
                    Object obj;
                    Cell dstCell = it.next();
                    Cell srcCell = srcSheet.getCell(dstCell.getRow(), dstCell.getCol(), false);
                    if (srcCell != null) {
                        dstCell.setExtProps(srcCell.getExtProps(false));
                    }
                    if (!(dstCell.getHyperLink() != null && control.isSaveHyplink() || saveStringLink.booleanValue())) {
                        dstCell.clearExtObject("inner_hyperlink");
                    }
                    if (!control.isSaveHyplink() && dstCell.getExtProps(false) != null && dstCell.getExtProps(false).getFormulas(false) != null) {
                        dstCell.getExtProps(false).getFormulas(false).remove(ExtConst.FORMULA_HYPERLINK);
                    }
                    if (!ExecutorUtil.handleHyperLink(dstSheet, dstCell)) continue;
                    Expr expr = dstCell.getExpr();
                    if (expr != null) {
                        IExprNode[] children = expr.getAllNodes();
                        for (int i = 0; i < children.length; ++i) {
                            if (ExecutorUtil.isAllExcelFuncNodes(children[i])) continue;
                            dstCell.setFormula(dstCell.getText());
                            break;
                        }
                    }
                    Variant value = dstCell.getValue();
                    if (srcCell != null) {
                        value = new Variant(srcCell.getValue().getValue(), srcCell.getValue().getVt());
                    }
                    if (value.isObject() && (obj = value.getValue()) instanceof DynamicAccessImageModel) {
                        value = Variant.nullVariant;
                    }
                    dstCell.setValue(value);
                }
                dstBook.setAutoCalculate(true);
            }
            ExecutorUtil.calcDisplayValue(srcSheet, dstSheet);
            if (!dstBook.isAutoCalculate() || !(isSecurity = ExtGuiExecutor.isSecurityHidedRowsOrCols(_book))) continue;
            int[] hiddenRows = srcSheet.getSecHidedRows();
            int[] hiddenCols = srcSheet.getSecHidedCols();
            AlgorithmUtil.delHideRowsAndCols(hiddenRows, hiddenCols, dstSheet);
        }
        return dstBook;
    }

    public static void clearChartHyperLink(ChartRectEmbedment embedment, boolean clear) {
        if (!clear) {
            return;
        }
        FlashChartModel model = embedment.getModel();
        if (model != null) {
            model.setInnerTargets(null);
            model.setExtTargets(null);
        }
    }

    public static boolean handleHyperLink(Sheet dstSheet, Cell dstCell) {
        ExtProps ep = dstCell.getExtProps(false);
        if (ep == null) {
            return false;
        }
        SortedExtPropFormulasArray formulas = ep.getFormulas(false);
        if (formulas == null) {
            return true;
        }
        ep.setFormulas((SortedExtPropFormulasArray)formulas.clone());
        formulas = ep.getFormulas(false);
        ICalculableProps prop = formulas.get(ExtConst.FORMULA_HYPERLINK);
        if (dstCell.getHyperLink() != null && prop != null) {
            prop = (ICalculableProps)prop.clone();
            formulas.set(formulas.search(ExtConst.FORMULA_HYPERLINK), prop);
            HyperlinkCalculableProps hyperLinkCalProps = (HyperlinkCalculableProps)prop;
            Map tars = hyperLinkCalProps.getTargets();
            tars = (Map)((HashMap)tars).clone();
            hyperLinkCalProps.setTargets(tars);
            ETTargets repTars = (ETTargets)tars.get("EXTRPT");
            if (repTars != null) {
                repTars = (ETTargets)repTars.clone();
                tars.put("EXTRPT", repTars);
                List targets = repTars.getTargets();
                ArrayList<ExtTransitionTarget> cTargets = new ArrayList<ExtTransitionTarget>(targets.size());
                repTars.setTargets(cTargets);
                for (ExtTransitionTarget target : targets) {
                    target = target.getDeepCopy();
                    Map<String, IParameter> params = target.getParameters();
                    ep.executeParams(params);
                    for (Map.Entry<String, IParameter> next : params.entrySet()) {
                        ICalculableProps p = (ICalculableProps)((Object)next.getValue());
                        p.setExpr(null);
                        if (p instanceof ParameterImpl) {
                            String formula = Variant2String.toString(((IParameter)((Object)p)).getValue());
                            if (!StringUtil.isEmptyString((String)formula)) {
                                p.setExpr(dstSheet.getExpr(dstCell, "=\"" + formula + "\""));
                            } else {
                                p.setExpr(null);
                            }
                            if (logger.isDebugEnabled()) {
                                logger.debug((Object)("trasition target new formula is:" + formula));
                            }
                        }
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("trasition target param values is:" + Variant2String.toString(((IParameter)((Object)p)).getValue())));
                    }
                    cTargets.add(target);
                }
            }
        }
        return true;
    }

    public static void calcDisplayValue(Sheet oldSheet, Sheet sheet) {
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, 1048575, 65535, false, true);
        while (iter.hasNext()) {
            Cell oldCell;
            SortedExtPropFormulasArray formulas;
            Cell cell = iter.next();
            ExtProps props = cell.getExtProps(false);
            if (props == null || (formulas = props.getFormulas(false)) == null || formulas.get(ExtConst.FORMULA_DISP_VALUE) == null || (oldCell = oldSheet.getCell(cell.getRow(), cell.getCol(), false)) == null) continue;
            if (oldSheet != sheet) {
                cell.setFormula(oldCell.getText());
                cell.setValue(new Variant(oldCell.getText(), 11));
            }
            formulas.insert(ExtConst.FORMULA_DISP_VALUE, "\"" + oldCell.getText() + "\"");
        }
    }

    public static boolean isAllExcelFuncNodes(IExprNode node) {
        int nodeType = node.getExprType();
        if (nodeType == 8) {
            NamedObjectNode no = (NamedObjectNode)node;
            Expr expr = no.getExpr();
            if (expr != null) {
                IExprNode[] children = expr.getAllNodes();
                for (int i = 0; i < children.length; ++i) {
                    if (ExecutorUtil.isAllExcelFuncNodes(children[i])) continue;
                    return false;
                }
            }
            return true;
        }
        if (node instanceof ExprMethod) {
            ExprMethod exprMethod = (ExprMethod)node;
            boolean isExcelMethod = exprMethod.isExcelMethod();
            if (isExcelMethod && exprMethod.getName().equalsIgnoreCase("REF")) {
                return false;
            }
            return isExcelMethod;
        }
        return true;
    }

    public static byte[] generateSnapShot(Book _book) throws IOException, KDFException, KDFSAXException, Exception {
        return ExecutorUtil.generateSnapShot(_book, new SnapReportControlModel());
    }
}

