/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.fulfil;

import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kdf.kds.KDSBook;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropFormulasArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.UserObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.EChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.subrpt.SubReportEmbed;

public class ExportUtil {
    public static void removeHideSheet(Book tempBook, KDSBook kdsbook) {
        UserObject uo = tempBook.getUserObject("EXPORT_HIDE_SHEETS");
        if (uo != null && !"true".equalsIgnoreCase(uo.getValue().toString())) {
            for (int i = 0; i < kdsbook.getSheetCount(); ++i) {
                if (!kdsbook.getSheet((Object)i).getSheetStyleAttributes().isHided()) continue;
                kdsbook.remove((Object)i);
                --i;
            }
        }
    }

    public static void setEmbedModel(Book tempBook, Book srcBook) throws SyntaxErrorException {
        int sheetCount = tempBook.getSheetCount();
        for (int sh = 0; sh < sheetCount; ++sh) {
            Sheet oldSheet = srcBook.getSheetByName(tempBook.getSheetName(sh));
            Sheet sheet = tempBook.getSheet(sh);
            ExportUtil.calcDisplayValue(oldSheet, sheet);
            EmbedhLayer oldLayer = oldSheet.getEmbedments(false);
            EmbedhLayer newLayer = sheet.getEmbedments(false);
            if (oldLayer == null || newLayer == null) continue;
            for (int i = 0; i < newLayer.size(); ++i) {
                EmbedObject eo = newLayer.getEmbed(i);
                if (eo instanceof FlashChart) {
                    ((FlashChart)eo).setModel(((FlashChart)oldLayer.getEmbed(i)).getModel());
                    ((FlashChart)eo).setCachedImg(((FlashChart)oldLayer.getEmbed(i)).getCachedImg());
                    ((FlashChart)eo).setSrc((FlashChart)oldLayer.getEmbed(i));
                    continue;
                }
                if (eo instanceof EChart) {
                    ((EChart)eo).setModel(((EChart)oldLayer.getEmbed(i)).getModel());
                    ((EChart)eo).setCachedImg(((EChart)oldLayer.getEmbed(i)).getCachedImg());
                    ((EChart)eo).setSrc((EChart)oldLayer.getEmbed(i));
                    continue;
                }
                if (eo instanceof QingChart) {
                    ((QingChart)eo).setModel(((QingChart)oldLayer.getEmbed(i)).getModel());
                    ((QingChart)eo).setCachedImg(((QingChart)oldLayer.getEmbed(i)).getCachedImg());
                    ((QingChart)eo).setSrc((QingChart)oldLayer.getEmbed(i));
                    continue;
                }
                if (eo instanceof SubReportEmbed) {
                    ((SubReportEmbed)eo).setImage(((SubReportEmbed)oldLayer.getEmbed(i)).getImage());
                    continue;
                }
                if (!(eo instanceof EmbedImage) || ((EmbedImage)eo).getModel() != null) continue;
                ((EmbedImage)eo).setModel(((EmbedImage)oldLayer.getEmbed(i)).getModel());
            }
        }
    }

    private static void calcDisplayValue(Sheet oldSheet, Sheet sheet) {
        Sheet.ICellsIterator iter = sheet.getCellsIterator(0, 0, 1048575, 65535, false, true);
        while (iter.hasNext()) {
            SortedExtPropFormulasArray formulas;
            Cell cell = iter.next();
            ExtProps props = cell.getExtProps(false);
            if (props == null || (formulas = props.getFormulas(false)) == null || formulas.get(ExtConst.FORMULA_DISP_VALUE) == null) continue;
            cell.setFormula(oldSheet.getCell(cell.getRow(), cell.getCol(), false).getText());
        }
    }

    public static boolean hasFlashChart(Book book) {
        for (int sheetCount = book.getSheetCount() - 1; sheetCount >= 0; --sheetCount) {
            EmbedhLayer layer = book.getSheet(sheetCount).getEmbedments(false);
            if (layer == null || layer.size() == 0) continue;
            return true;
        }
        return false;
    }
}

