/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.fulfil.extend;

import com.kingdee.cosmic.ctrl.common.hyperlink.IHyperLinkExec;
import com.kingdee.cosmic.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.cosmic.ctrl.ext.immit.ReportProperties;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.ExtFusionChartTransitionTarget;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.FusionChartTransitionResovler;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.HyperlinkCreator;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.exec.ExecutionContext;
import com.kingdee.cosmic.ctrl.kds.exec.ExtExecutor;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtConst;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSetManager;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtTransitionTarget;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.HyperlinkCalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ICalculableProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.expr.ExprContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.UserObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedObject;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChart;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class ExtFusionChartHyperLink
implements IHyperLinkExec {
    private IExtRuntimeDataProvider _dataProvider;
    private Book _book;
    private SpreadContext _context;

    public ExtFusionChartHyperLink(IExtRuntimeDataProvider dataProvider, Book book, SpreadContext context) {
        this._dataProvider = dataProvider;
        this._book = book;
        this._context = context;
    }

    private ExtFusionChartTransitionTarget parseHyperLink(String linkTo) {
        ExtFusionChartTransitionTarget ret;
        String[] args = linkTo.split("/");
        if (args.length > 3) {
            Cell cell = (Cell)HyperlinkCreator.fetchSrc(args[0]);
            ICalculableProps prop = cell.getExtProps(true).getFormulas(true).get(ExtConst.FORMULA_HYPERLINK);
            Map<String, Object> tars = ((HyperlinkCalculableProps)prop).getTargets();
            ETTargets et = (ETTargets)tars.get("EXTRPT");
            ExtTransitionTarget ett = et.getDefaultTarget();
            ret = new ExtFusionChartTransitionTarget(ett.getReportProps(), (Map)ett.getParameters());
            ret.setRelationChart(linkTo);
            ret.setCellRef(cell);
            ret.setQueryPolicy(Integer.parseInt(args[2]));
            ret.setViewPolicy(Integer.parseInt(args[3]));
            ret.setBindingPolicy(Integer.parseInt(args[4]));
        } else {
            ret = null;
            HyperlinkCreator.DrvierNamedObject[] names = (HyperlinkCreator.DrvierNamedObject[])HyperlinkCreator.fetchSrc(args[0]);
            Book book = null;
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    if (book == null) {
                        book = names[i].name.getBook();
                    }
                    if (book == null) {
                        book = names[i].name.getSheet().getBook();
                    }
                    names[i].name.setExpr(names[i].name.getSheet().getExpr(names[i].name, names[i].value));
                    names[i].name.setQueued(false);
                    names[i].name.queue();
                }
                if (null != book) {
                    boolean src = book.isAutoCalculate();
                    book.setAutoCalculate(true);
                    book.getDeps().calc();
                    book.setAutoCalculate(src);
                    book.fireBookPropertyChange(null, null, "Global_Repaint");
                }
            }
        }
        return ret;
    }

    private boolean checkHyperLinkExecuted(Book book, String linkTo, FlashChart transitionChart) {
        boolean ret = false;
        UserObject uo = book.getUserObject(linkTo);
        if (uo != null) {
            ret = true;
            FlashChart player = (FlashChart)uo.getValue();
            if (player.getPhysicalUI().getParent() == null) {
                return false;
            }
            FlashChartModel model = transitionChart.getModel();
            player.setModel(model);
            player.execute(model.getXml());
            Rectangle bounds = player.getBounds();
            Point p = bounds.getLocation();
            p.x += bounds.width / 2;
            p.y += bounds.height;
            int row = SheetBaseMath.rowAtPoint(book.getActiveSheet(), p);
            int col = SheetBaseMath.colAtPoint(book.getActiveSheet(), p);
            this._context.getSpread().scrollCellVisible(row, col);
        }
        return ret;
    }

    private Book executeTransitionReport(String link, ExtFusionChartTransitionTarget target) {
        Book transitionBook;
        block6: {
            transitionBook = null;
            try {
                UserObject uo = this._book.getUserObject(link + ":Data");
                if (uo != null) {
                    transitionBook = (Book)uo.getValue();
                }
                if (target == null) {
                    return null;
                }
                if (transitionBook == null) {
                    byte[] data = this.getTransitionChartData(target);
                    if (data == null) {
                        return null;
                    }
                    this.executeParams(target.getParameters(), target.getCellRef());
                    transitionBook = MiscUtil.unpack(data);
                    SpreadContext context = new SpreadContext();
                    MiscUtil.capacitateFiCalculation(context);
                    Map<String, IParameter> params = target.getParameters();
                    boolean shouldUseDemoData = !this._dataProvider.isAuthorizedReport() && this._book.getCloudRptUuid() != null && this._book.getUserObject("CLOUD_REPORT_DEMO_BOOK_DATA") != null;
                    this._book.getDataSetManager().getExecutionContext().setUseDemoData(shouldUseDemoData);
                    ExtExecutor.exec(transitionBook, this._dataProvider.fetchDataSetFactories(MiscUtil.collectExtDataSetTypes(this._book), this._book.getDataSetManager().getExecutionContext()), this.mergeMap(params, this._dataProvider.fetchSystemParameters()), null);
                }
                this._book.setUserObject(link + ":Data", transitionBook);
            }
            catch (Exception ex) {
                if (!MiscUtil.shouldLog()) break block6;
                MiscUtil.log(ex);
            }
        }
        return transitionBook;
    }

    private byte[] getTransitionChartData(ExtFusionChartTransitionTarget target) {
        byte[] ret = null;
        if (target == null) {
            return null;
        }
        ReportProperties fullName = target.getReportProps();
        ExecutionContext currentCtx = this._book.getDataSetManager().getExecutionContext();
        ret = this._dataProvider.getTransitionTargetData(fullName, currentCtx);
        return ret;
    }

    private void queryChart(String linkTo, ExtFusionChartTransitionTarget target) {
        boolean hyperLinkExecuted;
        boolean insameplayer;
        EmbedObject eo;
        int customerWidth = FlashChart.transitionBounds.width;
        int customerHeight = FlashChart.transitionBounds.height;
        int index = linkTo.indexOf(47);
        FlashChart nativeChart = FlashChart.CURRENT_FLASH;
        if (nativeChart == null || index < 0) {
            return;
        }
        linkTo = linkTo.substring(index);
        String cacheID = nativeChart.calcCellID(target.getCellRef(), target.getBindingPolicy());
        Book transitionBook = this.executeTransitionReport(linkTo + cacheID, target);
        if (transitionBook == null) {
            return;
        }
        FlashChart transitionChart = null;
        int sheetCount = transitionBook.getSheetCount();
        boolean out = true;
        for (int i = 0; i < sheetCount && out; ++i) {
            EmbedhLayer layer = transitionBook.getSheet(i).getEmbedments(false);
            if (layer == null) continue;
            int layerSize = layer.size();
            for (int j = 0; j < layerSize; ++j) {
                Object[] obj;
                eo = layer.getEmbed(j);
                if (!(eo instanceof FlashChart) || (obj = (Object[])(transitionChart = (FlashChart)eo).getModel().getDataNode().getData(FusionChartDataNode.CHART_ID)) == null || obj.length <= 0) continue;
                String chartID = ((Variant[][])obj[0])[0][0].toString();
                if (!target.getRelationChart().equals(chartID)) continue;
                out = false;
            }
        }
        boolean bl = insameplayer = target.getViewPolicy() == 0;
        if (transitionChart != null && insameplayer) {
            hyperLinkExecuted = false;
            hyperLinkExecuted = this.checkHyperLinkExecuted(this._book, "GLOBAL_TRANSITION_FUSIONCHART_PLAYER", transitionChart);
            if (hyperLinkExecuted) {
                FlashChart.transitionBounds.width = customerWidth;
                FlashChart.transitionBounds.height = customerHeight;
                return;
            }
        } else if (transitionChart != null) {
            hyperLinkExecuted = false;
            hyperLinkExecuted = this.checkHyperLinkExecuted(this._book, cacheID, transitionChart);
            if (hyperLinkExecuted) {
                FlashChart.transitionBounds.width = customerWidth;
                FlashChart.transitionBounds.height = customerHeight;
                return;
            }
        }
        Sheet sheet = nativeChart.getSheet();
        final EmbedhLayer layer1 = sheet.getEmbedments(true);
        if (transitionChart == null) {
            return;
        }
        Rectangle nativeBounds = null;
        nativeBounds = nativeChart.getBounds();
        nativeBounds.y += nativeBounds.height + 10;
        Rectangle transitionBounds = transitionChart.getBounds();
        nativeBounds.width = transitionBounds.width;
        nativeBounds.height = transitionBounds.height;
        transitionChart.setBounds(nativeBounds);
        Point p = nativeBounds.getLocation();
        p.x += nativeBounds.width / 2;
        p.y += nativeBounds.height;
        transitionChart.setTransitionChart(true);
        if (target.getViewPolicy() == 0) {
            int row = SheetBaseMath.rowAtPoint(sheet, p);
            int col = SheetBaseMath.colAtPoint(sheet, p);
            this._context.getSpread().scrollCellVisible(row, col);
            FlashChartModel model = new FlashChartModel();
            model.setBean((AbstractFusionBean)transitionChart.getModel().getBean().clone());
            model.setChartType(transitionChart.getModel().getChartType());
            model.setDataNode((FusionChartDataNode)transitionChart.getModel().getDataNode().clone());
            FlashChart chart = new FlashChart(transitionChart.getSheet(), model);
            chart.setBounds(nativeBounds);
            chart.setTransitionChart(true);
            layer1.addEmbed(chart);
            InputMap im = ((KDPanel)chart.getPhysicalUI()).getInputMap(2);
            im.put(KeyStroke.getKeyStroke(127, 0), "FUSIONCHART_DELETE_ACTION");
            ActionMap am = ((KDPanel)chart.getPhysicalUI()).getActionMap();
            am.put("FUSIONCHART_DELETE_ACTION", new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    layer1.removeSelectedEmbeds();
                    ExtFusionChartHyperLink.this._book.removeUserObject("GLOBAL_TRANSITION_FUSIONCHART_PLAYER");
                }
            });
            this._book.setUserObject("GLOBAL_TRANSITION_FUSIONCHART_PLAYER", chart);
        } else {
            InputMap im = ((KDPanel)transitionChart.getPhysicalUI()).getInputMap(2);
            im.put(KeyStroke.getKeyStroke(127, 0), "FUSIONCHART_DELETE_ACTION");
            ActionMap am = ((KDPanel)transitionChart.getPhysicalUI()).getActionMap();
            am.put("FUSIONCHART_DELETE_ACTION", new RemoveAction(cacheID));
            this._book.setUserObject(cacheID, transitionChart);
            UserObject uo = this._book.getUserObject("FUSIONCHART_HYPERLINK_PLAYER_COUNT");
            if (uo == null) {
                this._book.setUserObject("FUSIONCHART_HYPERLINK_PLAYER_COUNT", 1);
            } else {
                Integer playerCount = (Integer)uo.getValue();
                uo.setValue(playerCount + 1);
            }
            int size = layer1.size();
            Rectangle containerBounds = this._context.getSpread().getView(2, 2).getVisibleRect();
            int x = nativeBounds.x;
            for (int i = 0; i < size; ++i) {
                Rectangle bounds;
                Rectangle intersection;
                FlashChart chart;
                eo = layer1.getEmbed(i);
                if (!(eo instanceof FlashChart) || !(chart = (FlashChart)eo).isTransitionChart() || (intersection = nativeBounds.intersection(bounds = eo.getBounds())) == null) continue;
                if (nativeBounds.x + bounds.width + customerWidth <= containerBounds.width) {
                    nativeBounds.x += bounds.width + 5;
                    continue;
                }
                nativeBounds.x = x;
                nativeBounds.y += bounds.height + 5;
            }
            nativeBounds.width = customerWidth;
            nativeBounds.height = customerHeight;
            if (null != transitionChart) {
                transitionChart.setBounds(nativeBounds);
            }
            p = nativeBounds.getLocation();
            p.x += nativeBounds.width / 2;
            p.y += nativeBounds.height;
            int row = SheetBaseMath.rowAtPoint(sheet, p);
            int col = SheetBaseMath.colAtPoint(sheet, p);
            this._context.getSpread().scrollCellVisible(row, col);
            layer1.addEmbed(transitionChart);
            FlashChart.transitionBounds.width = customerWidth;
            FlashChart.transitionBounds.height = customerHeight;
        }
    }

    public synchronized void execute(final String linkTo) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ExtFusionChartTransitionTarget target = ExtFusionChartHyperLink.this.parseHyperLink(linkTo);
                    if (target != null) {
                        ExtFusionChartHyperLink.this.queryChart(linkTo, target);
                    }
                }
                finally {
                    FusionChartTransitionResovler.isHyperLinkExecuting = false;
                }
            }
        });
        try {
            SwingUtilities.invokeAndWait(t);
        }
        catch (Exception ex) {
            if (!MiscUtil.shouldLog()) {
                return;
            }
            MiscUtil.log(ex);
        }
    }

    private void executeParams(Map params, Cell activeCell) {
        ExprContext ctx = this._book.getDeps().getExprContext();
        ExtDataSetManager dm = this._book.getDataSetManager();
        ExtProps ep = activeCell.getExtProps(false);
        dm.resetCurrent();
        ep.setCurrentGroup();
        dm.resumeCurrent();
        ctx.pushExprOwner(activeCell);
        Iterator i = params.entrySet().iterator();
        while (i.hasNext()) {
            IParameter param = (IParameter)i.next().getValue();
            Variant var = ((ICalculableProps)((Object)param)).calc(ctx, activeCell);
            if (var == null) {
                var = Variant.nullVariant;
            }
            param.setValue(var);
        }
        ctx.popExprOwner();
    }

    private Map mergeMap(Map map1, Map map2) {
        if (map1 == null && map2 == null) {
            return null;
        }
        if (map1 != null && map2 == null) {
            return map1;
        }
        if (map1 == null && map2 != null) {
            return map2;
        }
        map1.putAll(map2);
        return map1;
    }

    private class RemoveAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private String cacheID;

        RemoveAction(String paramString) {
            this.cacheID = paramString;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExtFusionChartHyperLink.this._book.getActiveSheet().getEmbedments(true).removeSelectedEmbeds();
            ExtFusionChartHyperLink.this._book.removeUserObject(this.cacheID);
        }
    }
}

