/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.immit;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfig;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseType;
import com.kingdee.cosmic.ctrl.ext.util.ShowcaseUtil;

public class ShowcaseConfigCollection
implements Cloneable {
    private ShowcaseConfig[] configs;
    private ShowcaseConfig currentConfig;
    private String name;
    private boolean beenModified;
    private ShowcaseConfig defaultConfig;
    private String lastFilePath;

    public ShowcaseConfigCollection() {
        this(true, new ShowcaseType("default", 1));
    }

    public ShowcaseConfigCollection(boolean flag) {
    }

    public ShowcaseConfigCollection(boolean withDefault, ShowcaseType level) {
        if (withDefault) {
            this.addShowcaseConfig(new ShowcaseConfig(this));
            this.getDefaultConfig().setDefault(true);
            this.getDefaultConfig().setLevel(level);
        }
    }

    public ShowcaseConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public void setCurrentConfig(ShowcaseConfig currentConfig) {
        this.currentConfig = currentConfig;
    }

    public ShowcaseConfig getCurrentConfig() {
        if (this.currentConfig == null) {
            return this.defaultConfig;
        }
        return this.currentConfig;
    }

    public ShowcaseConfig[] getAllShowcaseConfig() {
        return this.configs;
    }

    public void addShowcaseConfig(ShowcaseConfig config) {
        if (config == null) {
            return;
        }
        if (this.configs == null || this.configs.length == 0) {
            this.configs = new ShowcaseConfig[1];
            this.configs[0] = config;
            this.currentConfig = config;
            this.defaultConfig = config;
        } else {
            if (this.findShowcaseConfig(config) != null) {
                return;
            }
            ShowcaseConfig[] temp = this.configs;
            this.configs = new ShowcaseConfig[temp.length + 1];
            this.configs[temp.length] = config;
            for (int i = 0; i < this.configs.length - 1; ++i) {
                this.configs[i] = temp[i];
            }
        }
        if (config.isDefault()) {
            this.defaultConfig = config;
        }
        this.setBeenModified(true);
    }

    public ShowcaseConfig findShowcaseConfig(ShowcaseConfig config) {
        if (this.configs == null) {
            return null;
        }
        for (int i = 0; i < this.configs.length; ++i) {
            String id1 = config.getShowcaseID();
            String id2 = this.configs[i].getShowcaseID();
            if (id1 == null) {
                id1 = config.getShowcaseName() + config.getLevel().getLevel();
            }
            if (id2 == null) {
                id2 = this.configs[i].getShowcaseName() + this.configs[i].getLevel().getLevel();
            }
            if (!id1.equals(id2)) continue;
            return this.configs[i];
        }
        return null;
    }

    public String toXml() {
        return this.toElement().toString();
    }

    public IXmlElement toElement() {
        IXmlElement element = XmlUtil.createNode((String)"report");
        element.setAttribute("name", this.name == null ? "temp" : this.name);
        if (this.configs != null) {
            int length = this.configs.length;
            for (int i = 0; i < length; ++i) {
                element.addChild(this.configs[i].toElement());
            }
        }
        return element;
    }

    public ShowcaseConfig getShowcaseConfigAt(int index) {
        if (this.configs != null && this.configs.length > 0 && this.configs.length - 1 >= index) {
            return this.configs[index];
        }
        return null;
    }

    public void switchDefaultNode(ShowcaseConfig config) {
        if (config == null) {
            return;
        }
        boolean flag = false;
        for (int i = this.configs.length - 1; i >= 0; --i) {
            if (this.configs[i] != config) continue;
            flag = true;
            this.configs[i] = this.configs[1];
            break;
        }
        if (flag) {
            this.configs[1] = config;
        }
    }

    public void setDefaultConfig(ShowcaseConfig config) {
        if (this.defaultConfig != null) {
            this.defaultConfig.setDefault(false);
        }
        this.defaultConfig = config;
        this.defaultConfig.setDefault(true);
    }

    public boolean saveShowcaseConfig(ShowcaseConfig config) {
        ShowcaseConfig temp = this.findShowcaseConfig(config);
        if (temp == null) {
            this.addShowcaseConfig(config);
        } else {
            temp.setEditable(config.isEditable());
            temp.setCellSelect(config.isCellSelect());
            temp.setColCountVisible(config.isColCountVisible());
            temp.setRowCountVisible(config.isRowCountVisible());
            temp.setShowFormula(config.isShowFormula());
            if (config.isDefault()) {
                this.getDefaultConfig().setDefault(false);
                temp.setDefault(true);
            }
            temp.setHideEditable(config.isHideEditable());
            temp.setColSpans(config.getColSpans());
            temp.setRowSpans(config.getRowSpans());
        }
        this.saveShowcaseSchemes(ShowcaseUtil.toShowcaseConfigs(this.toElement()), this.lastFilePath);
        return true;
    }

    public void saveShowcaseSchemes(String[] sScheme, String filePath) {
        String path = ShowcaseUtil.parseFilePath(filePath);
        ShowcaseUtil.saveFile(path, ShowcaseUtil.parseFromString(sScheme));
    }

    public ShowcaseConfig[] fetchAllShowcaseConfigByLevel(ShowcaseType level) {
        ShowcaseConfig[] configs = this.getAllShowcaseConfig();
        if (configs == null) {
            return null;
        }
        ShowcaseConfigCollection temp = new ShowcaseConfigCollection(true);
        int k = configs.length;
        for (int i = 0; i < k; ++i) {
            if (configs[i].getLevel().getLevel() != level.getLevel()) continue;
            temp.addShowcaseConfig(configs[i]);
        }
        return temp.getAllShowcaseConfig();
    }

    public ShowcaseConfig fetchShowcaseConfig(ShowcaseConfig config) {
        if (config != null) {
            if (this.configs == null || this.configs.length == 0) {
                this.configs = new ShowcaseConfig[1];
                this.configs[0] = config;
                this.currentConfig = config;
                this.defaultConfig = config;
            }
            for (int i = this.configs.length - 1; i >= 0; --i) {
                if (!config.equals(this.configs[i])) continue;
                return this.configs[i];
            }
        } else {
            return this.defaultConfig;
        }
        return null;
    }

    public boolean deleteConfig(ShowcaseConfig config) {
        int size;
        if (config == null) {
            return true;
        }
        boolean flag = false;
        int index = 0;
        for (int i = this.configs.length - 1; i >= 0; --i) {
            if (!this.configs[i].equals(config)) continue;
            flag = true;
            index = i;
            break;
        }
        if (flag) {
            size = this.configs.length;
            int j = 0;
            ShowcaseConfig[] temp = this.configs;
            this.configs = new ShowcaseConfig[size - 1];
            for (int i = 0; i < temp.length; ++i) {
                if (i == index) continue;
                this.configs[j] = temp[i];
                ++j;
            }
        }
        if (config.isDefault()) {
            this.defaultConfig = null;
            size = this.configs.length;
            for (int i = 0; i < size; ++i) {
                if (!this.configs[i].isDefault()) continue;
                this.defaultConfig = this.configs[i];
                break;
            }
        }
        return flag;
    }

    public boolean isBeenModified() {
        return this.beenModified;
    }

    public void setBeenModified(boolean beenModified) {
        this.beenModified = beenModified;
    }

    public String getLastFilePath() {
        return this.lastFilePath;
    }

    public void setLastFilePath(String lastFilePath) {
        this.lastFilePath = lastFilePath;
    }

    public String getName() {
        return this.name == null ? "default" : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object clone() {
        return "";
    }
}

