/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.pd.ui.embed;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.pd.ui.embed.EmbedXControl;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataInputStream;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataOutputStream;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.plaf.lfm.KDFontUIResource;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;

public class EmbedXLabel
extends EmbedXControl {
    private static final Logger logger = LogUtil.getPackageLogger(EmbedXLabel.class);
    private KDLabel _label;

    public EmbedXLabel(Sheet sheet) {
        super(sheet);
        this.initEmbed();
    }

    private void initEmbed() {
        this._label = new KDLabel();
        this._label.setHorizontalAlignment(0);
        this._label.setText(CtrlEXTMessages.getMLS("textLabel", "\u6587\u672c\u6807\u7b7e"));
        this.ui = this._label;
    }

    public void setText(String text) {
        this._label.setText(text);
    }

    public String getText() {
        return this._label.getText();
    }

    public void setFontSize(int size) {
        this._label.setFont(this._label.getFont().deriveFont((float)size));
    }

    public int getFontSize() {
        Font font = this._label.getFont();
        if (font instanceof KDFontUIResource) {
            return ((KDFontUIResource)font).getDrawingSize();
        }
        return font.getSize();
    }

    @Override
    protected byte[] saveCustom() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream(bs);
        try {
            out.writeString("1.0");
            out.writeBoolean(this.physical);
            out.writeString(this._label.getText());
            Font font = this._label.getFont();
            if (font instanceof KDFontUIResource) {
                out.writeInt(((KDFontUIResource)font).getDrawingSize());
            } else {
                out.writeInt(font.getSize());
            }
            out.close();
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return bs.toByteArray();
    }

    @Override
    protected void loadCustom(byte[] str, boolean create) {
        try {
            KDSDataInputStream is = new KDSDataInputStream(new ByteArrayInputStream(str));
            is.readString();
            this.physical = is.readBoolean();
            this._label.setText(is.readString());
            this._label.setFont(this._label.getFont().deriveFont((float)is.readInt()));
            is.close();
        }
        catch (IOException ioe) {
            logger.error((Object)"err", (Throwable)ioe);
        }
    }
}

