/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.pd.ui.embed;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.pd.ui.embed.EmbedXControl;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.IParameter;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataInputStream;
import com.kingdee.cosmic.ctrl.kds.util.KDSDataOutputStream;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import java.awt.Component;
import java.awt.Container;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.swing.JComponent;
import org.apache.log4j.Logger;

public abstract class ParamEmbedXControl
extends EmbedXControl {
    private static final Logger logger = LogUtil.getPackageLogger(ParamEmbedXControl.class);
    protected IParameter param;
    protected String paramName;

    public ParamEmbedXControl(Sheet sheet) {
        super(sheet);
        this.ui = new SimpleLabelContainer();
    }

    public void setParameter(IParameter param) {
        if (param == null) {
            return;
        }
        ((SimpleLabelContainer)this.ui).setLabelText(param.getAlias());
        this.param = param;
    }

    public IParameter getParameter() {
        if (this.paramName != null && this.param == null) {
            this.param = this._sheet.getBook().getDataSetManager().getExecutionContext().getDataSetParameter(this.paramName);
        }
        return this.param;
    }

    public void setLabelText(String text) {
        ((SimpleLabelContainer)this.ui).setLabelText(text);
    }

    public String getLabelText() {
        return ((SimpleLabelContainer)this.ui).getLabelText();
    }

    @Override
    protected byte[] saveCustom() {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        KDSDataOutputStream out = new KDSDataOutputStream(bs);
        try {
            out.writeString("1.0");
            out.writeBoolean(this.physical);
            if (this.param != null) {
                out.writeString(this.param.getName());
            } else if (this.paramName != null) {
                out.writeString(this.paramName);
            } else {
                out.writeString(null);
            }
            out.writeString(this.getLabelText());
            out.close();
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return bs.toByteArray();
    }

    @Override
    protected void loadCustom(byte[] str, boolean create) {
        try {
            KDSDataInputStream is = new KDSDataInputStream(new ByteArrayInputStream(str));
            String ver = is.readString();
            ver = ver + "";
            this.physical = is.readBoolean();
            this.paramName = is.readString();
            this.setLabelText(is.readString());
            is.close();
        }
        catch (IOException ioe) {
            logger.error((Object)"err", (Throwable)ioe);
        }
    }

    protected static class SimpleLabelContainer
    extends JComponent {
        private KDLabel _label;
        private JComponent _editor;

        SimpleLabelContainer() {
            this.init();
        }

        private void init() {
            this._label = new KDLabel();
            this._label.setText(CtrlEXTMessages.getMLS("parameterName", "\u53c2\u6570\u540d"));
            this._label.setUnderline(true);
            this.add((Component)this._label);
        }

        void setEditor(JComponent editor) {
            if (this._editor != null) {
                this.remove(this._editor);
            }
            this._editor = editor;
            this.add(this._editor);
            this.doLayout();
        }

        JComponent getEditor() {
            return this._editor;
        }

        void setLabelText(String text) {
            this._label.setText(text);
        }

        String getLabelText() {
            return this._label.getText();
        }

        @Override
        public void doLayout() {
            int w = this.getWidth();
            int h = this.getHeight();
            int milestone = (int)((double)w * 0.4);
            this._label.setBounds(0, 0, milestone, h);
            if (this._editor != null) {
                this._editor.setBounds(milestone, 0, w - milestone, h);
                this._editor.doLayout();
                this.validateContainer(this._editor);
            }
        }

        private void validateContainer(Container c) {
            for (int i = c.getComponentCount() - 1; i >= 0; --i) {
                Component comp = c.getComponent(i);
                if (!(comp instanceof Container)) continue;
                comp.doLayout();
                this.validateContainer((Container)comp);
            }
        }
    }
}

