/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.pe.animate;

import com.kingdee.cosmic.ctrl.ext.pe.animate.Move;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;
import org.jdesktop.animation.timing.Animator;
import org.jdesktop.animation.transitions.Effect;
import org.jdesktop.animation.transitions.EffectsManager;
import org.jdesktop.animation.transitions.ScreenTransition;
import org.jdesktop.animation.transitions.TransitionTarget;
import org.jdesktop.animation.transitions.effects.CompositeEffect;
import org.jdesktop.animation.transitions.effects.FadeIn;
import org.jdesktop.animation.transitions.effects.FadeOut;

public class AnimatedSlider
extends JComponent
implements TransitionTarget {
    private CompositeEffect scrollToLeftIn = null;
    private CompositeEffect scrollToRightIn = null;
    private CompositeEffect scrollFadeOut = null;
    private Animator animator = new Animator(300);
    private ScreenTransition transition = new ScreenTransition((JComponent)this, (TransitionTarget)this, this.animator);
    private int currentSlide = -1;
    private ArrayList slides = new ArrayList();
    private GestureListener gestureListener = new GestureListener();
    private boolean isScrollingToLeft;

    public AnimatedSlider() {
        this.setLayout(new BorderLayout());
        this.animator.setAcceleration(0.2f);
        this.animator.setDeceleration(0.4f);
        this.animator.setResolution(0);
        this.setBorder(BorderFactory.createLineBorder(Color.decode("#b3b3b3")));
        this.setFocusable(false);
        this.installGestureListener(this);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        Move mover = new Move(width, 0);
        FadeIn fader = new FadeIn();
        this.scrollToLeftIn = new CompositeEffect((Effect)mover);
        this.scrollToLeftIn.addEffect((Effect)fader);
        mover = new Move(-width, 0);
        fader = new FadeIn();
        this.scrollToRightIn = new CompositeEffect((Effect)mover);
        this.scrollToRightIn.addEffect((Effect)fader);
        mover = new Move(0, 0);
        FadeOut fadeOut = new FadeOut();
        this.scrollFadeOut = new CompositeEffect((Effect)mover);
        this.scrollFadeOut.addEffect((Effect)fadeOut);
    }

    public void addSlide(JComponent slideEditor) {
        this.slides.add(slideEditor);
        if (this.currentSlide < 0) {
            this.currentSlide = 0;
            this.add(slideEditor);
        }
        this.installGestureListener(slideEditor);
    }

    private void installGestureListener(Component c) {
        c.addMouseListener(this.gestureListener);
        c.addMouseMotionListener(this.gestureListener);
        c.addKeyListener(this.gestureListener);
        if (c instanceof Container) {
            Container ref = (Container)c;
            int count = ref.getComponentCount();
            for (int i = 0; i < count; ++i) {
                this.installGestureListener(ref.getComponent(i));
            }
        }
    }

    @Override
    public void requestFocus() {
        JComponent slide = this.getCurrentSlide();
        if (slide != null) {
            slide.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    public JComponent getCurrentSlide() {
        if (this.currentSlide < 0) {
            return null;
        }
        return (JComponent)this.slides.get(this.currentSlide);
    }

    public void setupNextScreen() {
        this.removeAll();
        if (this.isScrollingToLeft) {
            ++this.currentSlide;
            if (this.currentSlide == this.slides.size()) {
                this.currentSlide = 0;
            }
            JComponent comp = (JComponent)this.slides.get(this.currentSlide);
            this.add(comp);
            comp.requestFocus();
        } else {
            --this.currentSlide;
            if (this.currentSlide < 0) {
                this.currentSlide = this.slides.size() - 1;
            }
            JComponent comp = (JComponent)this.slides.get(this.currentSlide);
            this.add(comp);
            comp.requestFocus();
        }
    }

    public void setupEffectsForLeftScrolling() {
        int slideCount = this.slides.size();
        if (slideCount < 2) {
            return;
        }
        this.isScrollingToLeft = true;
        EffectsManager.clearAllEffects();
        int index = this.currentSlide + 1;
        if (index == slideCount) {
            index = 0;
        }
        JComponent comp = (JComponent)this.slides.get(index);
        EffectsManager.setEffect((JComponent)comp, (Effect)this.scrollToLeftIn, (EffectsManager.TransitionType)EffectsManager.TransitionType.APPEARING);
        this.transition.start();
    }

    public void setupEffectsForRightScrolling() {
        int slideCount = this.slides.size();
        if (slideCount < 2) {
            return;
        }
        this.isScrollingToLeft = false;
        EffectsManager.clearAllEffects();
        int index = this.currentSlide - 1;
        if (index == -1) {
            index = slideCount - 1;
        }
        JComponent comp = (JComponent)this.slides.get(index);
        EffectsManager.setEffect((JComponent)comp, (Effect)this.scrollToRightIn, (EffectsManager.TransitionType)EffectsManager.TransitionType.APPEARING);
        this.transition.start();
    }

    private class GestureListener
    extends MouseInputAdapter
    implements KeyListener {
        private Point previousLocation;
        private boolean cancelMove = false;

        private GestureListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.previousLocation = e.getPoint();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            int modifiers = e.getModifiers();
            this.cancelMove = (modifiers & 4) == 0;
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (this.cancelMove) {
                return;
            }
            int hDisplacement = (int)(e.getPoint().getX() - this.previousLocation.getX());
            if (hDisplacement > 0) {
                AnimatedSlider.this.setupEffectsForRightScrolling();
            } else if (hDisplacement < 0) {
                AnimatedSlider.this.setupEffectsForLeftScrolling();
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.isAltDown() && e.getKeyCode() == 37) {
                AnimatedSlider.this.setupEffectsForLeftScrolling();
            } else if (e.isAltDown() && e.getKeyCode() == 39) {
                AnimatedSlider.this.setupEffectsForRightScrolling();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    }
}

