/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.pe.beans.editor;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.immit.AbstractHyperLinkAssembler;
import com.kingdee.cosmic.ctrl.ext.immit.ExtHyperLinkAssembler;
import com.kingdee.cosmic.ctrl.ext.immit.IHyperTabContext;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.AbstractPropertyEditor;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.CustomEditorPanel;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.TransitionLinkTypePanel;
import com.kingdee.cosmic.ctrl.ext.pe.beans.editor.extend.HyperlinkBehaviorAssembler;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExternalTargets;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import com.kingdee.cosmic.ctrl.swing.MessageDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;

public class TransitionTargetPropertyEditor
extends AbstractPropertyEditor {
    private CustomEditorPanel editor = new CustomEditorPanel();
    private TransitionTargetImpresario impresario;
    private Object[] _targets;
    private boolean isEditting = false;

    public TransitionTargetPropertyEditor() {
        this.editor.addPopActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TransitionTargetPropertyEditor.this.impresario == null) {
                    TransitionTargetPropertyEditor.this.impresario = new TransitionTargetImpresario((Frame)SwingUtilities.getWindowAncestor((Component)((Object)TransitionTargetPropertyEditor.this.editor)));
                }
                TransitionTargetPropertyEditor.this.impresario.configFromCell();
                TransitionTargetPropertyEditor.this.setEditting(true);
                TransitionTargetPropertyEditor.this.impresario.show();
            }
        });
    }

    @Override
    public Component getCustomEditor() {
        return this.editor;
    }

    @Override
    public Object getValue() {
        return this._targets;
    }

    @Override
    public void setValue(Object value) {
        String msg;
        if (value == null) {
            msg = CtrlEXTMessages.getMLS("unset", "[\u672a\u8bbe\u7f6e]");
        } else {
            this._targets = (Object[])value;
            msg = CtrlEXTMessages.getMLS("set", "[\u5df2\u8bbe\u7f6e]");
        }
        this.editor.setText(msg);
    }

    public static TransitionLinkTypePanel getLinkTypePanel() {
        return new TransitionLinkTypePanel();
    }

    public static void configLinkSet(TransitionLinkTypePanel linkTypePanel, String configName) {
        linkTypePanel.configLinkSet(linkTypePanel, configName);
    }

    public boolean isEditting() {
        return this.isEditting;
    }

    public void setEditting(boolean isEdit) {
        this.isEditting = isEdit;
    }

    static /* synthetic */ Object[] access$402(TransitionTargetPropertyEditor x0, Object[] x1) {
        x0._targets = x1;
        return x1;
    }

    private class TransitionTargetImpresario
    extends KDDialog {
        private KDButton ok;
        private KDButton cancel;
        private KDExt ext;
        private ExtHyperLinkAssembler defaultAssembler;
        private HyperlinkBehaviorAssembler _behaviorAssembler;
        private KDTabbedPane tabbedPane;
        private AbstractHyperLinkAssembler[] assemblers;
        private KDPanel panel;
        private TransitionLinkTypePanel linkTypePanel;

        private TransitionTargetImpresario(Frame parent) {
            super(parent);
            this.ext = (KDExt)((Object)parent);
            this.initComps();
            this.initListeners();
            this.setModal(true);
            this.setResizable(true);
            this.setLocationRelativeTo(null);
        }

        private void initComps() {
            this.setSize(560, 580);
            this.setTitle(CtrlEXTMessages.getMLS("reportLinkageSettings", "\u62a5\u8868\u8054\u67e5/\u8054\u52a8\u8bbe\u7f6e"));
            this.panel = new KDPanel();
            this.panel.setCustomInsets(new Insets(8, 8, 5, 8));
            TableLayout2 layout = new TableLayout2(3, 4);
            this.panel.setLayout((LayoutManager)layout);
            layout.setRatableWidth(1, 1);
            layout.setFixedWidth(0, 400);
            layout.setFixedHeight(0, 20);
            layout.setRatableHeight(1, 1);
            layout.setRowSpacing(0, 5);
            layout.setFixedWidth(2, 75);
            layout.setFixedHeight(2, 25);
            layout.setFixedWidth(3, 75);
            layout.setRowSpacing(1, 5);
            layout.setColSpacing(2, 8);
            this.ok = new KDButton();
            this.cancel = new KDButton();
            this.tabbedPane = new KDTabbedPane();
            this.defaultAssembler = new ExtHyperLinkAssembler(this.ext);
            this.tabbedPane.addTab(CtrlEXTMessages.getMLS("infoTitle", "\u62a5\u8868\u8054\u67e5"), (Component)((Object)this.defaultAssembler));
            if (!MiscUtil.getActiveSpreadContext(this.ext).getBook().is4Mobile()) {
                this.installOuterSpaceAssemblers();
            }
            this._behaviorAssembler = new HyperlinkBehaviorAssembler();
            this._behaviorAssembler.setDescription(CtrlEXTMessages.getMLS("linkage", "\u8054\u67e5"));
            this.tabbedPane.addTab(CtrlEXTMessages.getMLS("QueryBehavior", "\u8054\u67e5\u884c\u4e3a"), (Component)((Object)this._behaviorAssembler));
            if (TransitionTargetPropertyEditor.this._targets != null && TransitionTargetPropertyEditor.this._targets.length > 0) {
                this._behaviorAssembler.syncSettings(TransitionTargetPropertyEditor.this._targets, MiscUtil.getActiveSpreadContext(this.ext).getBook().getActiveSheet().getActiveCell());
            }
            this.ok.setText(CtrlEXTMessages.getMLS("KEY_OK", "\u786e\u5b9a"));
            this.cancel.setText(CtrlEXTMessages.getMLS("KEY_CANCEL", "\u53d6\u6d88"));
            this.linkTypePanel = TransitionTargetPropertyEditor.getLinkTypePanel();
            this.panel.add((Component)((Object)this.linkTypePanel), (Object)TableLayout2.param((int)0, (int)0));
            this.panel.add((Component)this.ok, (Object)TableLayout2.param((int)2, (int)2));
            this.panel.add((Component)this.cancel, (Object)TableLayout2.param((int)2, (int)3));
            this.panel.add((Component)this.tabbedPane, (Object)TableLayout2.param((int)1, (int)0, (int)1, (int)3));
            this.add((Component)this.panel);
        }

        private void installOuterSpaceAssemblers() {
            this.assemblers = this.ext.getExtCallback().getContainerDefinedHyperLinkAssemblers();
            if (this.assemblers == null) {
                return;
            }
            for (int i = 0; i < this.assemblers.length; ++i) {
                this.tabbedPane.addTab(this.assemblers[i].getDisplayName(), (Component)((Object)this.assemblers[i]));
            }
        }

        private void initListeners() {
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ExternalTargets externals = null;
                    if (TransitionTargetImpresario.this.assemblers != null) {
                        int size = TransitionTargetImpresario.this.assemblers.length;
                        for (int i = 0; i < size; ++i) {
                            AbstractHyperLinkAssembler current = TransitionTargetImpresario.this.assemblers[i];
                            if (current.checkValid()) {
                                List<Map<String, Object>> list = current.getAssembledTargets();
                                if (list == null) continue;
                                if (externals == null) {
                                    externals = new ExternalTargets();
                                }
                                externals.addTargets(list);
                                if (externals.getDefaultIndex() != -1) continue;
                                externals.setDefaultTarget(current.getSuggestedDefaultTarget());
                                continue;
                            }
                            return;
                        }
                        KDTabbedPane parentPane = (KDTabbedPane)TransitionTargetImpresario.this.defaultAssembler.getParent();
                        Component[] components = parentPane.getComponents();
                        HashSet retainSet = new HashSet(8);
                        HashSet<String> tempSet = new HashSet<String>(8);
                        for (Component component : components) {
                            if (!(component instanceof IHyperTabContext)) continue;
                            IHyperTabContext tabContext = (IHyperTabContext)((Object)component);
                            Set<String> alias = tabContext.getAlias();
                            retainSet.addAll(tempSet);
                            retainSet.retainAll(alias);
                            if (!retainSet.isEmpty()) {
                                TransitionTargetImpresario.this.showMsgBox("\u3010" + tabContext.getDisplayName() + CtrlEXTMessages.getMLS("sameDisplayNameInBrackets", "\u3011\u4e2d\u5b58\u5728\u76f8\u540c\u7684\u663e\u793a\u540d\u79f0\u3010") + retainSet.toArray()[0] + "\u3011");
                                return;
                            }
                            tempSet.addAll(alias);
                        }
                    }
                    if (!TransitionTargetImpresario.this.defaultAssembler.commit(TransitionTargetImpresario.this.linkTypePanel)) {
                        return;
                    }
                    TransitionTargetPropertyEditor.access$402(TransitionTargetPropertyEditor.this, TransitionTargetImpresario.this.defaultAssembler.getTargets());
                    if (TransitionTargetPropertyEditor.this._targets == null) {
                        if (externals != null) {
                            TransitionTargetPropertyEditor.access$402(TransitionTargetPropertyEditor.this, new Object[2]);
                            ((TransitionTargetPropertyEditor)TransitionTargetPropertyEditor.this)._targets[1] = externals;
                        }
                    } else {
                        Object[] biGroup = new Object[]{TransitionTargetPropertyEditor.this._targets[0], externals, TransitionTargetPropertyEditor.this._targets[2]};
                        if (biGroup[0] == null && biGroup[1] == null && biGroup[2] == null) {
                            biGroup = null;
                        }
                        TransitionTargetPropertyEditor.access$402(TransitionTargetPropertyEditor.this, biGroup);
                    }
                    if (TransitionTargetPropertyEditor.this._targets == null) {
                        TransitionTargetPropertyEditor.this.editor.setText(CtrlEXTMessages.getMLS("unset", "[\u672a\u8bbe\u7f6e]"));
                    } else {
                        TransitionTargetPropertyEditor.this.editor.setText(CtrlEXTMessages.getMLS("set", "[\u5df2\u8bbe\u7f6e]"));
                        TransitionTargetImpresario.this._behaviorAssembler.commit(TransitionTargetPropertyEditor.this._targets, MiscUtil.getActiveSpreadContext(TransitionTargetImpresario.this.ext).getBook().getActiveSheet().getActiveCell());
                    }
                    TransitionTargetImpresario.this.setVisible(false);
                    TransitionTargetPropertyEditor.this.setEditting(false);
                }
            });
            this.cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TransitionTargetImpresario.this.setVisible(false);
                }
            });
            this.linkTypePanel.getOuterBtn().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        return;
                    }
                    TransitionTargetImpresario.this.changeLinkSet(e);
                }
            });
            this.linkTypePanel.getInnerBtn().addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 2) {
                        return;
                    }
                    TransitionTargetImpresario.this.changeLinkSet(e);
                }
            });
        }

        private void configFromCell() {
            ExternalTargets externalTargets;
            Cell owner = MiscUtil.getActiveSpreadContext(this.ext).getBook().getActiveSheet().getActiveCell();
            this.defaultAssembler.configFromCell(TransitionTargetPropertyEditor.this._targets, owner);
            ExternalTargets externalTargets2 = externalTargets = TransitionTargetPropertyEditor.this._targets == null ? null : (ExternalTargets)TransitionTargetPropertyEditor.this._targets[1];
            if (this.assemblers != null) {
                for (AbstractHyperLinkAssembler current : this.assemblers) {
                    if (externalTargets == null) {
                        current.setAssembledTargets(null);
                        continue;
                    }
                    current.setAssembledTargets(externalTargets.getTargetsByVendor(current));
                }
            }
            if (TransitionTargetPropertyEditor.this._targets != null && TransitionTargetPropertyEditor.this._targets[0] != null) {
                TransitionTargetPropertyEditor.configLinkSet(this.linkTypePanel, "outerLink");
            }
            if (TransitionTargetPropertyEditor.this._targets != null && TransitionTargetPropertyEditor.this._targets[2] != null) {
                TransitionTargetPropertyEditor.configLinkSet(this.linkTypePanel, "innerLink");
            }
        }

        private void changeLinkSet(ItemEvent e) {
            Component itemComp = (Component)e.getItem();
            if ("outerLink".equals(itemComp.getName())) {
                this.tabbedPane.setTitleAt(0, CtrlEXTMessages.getMLS("infoTitle", "\u62a5\u8868\u8054\u67e5"));
                if (this.assemblers != null) {
                    for (int i = 0; i < this.assemblers.length; ++i) {
                        this.tabbedPane.addTab(this.assemblers[i].getDisplayName(), (Component)((Object)this.assemblers[i]));
                    }
                }
                this.tabbedPane.addTab(CtrlEXTMessages.getMLS("QueryBehavior", "\u8054\u67e5\u884c\u4e3a"), (Component)((Object)this._behaviorAssembler));
                this.defaultAssembler.changeLinkSet(e);
                this.tabbedPane.setSelectedIndex(0);
            } else {
                this.tabbedPane.removeAll();
                this.tabbedPane.add(CtrlEXTMessages.getMLS("reportQuery", "\u62a5\u8868\u8054\u52a8"), (Component)((Object)this.defaultAssembler));
                this.defaultAssembler.changeLinkSet(e);
            }
            this.validate();
            this.repaint();
        }

        private void showMsgBox(String msg) {
            MessageDialog.show((Component)this.defaultAssembler.getParent(), (Object)msg, (String)CtrlEXTMessages.getMLS("msgTitle", "\u4fe1\u606f\u63d0\u793a"), (int)-1, (int)1, (int)0, null);
        }
    }
}

