/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.rd.celltree;

import com.kingdee.cosmic.ctrl.ext.rd.celltree.ICellTreeRenderModel;
import com.kingdee.cosmic.ctrl.ext.rd.celltree.LevelModel;
import com.kingdee.cosmic.ctrl.ext.rd.celltree.TreeCellUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;

public class CellTreeRenderModel4UI
implements ICellTreeRenderModel {
    private Cell _cell;
    private int _level = Integer.MAX_VALUE;
    private boolean _hasNode = true;
    private int _nodeType = 0;
    private LevelModel _levelModel;

    public CellTreeRenderModel4UI(Cell cell) {
        this._cell = cell;
        this.modelInit();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void modelInit() {
        int nextRowId;
        int level;
        SortedAttributeSpanArray sasa;
        block17: {
            CellBlock block;
            if (!this.isRowXorColumnCellTreeDisplay()) {
                this._hasNode = false;
                return;
            }
            int id = 0;
            boolean isCol = this.isColCellDisplay();
            if (isCol) {
                id = this._cell.getRow();
                sasa = this._cell.getSheet().getRowSpans();
            } else {
                id = this._cell.getCol();
                sasa = this._cell.getSheet().getColSpans();
            }
            level = -1;
            int nextIndex = 0;
            if (this.isFront()) {
                nextIndex = id + 1;
                if (this._cell.isFirstMergedCell()) {
                    block = this._cell.getMerge(true);
                    nextIndex = isCol ? (nextIndex += block.getRow2() - block.getRow()) : (nextIndex += block.getCol2() - block.getCol());
                }
            } else {
                nextIndex = id - 1;
            }
            block = this._cell.getMerge(true);
            nextRowId = id + 1;
            int spanPos = -1;
            if (block != null) {
                if (isCol) {
                    spanPos = sasa.searchSpan(block.getRow2());
                    nextRowId = block.getRow2() + 1;
                } else {
                    spanPos = sasa.searchSpan(block.getCol2());
                    nextRowId = block.getCol2() + 1;
                }
            } else {
                spanPos = sasa.searchSpan(id);
            }
            if (spanPos < 0) {
                spanPos = sasa.searchSpan(nextRowId);
                if (spanPos >= 0 && ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() > 0) {
                    level = 0;
                    break block17;
                } else {
                    this._hasNode = false;
                    return;
                }
            }
            level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
        }
        int nextRowLevel = 0;
        int nextSpanPos = sasa.searchSpan(nextRowId);
        if (nextSpanPos >= 0) {
            nextRowLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).getOutlineGroupLevel();
        }
        if (level == 0 && nextRowLevel == 0) {
            this._hasNode = false;
            return;
        }
        if (level < nextRowLevel) {
            this._nodeType = !((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).isVisible() ? 2 : 1;
        }
        this._levelModel = TreeCellUtil.getLevelModel(this._cell, level, nextRowLevel);
    }

    @Override
    public boolean isRowXorColumnCellTreeDisplay() {
        return !(this.isColCellDisplay() && this.isRowCellDisplay() || !this.isColCellDisplay() && !this.isRowCellDisplay());
    }

    @Override
    public int getLevel() {
        if (this._level != Integer.MAX_VALUE) {
            return this._level;
        }
        if (this.isColCellDisplay()) {
            this._level = TreeCellUtil.queryCellLevel(this._cell);
        }
        if (this.isRowCellDisplay()) {
            this._level = TreeCellUtil.queryCellLevelWhenRowCellTreeDisplay(this._cell);
        }
        return this._level;
    }

    @Override
    public boolean isColCellDisplay() {
        return TreeCellUtil.isColumnCellTreeDisplay(this._cell);
    }

    @Override
    public boolean isRowCellDisplay() {
        return TreeCellUtil.isRowCellTreeDisplay(this._cell);
    }

    @Override
    public LevelModel getLevelModel() {
        return this._levelModel;
    }

    @Override
    public int getNodeType() {
        return this._nodeType;
    }

    @Override
    public boolean hasNode() {
        return this._hasNode;
    }

    @Override
    public boolean isFront() {
        return TreeCellUtil.isFront(this._cell);
    }
}

