/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.rd.celltree;

import com.kingdee.cosmic.ctrl.ext.rd.celltree.TreeCellUtil;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;

public class TreeCellColRender
implements IBasicRender {
    public static final int CellWidth = 14;
    private Color baseColor = new Color(61, 78, 124);
    private Stroke stroke = new BasicStroke(1.0f);
    private Stroke dashStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{1.0f}, 0.0f);

    public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
        Rectangle r = (Rectangle)clip;
        r = new Rectangle(r.x - 1, r.y, r.width + 1, r.height);
        Graphics2D g2d = (Graphics2D)graphics;
        g2d.setColor(this.baseColor);
        Shape oldClip = g2d.getClip();
        if (object instanceof Cell) {
            Cell cell = (Cell)object;
            if (!TreeCellUtil.isRowCellTreeDisplay(cell)) {
                return;
            }
            if (TreeCellUtil.isCellRowAndColumenTreeDisplay(cell)) {
                return;
            }
            g2d.setClip(r);
            if (cell.getSheet().isLeftToOutlineGroup()) {
                this.drawLeft(g2d, cell, r);
            } else {
                this.drawRight(g2d, cell, r);
            }
        }
        g2d.setClip(oldClip);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void drawRight(Graphics2D g2d, Cell cell, Rectangle r) {
        int colId = cell.getCol();
        Sheet sheet = cell.getSheet();
        SortedAttributeSpanArray sasa = sheet.getColSpans();
        int spanPos = sasa.searchSpan(colId);
        int level = -1;
        if (spanPos < 0) {
            spanPos = sasa.searchSpan(colId - 1);
            if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return;
            level = 0;
        } else {
            level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
        }
        int colX = r.x;
        int colWidth = r.width;
        int prevColLevel = 0;
        int prevSpanPos = sasa.searchSpan(colId - 1);
        if (prevSpanPos >= 0) {
            prevColLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(prevSpanPos)).getOutlineGroupLevel();
        }
        if (level == 0 && prevColLevel == 0) {
            return;
        }
        int prevColWidth = SheetBaseMath.getColWidth(sheet, colId - 1);
        g2d.setStroke(this.stroke);
        if (level < prevColLevel) {
            int y;
            int x;
            int basePos;
            if (prevColWidth == 0) {
                basePos = r.y + 11 * level;
                x = colX + 2 + (colWidth - 14) / 2;
                y = basePos + 2;
                TreeCellUtil.drawRectangle(g2d, x, y, 11, 11);
                g2d.drawLine(x + 2, y + 5, x + 8, y + 5);
                g2d.drawLine(x + 5, y + 2, x + 5, y + 8);
            } else {
                basePos = r.y + 11 * level;
                x = colX + 2 + (colWidth - 14) / 2;
                y = basePos + 2;
                TreeCellUtil.drawRectangle(g2d, x, y, 11, 11);
                g2d.drawLine(x + 2, y + 5, x + 8, y + 5);
                g2d.setStroke(this.dashStroke);
                g2d.drawLine(colX, y + 5, x - 1, y + 5);
                g2d.setStroke(this.stroke);
            }
        }
        for (int j = level - 1; j >= 0; --j) {
            int basePos;
            int m;
            boolean conjunctive = false;
            int m2 = colId + 1;
            while (true) {
                int iteratedLevel;
                int iteratedSpanPos = sasa.searchSpan(m2);
                SortedAttributeSpanArray.AttributeSpan span = null;
                if (iteratedSpanPos < 0) {
                    iteratedLevel = 0;
                } else {
                    span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                    iteratedLevel = span.getOutlineGroupLevel();
                }
                if (iteratedLevel == j) {
                    conjunctive = true;
                    break;
                }
                if (iteratedLevel < j) break;
                if (span != null) {
                    m2 = span.getEnd();
                }
                ++m2;
            }
            if (!conjunctive) continue;
            boolean existPossibleHandler = false;
            SortedAttributeSpanArray.AttributeSpan currentSpan = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos);
            for (m = colId - 1; m >= currentSpan.getStart(); --m) {
                if (SheetBaseMath.getColWidth(sheet, m) <= 0) continue;
                existPossibleHandler = true;
                break;
            }
            if (!existPossibleHandler) {
                int pos;
                m = currentSpan.getStart() - 1;
                block3: while ((pos = sasa.searchSpan(m)) >= 0) {
                    SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(pos);
                    if (lookupAs != currentSpan && lookupAs.getEnd() <= colId) {
                        if (lookupAs.getOutlineGroupLevel() <= j) break;
                        for (int n = lookupAs.getEnd(); n >= lookupAs.getStart(); --n) {
                            if (SheetBaseMath.getColWidth(sheet, n) <= 0 || SheetBaseMath.getColWidth(sheet, n) <= 0) continue;
                            boolean sTry = false;
                            int x = n + 1;
                            while (true) {
                                int iteratedLevel;
                                int iteratedSpanPos = sasa.searchSpan(x);
                                SortedAttributeSpanArray.AttributeSpan span = null;
                                if (iteratedSpanPos < 0) {
                                    iteratedLevel = 0;
                                } else {
                                    span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                                    iteratedLevel = span.getOutlineGroupLevel();
                                }
                                if (iteratedLevel == j) {
                                    sTry = true;
                                    break;
                                }
                                if (iteratedLevel < j) break;
                                if (span != null) {
                                    x = span.getEnd();
                                }
                                ++x;
                            }
                            if (!sTry) continue;
                            existPossibleHandler = true;
                            break block3;
                        }
                    }
                    --m;
                }
            }
            if (!existPossibleHandler || j >= prevColLevel) {
                basePos = r.y + j * 11 + 7;
                g2d.drawLine(colX + colWidth / 2, basePos, colX + colWidth / 2, basePos + 5);
                g2d.setStroke(this.dashStroke);
                g2d.drawLine(colX + colWidth / 2, basePos, colX + colWidth, basePos);
                g2d.setStroke(this.stroke);
                continue;
            }
            basePos = r.y + j * 11 + 7;
            g2d.setStroke(this.dashStroke);
            g2d.drawLine(colX - 2, basePos, colX + colWidth + 2, basePos);
            g2d.setStroke(this.stroke);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void drawLeft(Graphics2D g2d, Cell cell, Rectangle r) {
        int colId = cell.getCol();
        Sheet sheet = cell.getSheet();
        SortedAttributeSpanArray sasa = sheet.getColSpans();
        int spanPos = sasa.searchSpan(colId);
        int level = -1;
        if (spanPos < 0) {
            spanPos = sasa.searchSpan(colId + 1);
            if (spanPos < 0 || ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel() <= 0) return;
            level = 0;
        } else {
            level = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos)).getOutlineGroupLevel();
        }
        int colX = r.x;
        int colWidth = r.width;
        int nextColLevel = 0;
        int nextSpanPos = sasa.searchSpan(colId + 1);
        if (nextSpanPos >= 0) {
            nextColLevel = ((SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(nextSpanPos)).getOutlineGroupLevel();
        }
        if (level == 0 && nextColLevel == 0) {
            return;
        }
        int nextColWidth = SheetBaseMath.getColWidth(sheet, colId + 1);
        g2d.setStroke(this.stroke);
        if (level < nextColLevel) {
            int y;
            int x;
            int basePos;
            boolean isCollapse;
            boolean bl = isCollapse = nextColWidth == 0;
            if (nextColWidth == 0) {
                basePos = r.y + 11 * level;
                x = colX + 2 + (colWidth - 14) / 2;
                y = basePos + 2;
                TreeCellUtil.drawRectangle(g2d, x, y, 11, 11);
                g2d.drawLine(x + 2, y + 5, x + 8, y + 5);
                g2d.drawLine(x + 5, y + 2, x + 5, y + 8);
            } else {
                basePos = r.y + 11 * level;
                x = colX + 2 + (colWidth - 14) / 2;
                y = basePos + 2;
                TreeCellUtil.drawRectangle(g2d, x, y, 11, 11);
                g2d.drawLine(x + 2, y + 5, x + 8, y + 5);
                g2d.setStroke(this.dashStroke);
                g2d.drawLine(x + 14 - 3, y + 5, colX + colWidth, y + 5);
                g2d.setStroke(this.stroke);
            }
        }
        for (int j = level - 1; j >= 0; --j) {
            int basePos;
            int m;
            boolean conjunctive = false;
            int m2 = colId - 1;
            while (true) {
                int iteratedLevel;
                int iteratedSpanPos = sasa.searchSpan(m2);
                SortedAttributeSpanArray.AttributeSpan span = null;
                if (iteratedSpanPos < 0) {
                    iteratedLevel = 0;
                } else {
                    span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                    iteratedLevel = span.getOutlineGroupLevel();
                }
                if (iteratedLevel == j) {
                    conjunctive = true;
                    break;
                }
                if (iteratedLevel < j) break;
                if (span != null) {
                    m2 = span.getStart();
                }
                --m2;
            }
            if (!conjunctive) continue;
            boolean existPossibleHandler = false;
            SortedAttributeSpanArray.AttributeSpan currentSpan = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(spanPos);
            for (m = colId + 1; m <= currentSpan.getEnd(); ++m) {
                if (SheetBaseMath.getColWidth(sheet, m) <= 0) continue;
                existPossibleHandler = true;
                break;
            }
            if (!existPossibleHandler) {
                int pos;
                m = currentSpan.getEnd() + 1;
                block3: while ((pos = sasa.searchSpan(m)) >= 0) {
                    SortedAttributeSpanArray.AttributeSpan lookupAs = sasa.getAttributeSpan(pos);
                    if (lookupAs != currentSpan && lookupAs.getStart() >= colId) {
                        if (lookupAs.getOutlineGroupLevel() <= j) break;
                        for (int n = lookupAs.getStart(); n <= lookupAs.getEnd(); ++n) {
                            if (SheetBaseMath.getColWidth(sheet, n) <= 0) continue;
                            boolean sTry = false;
                            int x = n - 1;
                            while (true) {
                                int iteratedLevel;
                                int iteratedSpanPos = sasa.searchSpan(x);
                                SortedAttributeSpanArray.AttributeSpan span = null;
                                if (iteratedSpanPos < 0) {
                                    iteratedLevel = 0;
                                } else {
                                    span = (SortedAttributeSpanArray.AttributeSpan)sasa.getSpan(iteratedSpanPos);
                                    iteratedLevel = span.getOutlineGroupLevel();
                                }
                                if (iteratedLevel == j) {
                                    sTry = true;
                                    break;
                                }
                                if (iteratedLevel < j) break;
                                if (span != null) {
                                    x = span.getStart();
                                }
                                --x;
                            }
                            if (!sTry) continue;
                            existPossibleHandler = true;
                            break block3;
                        }
                    }
                    ++m;
                }
            }
            if (!existPossibleHandler || j >= nextColLevel) {
                basePos = r.y + j * 11 + 7;
                g2d.drawLine(colX + colWidth / 2, basePos, colX + colWidth / 2, basePos + 4);
                g2d.setStroke(this.dashStroke);
                g2d.drawLine(colX, basePos, colX + colWidth / 2, basePos);
                g2d.setStroke(this.stroke);
                continue;
            }
            basePos = r.y + j * 11 + 7;
            g2d.setStroke(this.dashStroke);
            g2d.drawLine(colX, basePos, colX + colWidth, basePos);
            g2d.setStroke(this.stroke);
        }
    }
}

