/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.rd.model.beans;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.cosmic.ctrl.ext.rd.model.beans.CellContextBean;
import com.kingdee.cosmic.ctrl.ext.rd.model.beans.IllegalFormulaException;
import com.kingdee.cosmic.ctrl.ext.rd.model.beans.TableContextBeanBeanInfo;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.struct.UserObject;

public class TableContextBean
extends CellContextBean {
    public static final String RESIZED_IN_RUNTIME = "resizedInRuntime";
    public static final String SHEET_HIDE_RUNTIME = "sheetHideRuntime";
    public static final String SHEET_EXTENSIBLE = "sheetExtensible";
    public static final int INT_EXTEND = 1;
    public static final int INT_EXTEND_NONE = 0;

    public void setRowHeight(int width) {
        this._sheet.getBook().getSelectionRange().setRowHeight(width);
    }

    public int getRowHeight() {
        Integer height = this._sheet.getBook().getSelectionRange().getRowHeight();
        if (height == null) {
            return 19;
        }
        return height;
    }

    public void setColumnWidth(int width) {
        this._sheet.getBook().getSelectionRange().setColumnWidth(width);
    }

    public int getColumnWidth() {
        Integer width = this._sheet.getBook().getSelectionRange().getColumnWidth();
        if (width == null) {
            return 72;
        }
        return width;
    }

    public boolean isResizedInRuntime() {
        return this._sheet.getUserObject(RESIZED_IN_RUNTIME) != null;
    }

    public void setResizedInRuntime(boolean resizedInRuntime) {
        if (resizedInRuntime) {
            this._sheet.setUserObject(RESIZED_IN_RUNTIME, Boolean.TRUE);
        } else {
            this._sheet.removeUserObject(RESIZED_IN_RUNTIME);
        }
    }

    public BooleanVFPair isSheetHide() {
        String formula = null;
        UserObject uo = this._sheet.getUserObject(SHEET_HIDE_RUNTIME);
        if (uo != null) {
            formula = (String)uo.getValue();
        }
        if (!StringUtil.isEmptyString(formula)) {
            return new BooleanVFPair(null, formula);
        }
        return new BooleanVFPair(false, null);
    }

    public void setSheetHide(BooleanVFPair sheetHide) {
        String formula = sheetHide.getFormula();
        Object value = sheetHide.getValue();
        if (StringUtil.isEmptyString((String)formula) && value != null) {
            this._sheet.removeUserObject(SHEET_HIDE_RUNTIME);
            if (this._sheet.getBook().getVisibleSheetCount() > 1) {
                this._sheet.setHide((Boolean)value);
                this._sheet.getBook().setActiveSheet(this._sheet.getSheetIndex());
            }
        } else if (!StringUtil.isEmptyString((String)formula)) {
            Expr expr = this._sheet.getExpr(null, formula);
            if (expr == null || expr.isSyntaxError() || expr.hasUnknownMethod()) {
                throw new IllegalFormulaException();
            }
            this._sheet.setUserObject(SHEET_HIDE_RUNTIME, formula);
        } else {
            this._sheet.removeUserObject(SHEET_HIDE_RUNTIME);
        }
    }

    public TableContextBeanBeanInfo.ExtensibleNamedIntegerVFPair getSheetExtensible() {
        Object uo = this._sheet.getUserObjectValue(SHEET_EXTENSIBLE);
        if (uo != null) {
            Integer value = uo instanceof Integer ? (Integer)uo : Integer.valueOf((String)uo);
            return new TableContextBeanBeanInfo.ExtensibleNamedIntegerVFPair(value, null);
        }
        return new TableContextBeanBeanInfo.ExtensibleNamedIntegerVFPair((Integer)1, null);
    }

    public void setSheetExtensible(TableContextBeanBeanInfo.ExtensibleNamedIntegerVFPair sheetExtensible) {
        Object value = sheetExtensible.getValue();
        if (value != null) {
            this._sheet.setUserObject(SHEET_EXTENSIBLE, value);
        } else {
            this._sheet.setUserObject(SHEET_EXTENSIBLE, 1);
        }
    }
}

