/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.rd.ui.views.peview.style;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.rd.model.style.StyleScheme;
import com.kingdee.cosmic.ctrl.ext.rd.model.style.StyleSchemeUtil;
import com.kingdee.cosmic.ctrl.ext.rd.ui.views.peview.style.StyleAreaManager;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.ToolTipManager;

class BigIconPanel
extends KDPanel {
    private KDLabel labelName;
    private StyleScheme styleScheme;
    private KDPanel imagePanel;
    private ImageIcon iconHelp;
    private KDLabel labelHelp;
    private StyleAreaManager areaManager;
    private static final int V_GAP = 2;

    public BigIconPanel(StyleScheme styleScheme) {
        this.styleScheme = styleScheme;
        this.initComponents();
    }

    private void initComponents() {
        this.areaManager = new StyleAreaManager(this.styleScheme);
        KDPanel panelHeader = this.areaManager.getStyleAreaHeader().getAreaPanel();
        KDPanel panelBody = this.areaManager.getStyleAreaBody().getAreaPanel();
        KDPanel panelFooter = this.areaManager.getStyleAreaFooter().getAreaPanel();
        this.imagePanel = new KDPanel();
        TableLayout2 layout = new TableLayout2(3, 1);
        layout.setRowSpacing(0, 2);
        layout.setRowSpacing(1, 2);
        layout.setFixedHeight(0, panelHeader.getHeight());
        layout.setFixedHeight(1, panelBody.getHeight());
        layout.setRatableHeight(2, 1);
        this.imagePanel.setLayout((LayoutManager)layout);
        this.imagePanel.add((Component)panelHeader, (Object)TableLayout2.param((int)0, (int)0));
        this.imagePanel.add((Component)panelBody, (Object)TableLayout2.param((int)1, (int)0));
        this.imagePanel.add((Component)panelFooter, (Object)TableLayout2.param((int)2, (int)0));
        int height = panelHeader.getHeight() + 2 + panelBody.getHeight() + 2 + panelFooter.getHeight();
        this.imagePanel.setSize(panelHeader.getWidth(), height);
        this.labelName = new KDLabel(this.styleScheme.getSchemeType().getAlias());
        this.labelName.setBounds(8, 6, 150, 25);
        BufferedImage img = (BufferedImage)StyleSchemeUtil.getImage("img/help.png");
        this.iconHelp = new ImageIcon(img);
        this.labelHelp = new KDLabel((Icon)this.iconHelp);
        this.labelHelp.setCursor(Cursor.getPredefinedCursor(12));
        this.labelHelp.setToolTipText(CtrlEXTMessages.getMLS("applyStyleToSelectedCells", "\u70b9\u51fb\u8868\u5934\u884c\u3001\u8868\u4f53\u533a\u57df\u6216\u603b\u8ba1\u884c\u533a\u57df\uff0c\u53ef\u5c06\u5bf9\u5e94\u7684\u6837\u5f0f\u5e94\u7528\u5230\u9f20\u6807\u9009\u4e2d\u7684\u62a5\u8868\u5355\u5143\u683c\u533a\u57df"));
        this.labelHelp.addMouseListener((MouseListener)new MouseAdapter(){
            int showDelay = ToolTipManager.sharedInstance().getInitialDelay();
            int MissDelay = ToolTipManager.sharedInstance().getDismissDelay();

            @Override
            public void mouseEntered(MouseEvent e) {
                ToolTipManager.sharedInstance().setInitialDelay(0);
                ToolTipManager.sharedInstance().setDismissDelay(30000);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ToolTipManager.sharedInstance().mouseExited(e);
                ToolTipManager.sharedInstance().setInitialDelay(this.showDelay);
                ToolTipManager.sharedInstance().setDismissDelay(this.MissDelay);
            }
        });
        this.setLayout(null);
        height = height + this.labelName.getHeight() + 2;
        this.setPreferredSize(new Dimension(this.getWidth(), height));
        this.add((Component)this.labelName);
        this.add((Component)this.labelHelp);
        this.add((Component)this.imagePanel);
    }

    public void setExt(KDExt ext) {
        this.areaManager.setExt(ext);
    }

    public void refreshStyleScheme(StyleScheme styleScheme) {
        this.areaManager.getStyleAreaHeader().stopStyleBrushState();
        this.styleScheme = styleScheme;
        this.labelName.setText(styleScheme.getSchemeType().getAlias());
        this.areaManager.setStyleScheme(styleScheme);
        this.areaManager.setStyleBrushButtonSelected(null);
        this.repaint();
    }

    public void doLayout() {
        super.doLayout();
        int width = this.imagePanel.getWidth();
        int height = this.imagePanel.getHeight();
        int x = (this.getWidth() - width) / 2;
        int y = (this.getHeight() - height) / 2;
        int hLabel = this.labelName.getHeight();
        y = y > hLabel ? y : hLabel;
        this.imagePanel.setBounds(x, y, width, height);
        this.labelHelp.setBounds(this.getWidth() - this.iconHelp.getIconWidth() - 5, 6, this.iconHelp.getIconWidth(), this.iconHelp.getIconHeight());
    }
}

