/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.rd.ui.views.peview.style;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.rd.model.style.StyleScheme;
import com.kingdee.cosmic.ctrl.ext.rd.ui.views.peview.style.BigIconPanel;
import com.kingdee.cosmic.ctrl.ext.rd.ui.views.peview.style.SmallIconPanel;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDSplitPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;

public class StyleSchemePanel
extends KDPanel {
    private static final int H_GAP = 3;
    private static final int V_GAP = 5;
    private BigIconPanel bigIconPanel;
    private List<SmallIconPanel> listSmallIconPanel;

    public StyleSchemePanel(List<StyleScheme> listStyleScheme) {
        this.initComponents(listStyleScheme);
        this.initListeners();
    }

    private void initComponents(List<StyleScheme> listStyleScheme) {
        SmallIconListPanel smallIconListPanel = new SmallIconListPanel();
        smallIconListPanel.setPreferredSize(new Dimension(150, 200));
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        flowLayout.setHgap(3);
        flowLayout.setVgap(5);
        smallIconListPanel.setLayout(flowLayout);
        this.listSmallIconPanel = new ArrayList<SmallIconPanel>(listStyleScheme.size());
        for (StyleScheme styleScheme : listStyleScheme) {
            SmallIconPanel smallIconPanel = new SmallIconPanel(styleScheme);
            if (styleScheme == listStyleScheme.get(0)) {
                smallIconPanel.refreshSelected(true);
            }
            smallIconListPanel.add((Component)((Object)smallIconPanel));
            this.listSmallIconPanel.add(smallIconPanel);
        }
        KDScrollPane smallIconScrollPanel = new KDScrollPane((Component)((Object)smallIconListPanel));
        smallIconScrollPanel.setPreferredSize(new Dimension(150, 280));
        smallIconScrollPanel.setMinimumSize(new Dimension(250, 138));
        smallIconScrollPanel.setHorizontalScrollBarPolicy(31);
        smallIconScrollPanel.setVerticalScrollBarPolicy(20);
        smallIconScrollPanel.setBorder(BorderFactory.createEtchedBorder(1));
        KDPanel smallIconParentPanel = new KDPanel();
        BorderLayout layout = new BorderLayout();
        layout.setVgap(5);
        smallIconParentPanel.setLayout((LayoutManager)layout);
        KDLabel labelSmallIconTitle = new KDLabel(CtrlEXTMessages.getMLS("selectAppearanceStyle", "\u9009\u62e9\u5916\u89c2\u6837\u5f0f"));
        labelSmallIconTitle.setCustomInsets(new Insets(0, 10, 0, 0));
        smallIconParentPanel.add((Component)labelSmallIconTitle, (Object)"North");
        smallIconParentPanel.add((Component)smallIconScrollPanel, (Object)"Center");
        this.bigIconPanel = new BigIconPanel(listStyleScheme.get(0));
        KDScrollPane scrollPanelbigIcon = new KDScrollPane((Component)((Object)this.bigIconPanel));
        scrollPanelbigIcon.setMinimumSize(new Dimension(250, 70));
        scrollPanelbigIcon.setBorder(BorderFactory.createEtchedBorder(1));
        KDSplitPane splitPanelStyle = new KDSplitPane();
        splitPanelStyle.setOrientation(0);
        splitPanelStyle.setTopComponent((Component)smallIconParentPanel);
        splitPanelStyle.setBottomComponent((Component)scrollPanelbigIcon);
        KDPanel panelParent = new KDPanel();
        panelParent.setLayout((LayoutManager)new BorderLayout());
        panelParent.add((Component)splitPanelStyle, (Object)"Center");
        this.setLayout(new BorderLayout());
        this.add((Component)panelParent, "Center");
    }

    public void setExt(KDExt ext) {
        this.bigIconPanel.setExt(ext);
    }

    private void initListeners() {
        for (int i = 0; i < this.listSmallIconPanel.size(); ++i) {
            this.listSmallIconPanel.get(i).addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    SmallIconPanel smallIconPanel = (SmallIconPanel)((Object)e.getSource());
                    if (smallIconPanel.isSelected()) {
                        return;
                    }
                    for (int i = 0; i < StyleSchemePanel.this.listSmallIconPanel.size(); ++i) {
                        SmallIconPanel sip = (SmallIconPanel)((Object)StyleSchemePanel.this.listSmallIconPanel.get(i));
                        if (!sip.isSelected()) continue;
                        sip.refreshSelected(false);
                        break;
                    }
                    smallIconPanel.refreshSelected(true);
                    StyleSchemePanel.this.bigIconPanel.refreshStyleScheme(smallIconPanel.getStyleScheme());
                }
            });
        }
    }

    private static class SmallIconListPanel
    extends KDPanel {
        private SmallIconListPanel() {
        }

        public void doLayout() {
            super.doLayout();
            int smallIconPanelWidth = this.getComponent(0).getWidth();
            int smallIconPanelHeight = this.getComponent(0).getHeight();
            int colWidth = smallIconPanelWidth + 3;
            int colCount = this.getWidth() / colWidth;
            int size = this.getComponentCount();
            double rowCount = Math.ceil((double)size / (double)colCount);
            int rowHeight = smallIconPanelHeight + 5;
            Dimension preSize = this.getPreferredSize();
            preSize.setSize(preSize.getWidth(), rowCount * (double)rowHeight);
            this.setPreferredSize(preSize);
        }
    }
}

