/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.reporting;

import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.dlg.AbstractFormulaWizardDialog;
import com.kingdee.cosmic.ctrl.swing.IKDEditor;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.event.DataChangeListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

public class FormulaEditor
extends KDPanel
implements IKDEditor {
    private static final long serialVersionUID = 1L;
    private KDTextField _txtFormula;
    private KDWorkButton _btnFunc;
    private ActionListener _listener;
    private ReportingFormulaWizzard _wizzard;
    private Dialog _reportingWizzard;
    private KDExt _ext;

    public FormulaEditor() {
        this.setLayout(new LayoutManager(){

            @Override
            public void addLayoutComponent(String name, Component comp) {
            }

            @Override
            public void layoutContainer(Container parent) {
                int width = parent.getWidth();
                int height = parent.getHeight();
                int btnSize = width / 2 > 16 ? 16 : width / 2;
                FormulaEditor.this._btnFunc.setBounds(width - btnSize, 0, btnSize, height);
                FormulaEditor.this._txtFormula.setBounds(0, 0, width - btnSize, height);
            }

            @Override
            public Dimension minimumLayoutSize(Container parent) {
                return null;
            }

            @Override
            public Dimension preferredLayoutSize(Container parent) {
                return null;
            }

            @Override
            public void removeLayoutComponent(Component comp) {
            }
        });
        this._txtFormula = new KDTextField();
        this._txtFormula.setBorder(null);
        this._btnFunc = new KDWorkButton();
        this._btnFunc.setOpaque(false);
        this._btnFunc.setBorder(null);
        this._btnFunc.setFocusable(false);
        this._btnFunc.setIcon((Icon)ResourceManager.getImageIcon("func_new.png"));
        this.add((Component)this._txtFormula);
        this.add((Component)this._btnFunc);
        this._listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (FormulaEditor.this._ext == null) {
                    FormulaEditor.this._ext = FormulaEditor.this.getExt();
                    if (FormulaEditor.this._ext == null) {
                        return;
                    }
                    FormulaEditor.this._ext.getFormulaWizardMisc().createSharedFormulaWizard();
                    FormulaEditor.this._reportingWizzard = FormulaEditor.this.getReportingSettingWizzard();
                    FormulaEditor.this._wizzard = new ReportingFormulaWizzard(FormulaEditor.this._ext);
                }
                if (FormulaEditor.this._reportingWizzard != null) {
                    FormulaEditor.this._reportingWizzard.setVisible(false);
                }
                String formula = FormulaEditor.this._txtFormula.getText();
                FormulaEditor.this._wizzard.setEditingData(formula);
                FormulaEditor.this._wizzard.showDialog();
            }
        };
        this._btnFunc.addActionListener(this._listener);
    }

    private KDExt getExt() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof KDExt)) continue;
            return (KDExt)((Object)parent);
        }
        return null;
    }

    private Dialog getReportingSettingWizzard() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof Dialog)) continue;
            return (Dialog)parent;
        }
        return null;
    }

    private void showOpposite() {
        if (this._reportingWizzard != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FormulaEditor.this._reportingWizzard.setVisible(true);
                }
            });
        }
    }

    public void addDataChangeListener(DataChangeListener listener) {
    }

    public Object getValue() {
        return this._txtFormula.getText();
    }

    public boolean isDisplay() {
        return true;
    }

    public void removeDataChangeListener(DataChangeListener listener) {
    }

    public void setDisplay(boolean isDisplay) {
    }

    public void setValue(Object value) {
        this._txtFormula.setText((String)value);
    }

    private class ReportingFormulaWizzard
    extends AbstractFormulaWizardDialog {
        private static final long serialVersionUID = 1L;

        protected ReportingFormulaWizzard(KDExt ext) {
            super(ext);
        }

        @Override
        protected void acceptEditResult() {
            String formula = this.getEditingData();
            FormulaEditor.this._txtFormula.setText(formula);
            FormulaEditor.this.showOpposite();
        }

        @Override
        protected void beforeClosed() {
            FormulaEditor.this.showOpposite();
        }
    }
}

