/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.reporting;

import com.kingdee.cosmic.ctrl.ext.reporting.DemoReportingRuntimeProvider;
import com.kingdee.cosmic.ctrl.ext.reporting.IReportingRuntimeProvider;
import com.kingdee.cosmic.ctrl.ext.reporting.ReportingModelLoader;
import com.kingdee.cosmic.ctrl.ext.reporting.ReportingModelSaver;
import com.kingdee.cosmic.ctrl.ext.reporting.model.CommitType;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IReportingModel;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import java.io.IOException;
import org.apache.log4j.Logger;

public class ReportingFactory {
    private static Logger logger = Logger.getLogger(ReportingFactory.class);
    public static IReportingRuntimeProvider runtimeProvider_instance;

    public static IReportingRuntimeProvider fetchRuntimeProvider() {
        if (runtimeProvider_instance == null) {
            runtimeProvider_instance = new DemoReportingRuntimeProvider();
            logger.info((Object)"not suitable IReportingRuntimeProvider\uff0cdemo provider will be used!");
        }
        return runtimeProvider_instance;
    }

    public static String save(IReportingModel model) {
        try {
            return new ReportingModelSaver().save(model);
        }
        catch (IOException e) {
            return null;
        }
    }

    public static IReportingModel load(Book book, String modelString) {
        try {
            return new ReportingModelLoader().load(ReportingFactory.fetchRuntimeProvider().createEmptyReportingModel(), book, modelString);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static CommitType getReportingBookCommitType(Book book) {
        IReportingModel model = book.getReportingModel();
        return model == null || !model.isEnabled() ? null : model.getCommitType();
    }
}

