/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.reporting.dirty;

import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.reporting.dirty.ExtReportingDirtyManager;
import com.kingdee.cosmic.ctrl.ext.reporting.dirty.OffsetRange;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IEditorDefine;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IUpdateConstraint;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.editor.ExtReportingEditorManager;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.editor.IRuntimeEditorDefine;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.style.ShareStyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.StyleAttributes;
import com.kingdee.cosmic.ctrl.kdf.util.style.Styles;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.expans.model.collection.SortedExtPropsArray;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.PasteMode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetAction_InsDel;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.Validation;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.ValidationList;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.util.MessagedValidate;
import com.kingdee.cosmic.ctrl.kds.model.util.SortedCellBlockArray;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class InsertDataPlanCreator {
    private static Logger logger = Logger.getLogger(InsertDataPlanCreator.class);
    private ExtReportingDirtyManager _manager;
    private Sheet _activeSheet;
    private Cell _activeCll;

    public InsertDataPlanCreator(ExtReportingDirtyManager manager) {
        this._manager = manager;
    }

    public InsertDataPlanCreator(ExtReportingDirtyManager manager, Sheet activeSheet) {
        this._manager = manager;
        this._activeSheet = activeSheet;
    }

    public void addInsertDataPlan(Cell hotSpot) {
        this._activeSheet = hotSpot.getSheet();
        this._activeCll = hotSpot;
        ExtProps props = hotSpot.getExtProps(true);
        Cell srcCll = props.getSource().getCell();
        IUpdateConstraint[] constraints = this._manager._cell2ConstraintMap.get(srcCll);
        OffsetRange r = this.insertAllBrotherCells();
        if (r != null) {
            this.refreshEmpty(constraints, r);
        }
    }

    private void refreshEmpty(IUpdateConstraint[] constraints, OffsetRange r) {
        if (constraints == null) {
            return;
        }
        for (int i = 0; i < constraints.length; ++i) {
            Sheet.ICellsIterator iter = this._activeSheet.getCellsIterator(r.activeRange.getBlock(0), true, false);
            this.expandVerifyArea(r.activeRange, r.direction);
            while (iter.hasNext()) {
                boolean shouldCommit;
                boolean needCommit;
                Cell cell = iter.next();
                int row = cell.getRow();
                int col = cell.getCol();
                Validation vl = this._activeSheet.getValidations().getValidationContainer(row, col);
                boolean bl = needCommit = vl != null && vl.isReportingValidation();
                if (!needCommit) continue;
                cell.setValue(Variant.nullVariant);
                cell.setFormula(null);
                IEditorDefine editorDefine = vl.getEditorDefine();
                IRuntimeEditorDefine define = editorDefine.generateRuntimeEditorDefine();
                if (define == null) continue;
                define.createEditor();
                define.prepareToShow(this._activeSheet, row, col);
                String commitFormula = define.getCommitFormula();
                MessagedValidate mv = vl.getMessagedValidate();
                boolean b = commitFormula == null || mv == null || mv.isValidated(this._activeSheet, commitFormula) || mv.isErrorHide();
                boolean bl2 = shouldCommit = b && !StringUtil.isEmptyString((String)commitFormula);
                if (!shouldCommit) continue;
                define.commitValue();
                ExtReportingEditorManager.applyText(editorDefine, this._activeSheet, row, col);
            }
        }
        this._manager._book.fireBookPropertyChange(null, null, "Global_Repaint");
    }

    private OffsetRange insertAllBrotherCells() {
        OffsetRange offset = new OffsetRange();
        ExtProps activeProps = this._activeCll.getExtProps(false);
        ExtProps head = activeProps.getSource().getHead(true, false);
        if (head == null || head.isCell00()) {
            head = activeProps;
        }
        boolean bl = offset.direction = head.getExtensible(false) != 1;
        while (activeProps != null && !activeProps.isCell00() && !activeProps.isReportingGroupRootProps()) {
            activeProps = activeProps.getHead(offset.direction, false);
        }
        if (activeProps == null || activeProps.isCell00()) {
            logger.info((Object)"can not find suitable place to break in,program return null");
            return null;
        }
        CellBlock[] lastRowCBAndInsertRowCB = this.findLastRowCBAndInsertRowCB(activeProps, offset);
        if (lastRowCBAndInsertRowCB == null) {
            logger.info((Object)"can not find lastRowCBAndInsertRowCB");
            return null;
        }
        CellBlock lastRowCB = lastRowCBAndInsertRowCB[0];
        CellBlock insertRowCB = lastRowCBAndInsertRowCB[1];
        CellBlock lastMainCellIndex = lastRowCBAndInsertRowCB[2];
        CellBlock lastSubBounds = lastRowCBAndInsertRowCB[3];
        Range insertRange = new Range(this._manager._book, this._activeSheet, insertRowCB);
        insertRange.setIgnoreProtected(true);
        SheetAction_InsDel insert = new SheetAction_InsDel(insertRange, true, offset.direction);
        boolean succeed = insert.run();
        if (!succeed) {
            logger.info((Object)"can not insert new cells,program return null");
            return null;
        }
        Range srcRange = new Range(this._manager._book, this._activeSheet, lastRowCB);
        offset.activeRange = insertRange;
        srcRange.copy();
        succeed = insertRange.paste(PasteMode.ALL, new String[0]);
        if (!succeed) {
            logger.info((Object)"can not paste new cells,program return null");
            return null;
        }
        Sheet.ICellsIterator iter = this._activeSheet.getCellsIterator(insertRowCB, false, false);
        Cell lastMainCell = this._activeSheet.getCell(lastMainCellIndex.getRow(), lastMainCellIndex.getCol(), true);
        int newMainRow = offset.direction ? lastMainCell.getRow() + lastSubBounds.getHeight() : lastMainCell.getRow();
        int newMainCol = !offset.direction ? lastMainCell.getCol() + lastSubBounds.getWidth() : lastMainCell.getCol();
        Cell newMainCell = this._activeSheet.getCell(newMainRow, newMainCol, true);
        newMainCell.setExtProps(null);
        ExtProps newMainProps = newMainCell.getExtProps(true);
        if (!offset.direction) {
            newMainProps.setExtensible(1);
        }
        ExtProps lastMainProps = lastMainCell.getExtProps(false);
        newMainProps.setSource(lastMainProps.getSource());
        newMainProps.setHead(lastMainProps.getHead(true, false), true);
        newMainProps.setHead(lastMainProps.getHead(false, true), false);
        newMainProps.setWidth(lastMainProps.getWidth());
        newMainProps.setHeight(lastMainProps.getHeight());
        newMainProps.setReportingGroupRootProps(lastMainProps.isReportingGroupRootProps());
        while (iter.hasNext()) {
            int lastCol;
            int lastRow;
            Cell lastFollowCell;
            Cell cll = iter.next();
            StyleAttributes sa = Styles.getSA((ShareStyleAttributes)cll.getSSA());
            sa.setStrikeThrough(false);
            cll.setSSA((ShareStyleAttributes)sa);
            if (newMainCell == cll) {
                SortedExtPropsArray subs = activeProps.getSubs();
                if (subs == null) {
                    newMainProps.setSource(activeProps.getSource());
                    ExtProps head2 = activeProps.getHead(true, false);
                    newMainProps.setHead(head2, true);
                    newMainProps.setHead(head2, true);
                    continue;
                }
                int size = subs.size();
                for (int i = 0; i < size; ++i) {
                    lastMainCell = ((ExtProps)activeProps.getSubs().get(i)).getCell();
                    lastMainProps = lastMainCell.getExtProps(false);
                    this.clearHeadSubsBound(lastMainProps);
                }
                continue;
            }
            ExtProps followProps = cll.getExtProps(true);
            if (followProps.isReportingGroupRootProps()) {
                cll.setExtProps(null);
                followProps = cll.getExtProps(followProps);
            } else {
                cll.setExtProps(null);
                followProps = cll.getExtProps(true);
            }
            if (!offset.direction) {
                followProps.setExtensible(1);
            }
            if ((lastFollowCell = this._activeSheet.getCell(lastRow = cll.getRow() - offset.rowOffset, lastCol = cll.getCol() - offset.colOffset, false)) == null) continue;
            ExtProps lastFollowProps = lastFollowCell.getExtProps(false);
            followProps.setReportingGroupRootProps(lastFollowProps.isReportingGroupRootProps());
            ExtProps lastFollowSource = lastFollowProps.getSource();
            ExtProps lastFollowHead = lastFollowProps.getHead(offset.direction, true);
            followProps.setSource(lastFollowSource);
            followProps.setWidth(lastFollowProps.getWidth());
            followProps.setHeight(lastFollowProps.getHeight());
            if (lastFollowHead.isReportingGroupRootProps()) {
                int row = lastFollowHead.getCell().getRow() + offset.rowOffset;
                int col = lastFollowHead.getCell().getCol() + offset.colOffset;
                Cell reportingGroupMainCell = this._activeSheet.getCell(row, col, true);
                ExtProps reportingGroupProps = reportingGroupMainCell.getExtProps(true);
                followProps.setHead(offset.direction ? reportingGroupProps : lastFollowProps.getHead(true, false), true);
                followProps.setHead(offset.direction ? lastFollowProps.getHead(false, false) : reportingGroupProps, false);
                continue;
            }
            followProps.setHead(offset.direction ? newMainProps : lastFollowProps.getHead(true, false), true);
            followProps.setHead(offset.direction ? lastFollowProps.getHead(false, false) : newMainProps, false);
        }
        return offset;
    }

    private void clearHeadSubsBound(ExtProps cellProps) {
        ExtProps xHead = cellProps.getHead(true, false);
        do {
            xHead.clearSubsBounds();
        } while ((xHead = xHead.getHead(true, false)) != null && xHead != cellProps && !xHead.isCell00());
        ExtProps yHead = cellProps.getHead(false, false);
        do {
            yHead.clearSubsBounds();
        } while ((yHead = yHead.getHead(false, false)) != null && yHead != cellProps && !yHead.isCell00());
    }

    private void expandVerifyArea(Range activeRange, boolean yDir) {
        ValidationList vList = this._activeSheet.getValidations();
        CellBlock insertCellBlock = activeRange.getBlock(0);
        Sheet.ICellsIterator iter = this._activeSheet.getCellsIterator(insertCellBlock, true, false);
        ArrayList<Validation> list = new ArrayList<Validation>();
        while (iter.hasNext()) {
            CellBlock block;
            int col;
            int row;
            Validation validation;
            Cell srcCell;
            Cell cell = iter.next();
            ExtProps props = cell.getExtProps(true);
            if ((props = props.getSource()) == null || (srcCell = props.getCell()) == null || (validation = vList.getValidationContainer(row = srcCell.getRow(), col = srcCell.getCol())) == null) continue;
            list.add(validation);
            SortedCellBlockArray cbs = validation.getBlocks();
            if (cbs.contains(block = CellBlock.getCellBlock(cell.getRow(), cell.getCol()))) continue;
            this.offsetCellBlock(cbs, insertCellBlock, yDir);
            cbs.insert(block);
        }
        for (int i = 0; i < vList.size(); ++i) {
            Validation validation = vList.getValidation(i);
            if (list.contains(validation)) continue;
            SortedCellBlockArray cbs = validation.getBlocks();
            this.offsetCellBlock(cbs, insertCellBlock, yDir);
        }
        this._manager.offsetReportingTemplateCellBlock(this._activeSheet, yDir);
    }

    private void offsetCellBlock(SortedCellBlockArray cbs, CellBlock insertCellBlock, boolean yDir) {
        for (int j = 0; j < cbs.size(); ++j) {
            CellBlock other = cbs.getBlock(j);
            if (yDir) {
                if (other.getRow() < insertCellBlock.getRow()) continue;
                other.setRow(other.getRow() + insertCellBlock.getHeight());
                other.setRow2(other.getRow2() + insertCellBlock.getHeight());
                continue;
            }
            if (other.getCol() < insertCellBlock.getCol()) continue;
            other.setCol(other.getCol() + insertCellBlock.getWidth());
            other.setCol2(other.getCol2() + insertCellBlock.getWidth());
        }
    }

    private CellBlock[] findLastRowCBAndInsertRowCB(ExtProps reportingProps, OffsetRange recoder) {
        CellBlock[] reportingTemplateBlocks = this._manager.getReportingTemplateCellBlock(reportingProps.getSource());
        CellBlock srcBlock = reportingTemplateBlocks[0];
        CellBlock lastSubsBound = null;
        ExtProps head = reportingProps.getHead(recoder.direction, false);
        CellBlock lastMainCellIndex = CellBlock.getCellBlock(0, 0);
        SortedExtPropsArray propsArray = head.getSubs();
        if (propsArray != null) {
            for (int i = propsArray.size() - 1; i >= 0; --i) {
                Cell lastMainCell = ((ExtProps)propsArray.get(i)).getCell();
                ExtProps p = lastMainCell.getExtProps(true);
                if (p == null || !p.isReportingGroupRootProps()) continue;
                p.clearSubsBounds();
                lastSubsBound = p.getSubsBound();
                lastMainCellIndex.setRow(lastMainCell.getRow());
                lastMainCellIndex.setRow2(lastMainCell.getRow());
                lastMainCellIndex.setCol(lastMainCell.getCol());
                lastMainCellIndex.setCol2(lastMainCell.getCol());
                break;
            }
        }
        if (lastSubsBound == null) {
            return null;
        }
        return new CellBlock[]{srcBlock, this.buildCopyBlock(srcBlock, lastSubsBound, recoder), lastMainCellIndex, lastSubsBound};
    }

    private CellBlock buildCopyBlock(CellBlock srcBlock, CellBlock lastSubsBound, OffsetRange recoder) {
        recoder.rowOffset = recoder.direction ? lastSubsBound.getRow2() + 1 - srcBlock.getRow() : 0;
        recoder.colOffset = recoder.direction ? 0 : lastSubsBound.getCol2() + 1 - srcBlock.getCol();
        int row = recoder.direction ? lastSubsBound.getRow2() + 1 : lastSubsBound.getCol2() + 1;
        int row2 = recoder.direction ? row + srcBlock.getHeight() - 1 : row + srcBlock.getWidth() - 1;
        return recoder.direction ? CellBlock.getCellBlock(row, srcBlock.getCol(), row2, srcBlock.getCol2()) : CellBlock.getCellBlock(srcBlock.getRow(), row, srcBlock.getRow2(), row2);
    }
}

