/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.reporting.dirty.component;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.reporting.dirty.component.HotSpotCellIndicatorGlassPane;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.CommitResult;
import com.kingdee.cosmic.ctrl.ext.reporting.model.runtime.ExecutionPlan;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.core.SpreadView;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDSplitPane;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ImageIcon;
import javax.swing.JEditorPane;
import javax.swing.JLayeredPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CommitablePlanDialog
extends KDDialog {
    private static final long serialVersionUID = 1L;
    public static final CommitablePlanDialog instance = new CommitablePlanDialog();
    private KDList _exePlanList;
    private JEditorPane _exeArea;
    private KDList _resPlanList;
    private JEditorPane _resArea;
    private KDTabbedPane _tab;
    private KDButton _close;
    private RootPaneContainer container;
    private HotSpotCellIndicatorGlassPane glassPane;
    private Component origin;
    private SpreadContext context;

    private CommitablePlanDialog() {
        this.init();
        this.initListeners();
    }

    private void init() {
        this.glassPane = new HotSpotCellIndicatorGlassPane();
        Container c = this.getContentPane();
        this._exePlanList = new KDList();
        this._exeArea = new JEditorPane("text/html", null);
        this._exeArea.setEditable(false);
        this._resPlanList = new KDList();
        this._resArea = new JEditorPane("text/html", null);
        this._resArea.setEditable(false);
        this._tab = new KDTabbedPane();
        KDSplitPane panel = new KDSplitPane(0);
        KDScrollPane scroller = new KDScrollPane();
        scroller.setPreferredSize(new Dimension(800, 400));
        scroller.setViewportView((Component)this._exePlanList);
        panel.add((Component)scroller);
        panel.add((Component)this._exeArea);
        panel.setDividerLocation(200);
        this._tab.add((Component)panel, (Object)CtrlEXTMessages.getMLS("executionPlan", "\u6267\u884c\u8ba1\u5212"));
        panel = new KDSplitPane(0);
        scroller = new KDScrollPane();
        scroller.setPreferredSize(new Dimension(800, 400));
        scroller.setViewportView((Component)this._resPlanList);
        panel.add((Component)scroller);
        panel.add((Component)this._resArea);
        panel.setDividerLocation(200);
        this._tab.add((Component)panel, (Object)CtrlEXTMessages.getMLS("executionResult", "\u6267\u884c\u7ed3\u679c"));
        c.setLayout(new BorderLayout());
        c.add((Component)this._tab);
        KDPanel controlPanel = new KDPanel((LayoutManager)new FlowLayout(2));
        this._close = new KDButton(CtrlEXTMessages.getMLS("KEY_CLOSE", "\u5173\u95ed"));
        controlPanel.add((Component)this._close);
        c.add((Component)controlPanel, "South");
        ImageIcon icon = (ImageIcon)UIManager.getIcon("Frame.Icon");
        this.setTitle(CtrlEXTMessages.getMLS("executionPlanManagement", "\u586b\u62a5\u6267\u884c\u8ba1\u5212\u7ba1\u7406"));
        this.setModal(true);
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(800, 600));
    }

    private void initListeners() {
        this._close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommitablePlanDialog.this.dispose();
            }
        });
        ListSelectionListener selectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                CommitResult result;
                Object source = e.getSource();
                Cell[] cells = null;
                Sheet activeSheet = CommitablePlanDialog.this.context.getBook().getActiveSheet();
                if (source == CommitablePlanDialog.this._exePlanList) {
                    ExecutionPlan plan = (ExecutionPlan)CommitablePlanDialog.this._exePlanList.getSelectedValue();
                    if (plan != null) {
                        if (!plan.isLoaded()) {
                            plan.generateSQL();
                        }
                        String sql = plan.getSQL();
                        String[] formulas = plan.getSortedFormula();
                        if (formulas != null) {
                            for (int i = 0; i < formulas.length; ++i) {
                                sql = sql.replaceFirst("\\?", "<b color='00ff00'>" + formulas[i] + "</b>");
                            }
                        } else {
                            Variant[] values = plan.getValues();
                            for (int i = 0; i < values.length; ++i) {
                                sql = sql.replaceFirst("\\?", "<b color='00ff00'>" + values[i] + "</b>");
                            }
                        }
                        CommitablePlanDialog.this._exeArea.setText("<html><body><p>" + sql + "</p></body></html>");
                        cells = plan.getParsedCells();
                    }
                } else if (source == CommitablePlanDialog.this._resPlanList && (result = (CommitResult)CommitablePlanDialog.this._resPlanList.getSelectedValue()) != null) {
                    StringBuilder sb = new StringBuilder();
                    if ("0".equals(result.getLevel())) {
                        sb.append("<b color='00ff00'>");
                        sb.append(CtrlEXTMessages.getMLS("executionSuccess", "\u6267\u884c\u6210\u529f"));
                        sb.append("</b><br/>");
                    } else if ("1".equals(result.getLevel())) {
                        sb.append("<b color='ff0000>'");
                        sb.append(CtrlEXTMessages.getMLS("executionFailure", "\u6267\u884c\u5931\u8d25"));
                        sb.append("</b><br/>");
                        sb.append(result.getResult());
                    } else {
                        sb.append("<b color='0000ff>'");
                        sb.append(CtrlEXTMessages.getMLS("unknownResult", "\u672a\u77e5\u7ed3\u679c"));
                        sb.append("</b><br/>");
                        sb.append(result.getResult());
                    }
                    CommitablePlanDialog.this._resArea.setText(sb.toString());
                }
                CommitablePlanDialog.this.glassPane.clear();
                if (cells != null) {
                    CommitablePlanDialog.this.glassPane.loadHotSpot(cells, activeSheet, CommitablePlanDialog.this.context);
                }
            }
        };
        this._exePlanList.addListSelectionListener(selectionListener);
        this._resPlanList.addListSelectionListener(selectionListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent e) {
                if (CommitablePlanDialog.this.container != null) {
                    CommitablePlanDialog.this.container.getGlassPane().setVisible(false);
                    CommitablePlanDialog.this.container.setGlassPane(CommitablePlanDialog.this.origin);
                }
            }
        });
    }

    public void load(ExecutionPlan[] plans, CommitResult[] results) {
        int i;
        this._exePlanList.removeAllElements();
        if (plans != null) {
            for (i = 0; i < plans.length; ++i) {
                this._exePlanList.addElement((Object)plans[i]);
            }
        }
        this._resPlanList.removeAllElements();
        if (results != null) {
            for (i = 0; i < results.length; ++i) {
                this._resPlanList.addElement((Object)results[i]);
            }
        }
        this._exeArea.setText(null);
        this._resArea.setText(null);
    }

    public static CommitablePlanDialog getInstance(SpreadContext ctx) {
        instance.setLocationRelativeTo((Component)((Object)ctx));
        RootPaneContainer container = null;
        JLayeredPane layerdPane = null;
        Container parent = ctx.getParent();
        while (container == null) {
            if (parent instanceof KDFrame) {
                container = (RootPaneContainer)((Object)parent);
            } else if (parent instanceof JLayeredPane) {
                layerdPane = (JLayeredPane)parent;
            } else if (parent == null) break;
            parent = parent.getParent();
        }
        if (container != null) {
            CommitablePlanDialog.instance.container = container;
            CommitablePlanDialog.instance.context = ctx;
            SpreadView table = (SpreadView)ctx.getSpread().getViewManager().getView(2, 2);
            table.scrollCellVisible(0, 0);
            Point p1 = new Point(0, 0);
            SwingUtilities.convertPointToScreen(p1, ctx.getSpread().getView(2, 2));
            Point p2 = new Point(0, 0);
            SwingUtilities.convertPointToScreen(p2, layerdPane == null ? parent : layerdPane);
            CommitablePlanDialog.instance.glassPane.offset(p1.x - p2.x, p1.y - p2.y);
            CommitablePlanDialog.instance.origin = container.getGlassPane();
            container.setGlassPane((Component)((Object)CommitablePlanDialog.instance.glassPane));
            container.getGlassPane().setVisible(true);
        }
        return instance;
    }
}

