/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.reporting.model.design.validation;

import com.kingdee.cosmic.ctrl.kds.impl.facade.MultiLanguageKeys;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.validate.util.MessagedValidate;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

public class InputTextPanel
extends KDPanel {
    private static final long serialVersionUID = 1L;
    private final String message_heading = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Input_heading", "\u9009\u5b9a\u5355\u5143\u683c\u65f6\u663e\u793a\u8f93\u5165\u4fe1\u606f");
    private final String message_subheading = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Input_subheading", "\u9009\u5b9a\u5355\u5143\u683c\u65f6\u663e\u793a\u4e0b\u5217\u8f93\u5165\u4fe1\u606f");
    private final String message_title = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Input_title", "\u6807\u9898");
    private final String message_content = MultiLanguageKeys.getLocalText("KEY_VALIDATION_Input_text", "\u8f93\u5165\u4fe1\u606f");
    private KDCheckBox _ckbHeading;
    private KDLabel _lbSubheading;
    private KDLabel _lbTitle;
    private KDLabel _lbContent;
    private KDTextField _tfTitle;
    private KDScrollPane _scrollPane;
    private KDTextArea _taContent;
    private ItemListener _ckbActionListener;

    public InputTextPanel() {
        this.initComps();
        this.initListeners();
        this.layoutComps();
    }

    private void initComps() {
        this._ckbHeading = new KDCheckBox(this.message_heading);
        this._lbSubheading = new KDLabel(this.message_subheading + ":");
        this._lbTitle = new KDLabel(this.message_title + ":");
        this._lbContent = new KDLabel(this.message_content + ":");
        this._tfTitle = new KDTextField();
        this._taContent = new KDTextArea();
        this._scrollPane = new KDScrollPane((Component)this._taContent);
        this._ckbHeading.setSelected(true);
        this.add((Component)this._ckbHeading);
        this.add((Component)this._lbSubheading);
        this.add((Component)this._lbTitle);
        this.add((Component)this._lbContent);
        this.add((Component)this._tfTitle);
        this.add((Component)this._scrollPane);
    }

    private void initListeners() {
        this._ckbActionListener = new CheckBoxItemListener();
        this._ckbHeading.addItemListener(this._ckbActionListener);
    }

    private void layoutComps() {
        this.setLayout(null);
        this._ckbHeading.setBounds(5, 5, 300, 20);
        this._lbSubheading.setBounds(10, 30, 300, 20);
        this._lbTitle.setBounds(20, 55, 300, 20);
        this._tfTitle.setBounds(20, 80, 400, 20);
        this._lbContent.setBounds(20, 105, 400, 20);
        this._scrollPane.setBounds(20, 130, 400, 100);
    }

    public void updateValidate(MessagedValidate validate, Sheet activeSheet) {
        if (validate != null) {
            validate.setInputHide(!this._ckbHeading.isSelected());
            validate.setInputTitle(this._tfTitle.getText());
            validate.setInputMessage(this._taContent.getText());
        }
    }

    public boolean isEmptyValidate() {
        return this._tfTitle.getText().equals("") && this._taContent.getText().equals("") && this._ckbHeading.isSelected();
    }

    public void updatePanelByValidate(MessagedValidate mv) {
        if (mv != null) {
            this._ckbHeading.setSelected(!mv.isInputHide());
            this._tfTitle.setText(mv.getInputTitle());
            this._taContent.setText(mv.getInputMessage());
        } else {
            this._ckbHeading.setSelected(true);
            this._tfTitle.setText("");
            this._taContent.setText("");
        }
    }

    private class CheckBoxItemListener
    implements ItemListener {
        private CheckBoxItemListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                InputTextPanel.this._tfTitle.setEnabled(true);
                InputTextPanel.this._taContent.setEnabled(true);
            } else {
                InputTextPanel.this._tfTitle.setEnabled(false);
                InputTextPanel.this._taContent.setEnabled(false);
            }
        }
    }
}

