/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.reporting.model.runtime;

import com.kingdee.cosmic.ctrl.ext.reporting.ReportingFactory;
import com.kingdee.cosmic.ctrl.ext.reporting.exception.ExtReportingBizException;
import com.kingdee.cosmic.ctrl.ext.reporting.model.UpdateType;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IUpdateConstraint;
import com.kingdee.cosmic.ctrl.ext.reporting.model.design.IUpdateProperty;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.expans.model.ExtProps;
import com.kingdee.cosmic.ctrl.kds.model.expr.Expr;
import com.kingdee.cosmic.ctrl.kds.model.expr.IExprNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.Cell;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class ExecutionPlan
implements Cloneable {
    protected String _identityKey;
    protected Cell[] _usedCells;
    protected Cell[] _parsedCells;
    protected String[] _sortedUsedFormulas;
    protected String _sql;
    protected IUpdateConstraint _constraint;
    protected Variant[] _values;
    protected int[] _jdbcTypes;
    protected boolean _isLoaded = false;
    protected boolean _isMerged = false;

    protected ExecutionPlan(String identityKey, Cell[] usedCells, IUpdateConstraint constraint) {
        this._identityKey = identityKey;
        this._usedCells = usedCells;
        this._constraint = constraint;
    }

    public String getIdentityKey() {
        return this._identityKey;
    }

    public String getSQL() {
        return this._sql;
    }

    public void setSQL(String sql) {
        this._sql = sql;
    }

    public String getDBID() {
        return this._constraint.getDBID();
    }

    public Cell[] getUsedCells() {
        return this._usedCells;
    }

    public Cell[] getParsedCells() {
        return this._parsedCells;
    }

    public Variant[] getValues() {
        return this._values;
    }

    public void setValues(Variant[] values) {
        this._values = values;
    }

    public int[] getJdbcTypes() {
        return this._jdbcTypes;
    }

    public void setJdbcTypes(int[] jdbcTypes) {
        this._jdbcTypes = jdbcTypes;
    }

    public String getConstraintName() {
        return this._constraint.getUserDefineName();
    }

    public boolean isProcedure() {
        return this._constraint.getUpdateType() == UpdateType.PROCEDURE_UPDATE;
    }

    public String getProcedureName() {
        return this._constraint.getProperty();
    }

    public String[] getSortedFormula() {
        return this._sortedUsedFormulas;
    }

    protected Cell findSourceCell(IUpdateProperty property) {
        ExtProps p;
        List srcList = property.getUsedCells(false);
        int srcListSize = srcList.size();
        ArrayList<String> srcCllNames = new ArrayList<String>(srcListSize);
        for (int i = 0; i < srcListSize; ++i) {
            srcCllNames.add(((Cell)srcList.get(i)).getName(false, true));
        }
        Cell cell = null;
        boolean initialed = false;
        boolean direction = true;
        int offsetRow = -1;
        int offsetCol = -1;
        for (int j = 0; j < this._usedCells.length; ++j) {
            p = this._usedCells[j].getExtProps(true);
            Cell src = (p = p.getSource()).getCell();
            String srcCllName = src.getName(false, true);
            if (srcCllNames.contains(srcCllName)) {
                cell = this._usedCells[j];
                break;
            }
            if (initialed) continue;
            initialed = true;
            offsetRow = this._usedCells[j].getRow() - src.getRow();
            offsetCol = this._usedCells[j].getCol() - src.getCol();
            direction = p.getExtensible(false) != 1;
        }
        while (initialed && cell == null && offsetRow >= 0 && offsetCol >= 0) {
            Cell cll = (Cell)srcList.get(0);
            cll = cll.getSheet().getCell(cll.getRow() + offsetRow, cll.getCol() + offsetCol, false);
            if (direction) {
                --offsetRow;
            } else {
                --offsetCol;
            }
            if (cll == null || (p = cll.getExtProps(false)) == null || !p.isReportingGroupRootProps()) continue;
            cell = cll;
        }
        return cell;
    }

    public abstract void generateSQL();

    public static Expr parseExpr(IUpdateProperty property, Sheet sheet, Cell cll) {
        return ExecutionPlan.parseExpr(property.getFormula(), sheet, cll);
    }

    public static Expr parseExpr(String formula, Sheet sheet, Cell cll) {
        Expr expr = sheet.getExpr(cll, formula);
        IExprNode[] allNodes = expr.getAllNodes();
        if (allNodes != null) {
            for (int j = 0; j < allNodes.length; ++j) {
                if (!(allNodes[j] instanceof CellBlock)) continue;
                CellBlock cb = (CellBlock)((Object)allNodes[j]);
                int rowExtend = cb.getHeight() - 1;
                int colExtend = cb.getWidth() - 1;
                ExtProps p = cll.getExtProps(true).getSource();
                ExtProps head = p.getHead(true, false);
                if (head == null || head.isCell00()) {
                    head = p;
                }
                if (head.getExtensible(false) == 1) {
                    cb.setCol(cll.getCol());
                    cb.setCol2(cll.getCol() + colExtend);
                    continue;
                }
                cb.setRow(cll.getRow());
                cb.setRow2(cll.getRow() + rowExtend);
            }
        }
        return expr;
    }

    public boolean isLoaded() {
        return this._isLoaded;
    }

    public void setLoaded(boolean isLoaded) {
        this._isLoaded = isLoaded;
    }

    public void tagMerge() {
        this._isMerged = true;
    }

    public ExecutionPlan getBookDetachedCopy() throws ExtReportingBizException {
        ExecutionPlan copy;
        try {
            copy = (ExecutionPlan)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ExtReportingBizException("", e);
        }
        copy._usedCells = null;
        copy._constraint = ReportingFactory.fetchRuntimeProvider().createEmptyReportingModel().createEmptyUpdateConstraint();
        copy._constraint.setDBID(this._constraint.getDBID());
        copy._constraint.setProperty(this._constraint.getProperty());
        List updateProperties = this._constraint.getUpdateProperties();
        Iterator iter = updateProperties.iterator();
        while (iter.hasNext()) {
            IUpdateProperty prop = copy._constraint.createEmptytUpdateProperties();
            IUpdateProperty source = (IUpdateProperty)iter.next();
            prop.setPrimaryKey(source.isPrimaryKey());
            prop.setPropertyName(source.getPropertyName());
            prop.setJdbcDataType(source.getJdbcDataType());
        }
        return copy;
    }

    public static Variant[] parseVariantWithJdbcTypes(Variant[] values, int[] jdbcTypes) {
        block29: for (int i = 0; i < jdbcTypes.length; ++i) {
            while (values[i].isReferences()) {
                values[i] = values[i].getVariant();
            }
            if (values[i].isNull()) continue;
            switch (jdbcTypes[i]) {
                case 1: 
                case 12: {
                    values[i] = new Variant(values[i].toString());
                    continue block29;
                }
                case -1: 
                case 2005: {
                    values[i] = new Variant(values[i].toCharArray());
                    continue block29;
                }
                case 4: {
                    try {
                        values[i] = new Variant(values[i].toBigDecimal().intValue());
                    }
                    catch (SyntaxErrorException e) {
                        values[i] = new Variant(values[i].toString());
                    }
                    continue block29;
                }
                case -5: {
                    try {
                        values[i] = new Variant(values[i].toBigInteger());
                    }
                    catch (SyntaxErrorException e) {
                        values[i] = new Variant(values[i].toString());
                    }
                    continue block29;
                }
                case 5: {
                    try {
                        values[i] = new Variant(values[i].toBigDecimal().shortValue());
                    }
                    catch (SyntaxErrorException e) {
                        values[i] = new Variant(values[i].toString());
                    }
                    continue block29;
                }
                case -7: 
                case -6: 
                case 16: {
                    try {
                        values[i] = new Variant(values[i].toBigDecimal().byteValue());
                    }
                    catch (SyntaxErrorException e) {
                        values[i] = new Variant(values[i].toString());
                    }
                    continue block29;
                }
                case 2: 
                case 3: {
                    try {
                        values[i] = new Variant(values[i].toBigDecimal());
                    }
                    catch (SyntaxErrorException e) {
                        values[i] = new Variant(values[i].toString());
                    }
                    continue block29;
                }
                case 6: 
                case 7: 
                case 8: {
                    try {
                        values[i] = new Variant(values[i].toBigDecimal().doubleValue());
                    }
                    catch (SyntaxErrorException e) {
                        values[i] = new Variant(values[i].toString());
                    }
                    continue block29;
                }
                case 91: 
                case 92: 
                case 93: {
                    try {
                        values[i] = new Variant(values[i].toDate());
                    }
                    catch (SyntaxErrorException e) {
                        values[i] = new Variant(values[i].toString());
                    }
                    continue block29;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2004: {
                    try {
                        values[i] = new Variant(values[i].toByteArray());
                    }
                    catch (SyntaxErrorException e) {
                        values[i] = new Variant(values[i].toString());
                    }
                    continue block29;
                }
                case 0: 
                case 70: 
                case 1111: 
                case 2000: 
                case 2001: 
                case 2002: 
                case 2003: 
                case 2006: {
                    values[i] = new Variant(values[i].toString());
                }
            }
        }
        return values;
    }
}

