/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.subrpt.design;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlCommonMessages;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.subrpt.SubReportInfo;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;

public class SubReportRender
implements IBasicRender {
    private static final String getSubRpt() {
        return CtrlEXTMessages.getMLS("subRpt", "\u5b50\u62a5\u8868");
    }

    public void draw(Graphics g, Shape clip, Object object, Style cellStyle) {
        if (object == null || !(object instanceof SubReportInfo)) {
            return;
        }
        Rectangle rect = clip.getBounds();
        double cellX = rect.getX();
        double cellY = rect.getY();
        double cellWidth = rect.getWidth();
        double cellHeight = rect.getHeight();
        Graphics2D g2d = (Graphics2D)g.create();
        Composite gComposite = g2d.getComposite();
        g2d.setComposite(AlphaComposite.getInstance(3, 1.0f));
        g2d.setFont(new Font(CtrlCommonMessages.getMLS((String)"yahei", (String)"\u5fae\u8f6f\u96c5\u9ed1"), 1, 30));
        g2d.setColor(Color.ORANGE);
        FontMetrics fm = g2d.getFontMetrics();
        Rectangle2D bounds = fm.getStringBounds(SubReportRender.getSubRpt(), g2d);
        float x = (float)((cellWidth - bounds.getWidth()) / 2.0 + cellX);
        float y = (float)((cellHeight - bounds.getHeight()) / 2.0 + cellY - bounds.getY());
        g2d.drawString(SubReportRender.getSubRpt(), x, y);
        g2d.setComposite(gComposite);
        SubReportInfo reportInfo = (SubReportInfo)object;
        String text = reportInfo.getText();
        g2d.setFont(new Font(CtrlCommonMessages.getMLS((String)"yahei", (String)"\u5fae\u8f6f\u96c5\u9ed1"), 0, 14));
        g2d.setColor(Color.BLACK);
        fm = g2d.getFontMetrics();
        bounds = fm.getStringBounds(text, g2d);
        y = (float)((cellHeight - bounds.getHeight()) / 2.0 + cellY - bounds.getY());
        g2d.drawString(text, (float)cellX + 10.0f, y);
        g2d.dispose();
    }
}

