/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.calc;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Dependents;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDFormattedTextField;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;

public class CalcSettingPanel
extends KDDialog {
    private KDCheckBox _enbleIterator;
    private KDFormattedTextField _iteratorTimes;
    private KDFormattedTextField _iteratorMaxChange;
    private Dependents _des;
    private KDButton _confirm;
    private KDButton _cancel;

    public CalcSettingPanel(KDExt parent) {
        super((Frame)((Object)parent));
        this.setTitle(CtrlEXTMessages.getMLS("reportCalculationAttributeSettings", "\u62a5\u8868\u8ba1\u7b97\u5c5e\u6027\u8bbe\u7f6e"));
        this.setResizable(false);
        this.setModal(true);
        this.setSize(200, 200);
        this.setLocationRelativeTo((Component)((Object)parent));
        this.setDefaultCloseOperation(2);
        Container c = this.getContentPane();
        c.setLayout(null);
        this._des = MiscUtil.getActiveSpreadContext(parent).getBook().getDeps();
        this._enbleIterator = new KDCheckBox();
        KDLabelContainer lc = new KDLabelContainer();
        lc.setBoundLabelUnderline(true);
        lc.setBoundLabelText(CtrlEXTMessages.getMLS("enableIterativeCalculation", "\u542f\u7528\u8fed\u4ee3\u8ba1\u7b97"));
        lc.setBoundEditor((JComponent)this._enbleIterator);
        lc.setBoundLabelLength(100);
        lc.setBounds(10, 10, 180, 20);
        c.add((Component)lc);
        this._enbleIterator.setSelected(this._des.isIterate());
        this._iteratorTimes = new KDFormattedTextField(0);
        this._iteratorTimes.setMinimumValue((Comparable)Integer.valueOf(1));
        this._iteratorTimes.setMaximumValue((Comparable)Short.valueOf((short)Short.MAX_VALUE));
        lc = new KDLabelContainer();
        lc.setBoundLabelUnderline(true);
        lc.setBoundLabelText(CtrlEXTMessages.getMLS("maxIterations", "\u6700\u591a\u8fed\u4ee3\u6b21\u6570"));
        lc.setBoundEditor((JComponent)this._iteratorTimes);
        lc.setBoundLabelLength(100);
        lc.setBounds(10, 40, 180, 20);
        c.add((Component)lc);
        this._iteratorTimes.setNumberValue((Number)this._des.getMaxIterations());
        this._iteratorMaxChange = new KDFormattedTextField(5);
        this._iteratorMaxChange.setRemoveingZeroInEdit(true);
        this._iteratorMaxChange.setGroupingUsed(false);
        this._iteratorMaxChange.setMinimumValue((Comparable)Integer.valueOf(0));
        this._iteratorMaxChange.setPrecision(10);
        lc = new KDLabelContainer();
        lc.setBoundLabelUnderline(true);
        lc.setBoundLabelText(CtrlEXTMessages.getMLS("maxError", "\u6700\u5927\u8bef\u5dee"));
        lc.setBoundEditor((JComponent)this._iteratorMaxChange);
        lc.setBoundLabelLength(100);
        lc.setBounds(10, 70, 180, 20);
        c.add((Component)lc);
        this._iteratorMaxChange.setNumberValue((Number)this._des.getMaxChange());
        this._confirm = new KDButton(CtrlEXTMessages.getMLS("KEY_OK", "\u786e\u5b9a"));
        this._confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (CalcSettingPanel.this.confirm()) {
                    CalcSettingPanel.this.dispose();
                }
            }
        });
        this._confirm.setBounds(10, 140, 40, 20);
        c.add((Component)this._confirm);
        this._cancel = new KDButton(CtrlEXTMessages.getMLS("KEY_CANCEL", "\u53d6\u6d88"));
        this._cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CalcSettingPanel.this.dispose();
            }
        });
        this._cancel.setBounds(110, 140, 40, 20);
        c.add((Component)this._cancel);
    }

    public void refresh(Dependents des) {
        this._enbleIterator.setSelected(des.isIterate());
        this._iteratorTimes.setNumberValue((Number)des.getMaxIterations());
        this._iteratorMaxChange.setNumberValue((Number)des.getMaxChange());
    }

    public boolean confirm() {
        try {
            this._des.setIterate(this._enbleIterator.isSelected());
            this._des.setMaxIterations(this._iteratorTimes.getNumberValue().intValue());
            this._des.setMaxChange(this._iteratorMaxChange.getNumberValue().doubleValue());
        }
        catch (Exception ex) {
            MessageUtil.msgboxWarning((Component)((Object)this), CtrlEXTMessages.getMLS("functionIterationFail", "\u8bbe\u7f6e\u51fd\u6570\u8fed\u4ee3\u8ba1\u7b97\u884c\u4e3a\u5931\u8d25\uff01\u8bf7\u53c2\u8003\u8be6\u7ec6\u4fe1\u606f\u3002"), ex);
        }
        return true;
    }
}

