/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.AbstractChartPanel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.FusionChartEmptyAssembler;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.FusionChartHyperLinkAssembler;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.IWizardStep;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ETTargets;
import com.kingdee.cosmic.ctrl.kds.expans.model.innerlink.model.InnerLinkTargets;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import javax.swing.SwingUtilities;

public class FusionChartLinkChooserPanel
extends AbstractChartPanel {
    private static final long serialVersionUID = 1L;
    private FusionChartHyperLinkAssembler _linkAssembler;
    private FusionChartEmptyAssembler _emptyAssembler;
    private KDTabbedPane _tabbedPane;

    private static final String getTitleText() {
        return CtrlEXTMessages.getMLS("hyperLink", "\u8054\u67e5/\u8054\u52a8");
    }

    protected FusionChartLinkChooserPanel(IWizardStep last, SpreadContext context, Container parent, FusionGraphicsModel model) {
        super(last, context, parent, model);
        this.initComponents();
    }

    private void initComponents() {
        this.title = ChartDataTransferUtil.isNoSupportTransfered(this.model) ? CtrlEXTMessages.getMLS("sixthStepChartLinkageSettings", "\u7b2c\u516d\u6b65\uff1a\u56fe\u8868\u8054\u67e5/\u8054\u52a8\u8bbe\u7f6e") : CtrlEXTMessages.getMLS("seventhStepChartLinkageSettings", "\u7b2c\u4e03\u6b65\uff1a\u56fe\u8868\u8054\u67e5/\u8054\u52a8\u8bbe\u7f6e");
        KDExt ext = (KDExt)((Object)SwingUtilities.getWindowAncestor((Component)((Object)this.context)));
        this._linkAssembler = new FusionChartHyperLinkAssembler(ext, this.model.getChartType());
        this._tabbedPane = new KDTabbedPane();
        this._linkAssembler.setCustomInsets(new Insets(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)this._tabbedPane, "Center");
        this._tabbedPane.addTab(FusionChartLinkChooserPanel.getTitleText(), (Component)((Object)this._linkAssembler));
    }

    @Override
    protected void initNextStep() {
    }

    @Override
    public void syncModel2Graphics(int type) {
        if (ChartDataTransferUtil.isNoSupportedLink(this.model)) {
            return;
        }
        Object[] arrTarget = new Object[3];
        arrTarget[0] = this.model.getExtTargets();
        arrTarget[2] = this.model.getInnerTargets();
        this._linkAssembler.configFromCell(arrTarget, this.model.getDataNode());
    }

    @Override
    public boolean syncGraphics2Model(int type) {
        if (ChartDataTransferUtil.isNoSupportedLink(this.model)) {
            this.model.setExtTargets(null);
            this.model.setInnerTargets(null);
            return true;
        }
        if (!this._linkAssembler.commit()) {
            return false;
        }
        Object[] targets = this._linkAssembler.getTargets();
        if (targets != null) {
            this.model.setExtTargets((ETTargets)targets[0]);
            this.model.setInnerTargets((InnerLinkTargets)targets[2]);
        }
        return true;
    }

    @Override
    public KDPanel getImpl() {
        if (ChartDataTransferUtil.isNoSupportedLink(this.model)) {
            return this._emptyAssembler;
        }
        return this._linkAssembler;
    }

    @Override
    public String getTitle() {
        return FusionChartLinkChooserPanel.getTitleText();
    }

    @Override
    public boolean prepare() {
        super.prepare();
        if (ChartDataTransferUtil.isNoSupportedLink(this.model)) {
            this._tabbedPane.remove((Component)((Object)this._linkAssembler));
            this._tabbedPane.addTab(FusionChartLinkChooserPanel.getTitleText(), (Component)((Object)this._emptyAssembler));
        } else {
            this._tabbedPane.remove((Component)((Object)this._emptyAssembler));
            this._tabbedPane.addTab(FusionChartLinkChooserPanel.getTitleText(), (Component)((Object)this._linkAssembler));
        }
        return true;
    }
}

