/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.AbstractChartPanel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.FusionChartLinkChooserPanel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.chartpanelImpl.FusionChartTransformChooserPanel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.FusionGraphicsModel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.IWizardStep;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.WizzardEmbedObjectConfig;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;

public class FusionChartLocationChooserPanel
extends AbstractChartPanel {
    private static final long serialVersionUID = 1L;
    private WizzardEmbedObjectConfig.PropertiesPanel propsPanel;
    private int x;
    private int y;
    private int w;
    private int h;
    private int anchor;

    protected FusionChartLocationChooserPanel(IWizardStep last, SpreadContext context, Container parent, FusionGraphicsModel model) {
        super(last, context, parent, model);
        this.title = CtrlEXTMessages.getMLS("fifthStepChartPositionSettings", "\u7b2c\u4e94\u6b65\uff1a\u56fe\u8868\u4f4d\u7f6e\u8bbe\u7f6e");
        this.propsPanel = new WizzardEmbedObjectConfig.PropertiesPanel(context);
        KDTabbedPane tabbedPane = new KDTabbedPane();
        this.setLayout(new BorderLayout());
        this.add((Component)tabbedPane, "Center");
        tabbedPane.addTab(CtrlEXTMessages.getMLS("prop", "\u5c5e\u6027"), (Component)((Object)this.propsPanel));
        this.add((Component)tabbedPane);
    }

    @Override
    public void syncModel2Graphics(int type) {
        Rectangle rect = this.calcVisibleCentre(this.context.getSpread().getActiveView().getVisibleRect());
        this.propsPanel.x.setNumberValue((Number)this.model.getX());
        this.propsPanel.y.setNumberValue((Number)this.model.getY());
        this.propsPanel.width.setNumberValue((Number)(this.model.getW() != 0 ? this.model.getW() : (int)rect.getWidth()));
        this.propsPanel.height.setNumberValue((Number)(this.model.getH() != 0 ? this.model.getH() : (int)rect.getHeight()));
        switch (this.model.getAnchorMode()) {
            case 1: {
                this.propsPanel.anchorOneCell.setSelected(true);
                this.propsPanel.anchorCellLT.setText(this.model.getAnchorCellLT());
                break;
            }
            case 2: {
                this.propsPanel.anchorAbsolute.setSelected(true);
                break;
            }
            default: {
                this.propsPanel.anchorTwoCell.setSelected(true);
                this.propsPanel.anchorCellLT.setText(this.model.getAnchorCellLT());
                this.propsPanel.anchorCellRB.setText(this.model.getAnchorCellRB());
            }
        }
    }

    private Rectangle calcVisibleCentre(Rectangle rect) {
        rect.x += (rect.width - 480) / 2;
        rect.y += (rect.height - 297) / 2;
        rect.height = 278;
        rect.width = 420;
        return rect;
    }

    @Override
    public boolean syncGraphics2Model(int type) {
        if (this.propsPanel.anchorOneCell.isSelected()) {
            this.anchor = 1;
        } else if (this.propsPanel.anchorTwoCell.isSelected()) {
            this.anchor = 0;
        } else if (this.propsPanel.anchorAbsolute.isSelected()) {
            this.anchor = 2;
        }
        this.x = this.propsPanel.x.getNumberValue().intValue();
        this.y = this.propsPanel.y.getNumberValue().intValue();
        this.w = this.propsPanel.width.getNumberValue().intValue();
        this.h = this.propsPanel.height.getNumberValue().intValue();
        this.model.setAnchorMode(this.anchor);
        this.model.setAnchorCellLT(this.propsPanel.anchorCellLT.getText());
        this.model.setAnchorCellRB(this.propsPanel.anchorCellRB.getText());
        this.model.setX(this.x);
        this.model.setY(this.y);
        this.model.setW(this.w);
        this.model.setH(this.h);
        return true;
    }

    @Override
    protected void initNextStep() {
        if (System.getProperty("EAS_HOME") == null && this.next != null) {
            return;
        }
        if (!ChartDataTransferUtil.isNoSupportTransfered(this.model)) {
            this.next = new FusionChartTransformChooserPanel(this, this.context, this.parent, this.model);
        } else if (!ChartDataTransferUtil.isNoSupportedLink(this.model)) {
            this.next = new FusionChartLinkChooserPanel(this, this.context, this.parent, this.model);
        }
    }

    @Override
    public IWizardStep getNextStep() {
        if (this.model.getChartType() == null || ChartDataTransferUtil.isNoSupportedLink(this.model) && ChartDataTransferUtil.isNoSupportTransfered(this.model)) {
            return null;
        }
        return super.getNextStep();
    }

    @Override
    public boolean prepare() {
        if (this.next != null) {
            if (this.next instanceof FusionChartTransformChooserPanel) {
                ((FusionChartTransformChooserPanel)this.next).setModel(this.model);
            } else if (this.next instanceof FusionChartLinkChooserPanel) {
                ((FusionChartLinkChooserPanel)this.next).setModel(this.model);
            }
        }
        return super.prepare();
    }

    @Override
    public KDPanel getImpl() {
        return this.propsPanel;
    }

    @Override
    public String getTitle() {
        return CtrlEXTMessages.getMLS("chartPosition", "\u56fe\u8868\u4f4d\u7f6e");
    }
}

