/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.color;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.color.ColorTemplateEditor;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.color.ColorTemplateVFPair;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.cosmic.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.cosmic.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.cosmic.ctrl.kdf.util.style.Style;
import com.kingdee.cosmic.ctrl.swing.IKDEditor;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDComboColor;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import com.kingdee.cosmic.ctrl.swing.event.ComboColorSelectedEvent;
import com.kingdee.cosmic.ctrl.swing.event.ComboColorSelectedListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.SwingUtilities;

class ColorEditor
extends KDDialog {
    private KDTable _colorTable;
    private KDComboBox _templateList;
    private KDButton _confirm;
    private KDButton _cancle;
    private KDWorkButton _insertRow;
    private KDWorkButton _deleteRow;
    private KDComboColor _colorSelector;
    private ColorTemplateVFPair _currentValue;

    ColorEditor(Component parent, ColorTemplateVFPair value) {
        super((Dialog)((KDDialog)SwingUtilities.getWindowAncestor(parent)));
        this._currentValue = value;
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setResizable(false);
        this.setTitle(CtrlEXTMessages.getMLS("setChartColorScheme", "\u8bbe\u7f6e\u56fe\u8868\u989c\u8272\u65b9\u6848"));
        this.setSize(295, 400);
        this.init();
    }

    private void init() {
        this._templateList = new KDComboBox((Object[])new String[]{ColorTemplateEditor.getCustomTemlate(), ColorTemplateEditor.getSystemTemplateBussinessSteady(), ColorTemplateEditor.getSystemTemplateElegantFacial(), ColorTemplateEditor.getSystemTemplateNobleElegant(), ColorTemplateEditor.getSystemTemplatePureSimple(), ColorTemplateEditor.getSystemTemplateFusioncharts(), ColorTemplateEditor.getSystemTemplateSystem(), ColorTemplateEditor.getSystemTemplateQingChart()});
        this._templateList.setBounds(10, 5, 220, 20);
        this._colorTable = new KDTable(2, 1, 0);
        this._colorTable.setBounds(10, 27, 270, 300);
        this._colorTable.getColumn(0).setWidth(100);
        this._colorTable.getColumn(1).setWidth(100);
        IRow headRow = this._colorTable.getHeadRow(0);
        headRow.getCell(0).setValue((Object)CtrlEXTMessages.getMLS("KEY_NAME", "\u540d\u79f0"));
        headRow.getCell(1).setValue((Object)CtrlEXTMessages.getMLS("KEY_VALUE", "\u503c"));
        this._colorTable.getColumn(0).getStyleAttributes().setLocked(true);
        this._colorSelector = new KDComboColor();
        this._templateList.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ColorEditor.this._insertRow.setVisible(false);
                ColorEditor.this._deleteRow.setVisible(false);
                switch (ColorEditor.this._templateList.getSelectedIndex()) {
                    case 0: {
                        if (ColorEditor.this._currentValue == null) break;
                        ColorEditor.this._insertRow.setVisible(true);
                        ColorEditor.this._deleteRow.setVisible(true);
                        String xml = ColorEditor.this._currentValue.getXmlValue();
                        int index = ColorEditor.this.getTemplateIndex(xml);
                        if (index != 0) break;
                        ColorEditor.this.parseXML(xml, false);
                        break;
                    }
                    case 1: {
                        ColorEditor.this.parseXML(ColorTemplateEditor.getBussinessSteadyTemplate(), false);
                        break;
                    }
                    case 2: {
                        ColorEditor.this.parseXML(ColorTemplateEditor.getElegantFacialTemplate(), false);
                        break;
                    }
                    case 3: {
                        ColorEditor.this.parseXML(ColorTemplateEditor.getNobleElegantTemplate(), false);
                        break;
                    }
                    case 4: {
                        ColorEditor.this.parseXML(ColorTemplateEditor.getPureSimpleTemplate(), false);
                        break;
                    }
                    case 5: {
                        ColorEditor.this.parseXML(ColorTemplateEditor.getSystemFusionchartsTemplate(), false);
                        break;
                    }
                    case 6: {
                        ColorEditor.this.parseXML(ColorTemplateEditor.getSystemTemplate(), false);
                        break;
                    }
                    case 7: {
                        ColorEditor.this.parseXML(ColorTemplateEditor.getSystemQingchartsTemplate(), false);
                    }
                }
            }
        });
        this._colorTable.getColumn(1).setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)this._colorSelector));
        IBasicRender renderer = new IBasicRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                graphics.setColor((Color)object);
                Rectangle rect = clip.getBounds();
                graphics.fillRect(rect.x + 10, rect.y + 3, rect.width - 20, rect.height - 6);
            }
        };
        this._colorTable.getColumn(1).setRenderer(renderer);
        this._colorSelector.addSelectedListener(new ComboColorSelectedListener(){

            public void selected(ComboColorSelectedEvent evt) {
                ColorEditor.this._colorTable.getEditManager().stopEditing();
            }
        });
        this._confirm = new KDButton(CtrlEXTMessages.getMLS("KEY_OK", "\u786e\u5b9a"));
        this._confirm.setBounds(125, 340, 53, 20);
        this._confirm.setMargin(new Insets(0, 0, 0, 0));
        this._confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ColorEditor.this._currentValue = ColorEditor.this.serializeToXML();
                ColorEditor.this.dispose();
            }
        });
        this._cancle = new KDButton(CtrlEXTMessages.getMLS("KEY_CANCEL", "\u53d6\u6d88"));
        this._cancle.setBounds(205, 340, 53, 20);
        this._cancle.setMargin(new Insets(0, 0, 0, 0));
        this._cancle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String xml = ColorEditor.this._currentValue != null ? ColorEditor.this._currentValue.getXmlValue() : ColorTemplateEditor.getBussinessSteadyTemplate();
                ColorEditor.this.updateListSelectionIndex(xml);
                ColorEditor.this.dispose();
            }
        });
        this._insertRow = new KDWorkButton((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IRow row = ColorEditor.this._colorTable.addRow();
                row.getCell(0).setValue((Object)CtrlEXTMessages.getMLS("cycleColors", "\u5faa\u73af\u8272\u503c"));
                Color color = new Color(255, 255, 255);
                ColorEditor.this._colorSelector.setColor(null);
                row.getCell(1).setValue((Object)color);
            }
        });
        this._insertRow.setBounds(235, 5, 20, 20);
        this._insertRow.setFocusable(false);
        this._insertRow.setIcon((Icon)ResourceManager.getImageIcon("tbtn_Insert.gif"));
        this._deleteRow = new KDWorkButton((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IRow row = KDTableUtil.getSelectedRow((KDTable)ColorEditor.this._colorTable);
                if (row != null) {
                    ColorEditor.this._colorTable.removeRow(row.getRowIndex());
                }
            }
        });
        this._deleteRow.setBounds(260, 5, 20, 20);
        this._deleteRow.setFocusable(false);
        this._deleteRow.setIcon((Icon)ResourceManager.getImageIcon("tbtn_Delete.gif"));
        Container c = this.getContentPane();
        c.setLayout(null);
        c.add((Component)this._templateList);
        c.add((Component)this._colorTable);
        c.add((Component)this._confirm);
        c.add((Component)this._cancle);
        c.add((Component)this._insertRow);
        c.add((Component)this._deleteRow);
    }

    public void parseXML(String xmlString, boolean updateIndex) {
        if (updateIndex) {
            this.updateListSelectionIndex(xmlString);
        }
        this._colorTable.removeRows();
        try {
            IXmlElement root = XmlUtil.loadXmlString((String)xmlString);
            List contents = root.getChildren();
            for (int i = 0; i < contents.size(); ++i) {
                IXmlElement next = (IXmlElement)contents.get(i);
                if (!next.getName().equals("color")) continue;
                String value = next.getAttribute("value");
                String red = value.substring(0, 2);
                String green = value.substring(2, 4);
                String blue = value.substring(4, 6);
                String alpha = value.substring(6, value.length());
                Color c = new Color(Integer.parseInt(red, 16), Integer.parseInt(green, 16), Integer.parseInt(blue, 16), Integer.parseInt(alpha));
                IRow row = this._colorTable.addRow();
                row.getCell(0).setValue((Object)CtrlEXTMessages.getMLS("cycleColors", "\u5faa\u73af\u8272\u503c"));
                row.getCell(1).setValue((Object)c);
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            MessageUtil.msgboxInfo((Component)this.getParent(), CtrlEXTMessages.getMLS("errorInitializeColorScheme", "\u521d\u59cb\u5316\u914d\u8272\u65b9\u6848\u51fa\u9519\uff01\u5c06\u4ee5\u9ed8\u8ba4\u65b9\u6848\u8fdb\u884c\u521d\u59cb\u5316\uff01"), sw.toString());
        }
    }

    public String getText() {
        return (String)this._templateList.getSelectedItem();
    }

    public ColorTemplateVFPair getValue() {
        return this._currentValue;
    }

    private ColorTemplateVFPair serializeToXML() {
        StringBuilder sb = new StringBuilder("<template>");
        for (int i = 0; i < this._colorTable.getRowCount(); ++i) {
            IRow row = this._colorTable.getRow(i);
            Color c = (Color)row.getCell(1).getValue();
            String red = Integer.toString(c.getRed(), 16);
            String green = Integer.toString(c.getGreen(), 16);
            String blue = Integer.toString(c.getBlue(), 16);
            String alpha = String.valueOf(c.getAlpha());
            sb.append("<color value=\"");
            if (red.length() == 1) {
                sb.append('0');
            }
            sb.append(red);
            if (green.length() == 1) {
                sb.append('0');
            }
            sb.append(green);
            if (blue.length() == 1) {
                sb.append('0');
            }
            sb.append(blue);
            sb.append(alpha);
            sb.append("\"/>");
        }
        sb.append("</template>");
        String xml = sb.toString();
        return new ColorTemplateVFPair(this._currentValue == null ? null : this._currentValue.getBean(), xml);
    }

    private void updateListSelectionIndex(String xml) {
        int index = this.getTemplateIndex(xml);
        this._insertRow.setVisible(index == 0);
        this._deleteRow.setVisible(index == 0);
        this._templateList.setSelectedIndex(index);
    }

    private int getTemplateIndex(String xml) {
        if (ColorTemplateEditor.getBussinessSteadyTemplate().equalsIgnoreCase(xml)) {
            return 1;
        }
        if (ColorTemplateEditor.getElegantFacialTemplate().equalsIgnoreCase(xml)) {
            return 2;
        }
        if (ColorTemplateEditor.getNobleElegantTemplate().equalsIgnoreCase(xml)) {
            return 3;
        }
        if (ColorTemplateEditor.getPureSimpleTemplate().equalsIgnoreCase(xml)) {
            return 4;
        }
        if (ColorTemplateEditor.getSystemFusionchartsTemplate().equalsIgnoreCase(xml)) {
            return 5;
        }
        if (ColorTemplateEditor.getSystemTemplate().equalsIgnoreCase(xml)) {
            return 6;
        }
        if (ColorTemplateEditor.getSystemQingchartsTemplate().equalsIgnoreCase(xml)) {
            return 7;
        }
        return 0;
    }
}

