/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.combination;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.ColorVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.IntegerVFPair;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.extend.pattern.NumberFormatVFPair;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl.DefaultCombinationSeriesBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Categories;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Dataset;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Lineset;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.NodeFunc;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Set;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.util.FusionChartXmlBuilder;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class MSStackedColumn2DLineDYBean
extends DefaultCombinationSeriesBean {
    protected Lineset lineset;

    public MSStackedColumn2DLineDYBean() {
        this.chart_drawAnchors = new BooleanVFPair(true, null);
        this.chart_canvasBorderAlpha = new BooleanVFPair(true, null);
        this.chart_showLabels = new BooleanVFPair(true, null);
    }

    @Override
    protected void fillChartNodes(FusionChartDataNode dataNode) throws SyntaxErrorException {
        super.fillChartNodes(dataNode);
    }

    @Override
    protected void fillChartNodesByCell(FusionChartDataNode dataNode) throws SyntaxErrorException {
        String[] yAxis;
        String[] types;
        String[][] seriesValues;
        String[] groups;
        double[][] dataValues;
        if (dataNode.getDataWithoutCalc() != null) {
            dataValues = (double[][])dataNode.getDataWithoutCalc();
            groups = dataNode.getGroupKeysWithoutCalc();
            seriesValues = (String[][])dataNode.getSeriesKeysWithoutCalc();
            types = dataNode.getChartShowTypesWithoutCalc();
            yAxis = dataNode.getYAxisPositionWithoutCalc();
        } else {
            boolean isFillNullWithZero = dataNode.isFillNullWithZero();
            groups = this.parseStrings(dataNode, dataNode.getGroupFormula(), FusionChartDataNode.COMBINATION_CHART_GROUP_FORMULA);
            Object[] data = (Object[])dataNode.getData(FusionChartDataNode.COMBINATION_CHART_DATA_FORMULA);
            Object[] datas = new Object[data.length];
            if (dataNode.isSerialByCol()) {
                for (int i = 0; i < data.length; ++i) {
                    datas[i] = ChartDataTransferUtil.povitDoubles((Variant[][])data[i]);
                }
                dataValues = ChartDataTransferUtil.parseValue2Double(datas, isFillNullWithZero);
                dataNode.setData(dataValues);
            } else {
                dataValues = ChartDataTransferUtil.parseValue2Double(data, isFillNullWithZero);
                dataNode.setData(dataValues);
            }
            Object[] series = (Object[])dataNode.getData(FusionChartDataNode.COMBINATION_CHART_SERIES_FORMULA);
            int sLen = series.length;
            seriesValues = new String[sLen][];
            for (int i = 0; i < sLen; ++i) {
                seriesValues[i] = ChartDataTransferUtil.parseValue2String((Variant[][])series[i]).toArray(new String[((Variant[][])series[i]).length]);
            }
            types = this.parseValue2StringArray(dataNode.getData(FusionChartDataNode.COMBINATION_CHART_SERIES_TYPE));
            yAxis = this.parseValue2StringArray(dataNode.getData(FusionChartDataNode.COMBINATION_CHART_PARENTYAXIS));
            dataNode.setData(dataValues);
            dataNode.setGroupKeys(groups);
            dataNode.setSerieskeys(seriesValues);
            dataNode.setChartShowTypes(types);
            dataNode.setYAxisPosition(yAxis);
        }
        String[] seriesNames = this.parseValue2StringArray(dataNode.getData(FusionChartDataNode.COMBINATION_CHART_SERIES_NAMES));
        if (types == null || yAxis == null) {
            return;
        }
        int tLen = types.length;
        int gLen = groups.length;
        this.categories = new Categories();
        this.categories.categories = new Categories.Category[gLen];
        for (int i = 0; i < gLen; ++i) {
            this.categories.categories[i] = new Categories.Category(groups[i]);
        }
        this.datasets = new Dataset[tLen];
        int index = 0;
        for (int i = 0; i < tLen; ++i) {
            int nLen;
            String yAxisDis;
            this.datasets[i] = new Dataset();
            this.datasets[i].seriesName = seriesNames[i].toString();
            this.datasets[i].renderAs = FusionChartXmlBuilder.getChartRenderName(types[i]);
            this.datasets[i].parentYAxis = yAxisDis = FusionChartXmlBuilder.getChartYAxis(yAxis[i]);
            if (seriesValues[i] == null) continue;
            if (seriesValues[i].length > 0) {
                int sLen = seriesValues[i].length;
                this.datasets[i].dataset = new Dataset[sLen];
                for (int j = 0; j < sLen; ++j) {
                    if (seriesValues[i][j] == null) continue;
                    double[] temp = dataValues[index++];
                    this.datasets[i].dataset[j] = new Dataset();
                    this.datasets[i].dataset[j].seriesName = seriesValues[i][j];
                    nLen = temp.length;
                    nLen = Math.min(groups.length, nLen);
                    this.datasets[i].dataset[j].nodes = new NodeFunc[nLen];
                    for (int k = 0; k < nLen; ++k) {
                        Set set = new Set();
                        set.value = this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(temp[k])) : String.valueOf(temp[k]);
                        this.datasets[i].dataset[j].nodes[k] = set;
                        set.link = this.buildLinkProp(groups[k], seriesValues[i][j], String.valueOf(temp[k]));
                    }
                }
                continue;
            }
            double[] temp = dataValues[index++];
            nLen = temp.length;
            nLen = Math.min(groups.length, nLen);
            this.datasets[i].nodes = new NodeFunc[nLen];
            this.datasets[i].seriesName = seriesNames[i].toString();
            for (int j = 0; j < nLen; ++j) {
                Set set = new Set();
                set.value = this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(temp[j])) : String.valueOf(temp[j]);
                this.datasets[i].nodes[j] = set;
                set.link = this.buildLinkProp(groups[j], seriesNames[i].toString(), String.valueOf(temp[j]));
            }
        }
        int len = this.datasets.length;
        for (int i = 0; i < len; ++i) {
            if (!"Line".equals(this.datasets[i].renderAs)) continue;
            String sn = this.datasets[i].seriesName;
            NodeFunc[] nf = this.datasets[i].nodes;
            this.datasets[i] = new Lineset();
            this.datasets[i].seriesName = sn;
            this.datasets[i].nodes = nf;
        }
    }

    @Override
    protected void fillChartNodesByDataset(FusionChartDataNode dataNode) throws SyntaxErrorException {
        String[] groups = dataNode.getGroupKeys();
        Object[] dataValues = (Object[])dataNode.getData();
        Object[] seriesNames = (Object[])dataNode.getSeriesKeys();
        String[] types = dataNode.getChartShowTypes();
        String[] yAxis = dataNode.getYAxisPostion();
        int lenGroup = groups.length;
        this.categories = new Categories();
        this.categories.categories = new Categories.Category[lenGroup];
        for (int i = 0; i < lenGroup; ++i) {
            Categories.Category category = new Categories.Category();
            category.label = groups[i];
            this.categories.categories[i] = category;
        }
        int lenType = types.length;
        this.datasets = new Dataset[lenType];
        for (int i = 0; i < lenType; ++i) {
            String yAxisDis;
            this.datasets[i] = new Dataset();
            this.datasets[i].renderAs = FusionChartXmlBuilder.getChartRenderName(types[i]);
            this.datasets[i].parentYAxis = yAxisDis = FusionChartXmlBuilder.getChartYAxis(yAxis[i]);
            double[][] values = (double[][])dataValues[i];
            if (types[i].equals("column")) {
                String[] series = (String[])seriesNames[i];
                int lenSeries = series.length;
                this.datasets[i].dataset = new Dataset[lenSeries];
                for (int j = 0; j < lenSeries; ++j) {
                    this.datasets[i].dataset[j] = new Dataset();
                    this.datasets[i].dataset[j].seriesName = series[j];
                    this.datasets[i].dataset[j].nodes = new NodeFunc[lenGroup];
                    for (int k = 0; k < lenGroup; ++k) {
                        Set set = new Set();
                        set.value = this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(values[j][k])) : String.valueOf(values[j][k]);
                        this.datasets[i].dataset[j].nodes[k] = set;
                    }
                }
                continue;
            }
            this.datasets[i].nodes = new NodeFunc[lenGroup];
            this.datasets[i].seriesName = ((String[])seriesNames[i])[0];
            for (int j = 0; j < lenGroup; ++j) {
                Set set = new Set();
                set.value = this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(values[0][j])) : String.valueOf(values[0][j]);
                this.datasets[i].nodes[j] = set;
            }
            String sn = this.datasets[i].seriesName;
            NodeFunc[] nf = this.datasets[i].nodes;
            this.datasets[i] = new Lineset();
            this.datasets[i].seriesName = sn;
            this.datasets[i].nodes = nf;
        }
    }

    public String getDemoXML(List colors, HashMap numberFormats) {
        return super.getDemoXML(colors, numberFormats, new String[]{CtrlEXTMessages.getMLS("column", "\u67f1\u5f62"), CtrlEXTMessages.getMLS("line", "\u6298\u7ebf")}, new String[]{CtrlEXTMessages.getMLS("normal2", "\u6b63\u5e38"), CtrlEXTMessages.getMLS("rightAxis", "\u53f3\u8f74")});
    }

    @Override
    protected Dataset[] createChartNodes(Chart chart, Object[] dataValues, Object[] seriesNames, String[] groups, String[] types, String[] yAxis) throws SyntaxErrorException {
        int i;
        Variant[][] v0;
        int i2;
        seriesNames = new String[]{"", CtrlEXTMessages.getMLS("costConsumption", "\u6210\u672c\u8017\u8d39")};
        SecureRandom random = new SecureRandom();
        int tLen = types.length;
        boolean isSeriesByCol = true;
        Object[] seriesValues = new Object[tLen];
        Variant[] v1 = new Variant[]{new Variant(CtrlEXTMessages.getMLS("cosmetics", "\u5316\u5986\u54c1"), 11), new Variant(CtrlEXTMessages.getMLS("craftGoods", "\u5de5\u827a\u54c1"), 11), new Variant(CtrlEXTMessages.getMLS("food", "\u98df\u54c1"), 11)};
        for (i2 = 0; i2 < seriesValues.length; ++i2) {
            v0 = new Variant[1][1];
            if (i2 == 0) {
                v0[0] = v1;
            }
            seriesValues[i2] = v0;
        }
        dataValues = new Object[tLen];
        for (i2 = 0; i2 < dataValues.length; ++i2) {
            int k;
            v0 = new Variant[groups.length][1];
            if (i2 == 0) {
                for (k = 0; k < v0.length; ++k) {
                    v1 = new Variant[3];
                    for (int j = 0; j < v1.length; ++j) {
                        v1[j] = new Variant(BigDecimal.valueOf(random.nextDouble() * 10.0), 10);
                    }
                    v0[k] = v1;
                }
            } else {
                for (k = 0; k < v0.length; ++k) {
                    v0[k] = new Variant[]{new Variant(BigDecimal.valueOf(random.nextDouble() * 10.0), 10)};
                }
            }
            dataValues[i2] = v0;
        }
        Dataset[] datasets = new Dataset[tLen];
        for (int i3 = 0; i3 < tLen; ++i3) {
            int nLen;
            String yAxisDis;
            datasets[i3] = new Dataset();
            datasets[i3].seriesName = seriesNames[i3].toString();
            datasets[i3].renderAs = FusionChartXmlBuilder.getChartRenderName(types[i3]);
            datasets[i3].parentYAxis = yAxisDis = FusionChartXmlBuilder.getChartYAxis(yAxis[i3]);
            if (!(seriesValues[i3] instanceof Variant[][])) continue;
            int row = ((Variant[][])seriesValues[i3]).length;
            int col = ((Variant[][])seriesValues[i3])[0].length;
            Variant[] series = new Variant[row * col];
            int a3 = 0;
            for (int a1 = 0; a1 < row; ++a1) {
                for (int a2 = 0; a2 < col; ++a2) {
                    series[a3++] = ((Variant[][])seriesValues[i3])[a1][a2];
                }
            }
            if (series.length > 1) {
                int sLen = series.length;
                datasets[i3].dataset = new Dataset[sLen];
                for (int j = 0; j < sLen; ++j) {
                    Variant[] temp = this.parseVariant((Variant[][])dataValues[i3], isSeriesByCol, j);
                    datasets[i3].dataset[j] = new Dataset();
                    datasets[i3].dataset[j].seriesName = series[j].toString();
                    nLen = temp.length;
                    datasets[i3].dataset[j].nodes = new NodeFunc[nLen];
                    for (int k = 0; k < nLen; ++k) {
                        Set set = new Set();
                        set.value = chart.percent != null && Integer.parseInt(chart.percent) == 1 ? this.magnify100(String.valueOf(temp[k].doubleValue())) : String.valueOf(temp[k].doubleValue());
                        datasets[i3].dataset[j].nodes[k] = set;
                        set.link = this.buildLinkProp(groups[k], series[j].toString(), String.valueOf(temp[k].doubleValue()));
                    }
                }
                continue;
            }
            Variant[] temp = this.parseVariant((Variant[][])dataValues[i3], isSeriesByCol, 0);
            nLen = temp.length;
            datasets[i3].nodes = new NodeFunc[nLen];
            datasets[i3].seriesName = seriesNames[i3].toString();
            for (int j = 0; j < nLen; ++j) {
                Set set = new Set();
                set.value = chart.percent != null && Integer.parseInt(chart.percent) == 1 ? this.magnify100(String.valueOf(temp[j].doubleValue())) : String.valueOf(temp[j].doubleValue());
                datasets[i3].nodes[j] = set;
                set.link = this.buildLinkProp(groups[j], seriesNames[i3].toString(), String.valueOf(temp[j].doubleValue()));
            }
        }
        int len = datasets.length;
        ArrayList<Dataset> list = new ArrayList<Dataset>(len);
        for (i = 0; i < len; ++i) {
            if (!"Line".equals(datasets[i].renderAs)) continue;
            list.add(datasets[i]);
            datasets[i] = new Dataset();
        }
        for (i = 0; i < len; ++i) {
            Dataset ds = datasets[i];
            if (ds.nodes == null) continue;
            ds.dataset = new Dataset[1];
            ds.dataset[0] = new Dataset();
            ds.dataset[0].nodes = ds.nodes;
            ds.nodes = null;
        }
        list.trimToSize();
        len = list.size();
        for (i = 0; i < len; ++i) {
            Lineset lineset = new Lineset();
            lineset.seriesName = ((Dataset)list.get((int)i)).seriesName;
            lineset.nodes = ((Dataset)list.get((int)i)).nodes;
            chart.setAttribute(lineset);
        }
        return datasets;
    }

    @Override
    public void setChart_useRoundEdges(BooleanVFPair chartUseRoundEdges) {
        this.chart_useRoundEdges = chartUseRoundEdges;
    }

    @Override
    public void setChart_plotGradientColor(String chartPlotGradientColor) {
        this.chart_plotGradientColor = chartPlotGradientColor;
    }

    @Override
    public void setChart_drawAnchors(BooleanVFPair chartDrawAnchors) {
        this.chart_drawAnchors = chartDrawAnchors;
    }

    @Override
    public void setChart_borderColor(ColorVFPair chartBorderColor) {
        this.chart_borderColor = chartBorderColor;
    }

    @Override
    public void setChart_borderThickness(IntegerVFPair chartBorderThickness) {
        this.chart_borderThickness = chartBorderThickness;
    }

    @Override
    public void setDataLabelFormat(NumberFormatVFPair dataLabelFormat) {
        this.dataLabelFormat = dataLabelFormat;
    }

    @Override
    public void setYAxisFormat(NumberFormatVFPair yAxisFormat) {
        this.yAxisFormat = yAxisFormat;
    }

    @Override
    public void setXAxisFormat(NumberFormatVFPair xAxisFormat) {
        this.xAxisFormat = xAxisFormat;
    }

    @Override
    public void setChart_smoothCurve(BooleanVFPair chart_smoothCurve) {
        this.chart_smoothCurve = chart_smoothCurve;
    }

    @Override
    public void setChartXStartValue(String chartXStartValue) {
        this.chartXStartValue = chartXStartValue;
    }

    @Override
    public void setChartXEndValue(String chartXEndValue) {
        this.chartXEndValue = chartXEndValue;
    }
}

