/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.BooleanVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.ColorVFPair;
import com.kingdee.cosmic.ctrl.ext.pe.beans.value.IntegerVFPair;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.Variant;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Categories;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Chart;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Dataset;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.NodeFunc;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Set;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.util.FusionChartXmlBuilder;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.TransferUtils;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public abstract class DefaultCombinationSeriesBean
extends AbstractFusionBean {
    private static final Logger logger = LogUtil.getPackageLogger(DefaultCombinationSeriesBean.class);
    protected String rightYNumberPrefix;
    protected String rightYNumberAppendix;

    public DefaultCombinationSeriesBean() {
        this.isHyperLinkEnabled = false;
    }

    private static final String[] getStaticTypes() {
        return new String[]{CtrlEXTMessages.getMLS("column", "\u67f1\u5f62"), CtrlEXTMessages.getMLS("area", "\u9762\u79ef"), CtrlEXTMessages.getMLS("line", "\u6298\u7ebf")};
    }

    private static final String[] getStaticYAxis() {
        return new String[]{CtrlEXTMessages.getMLS("normal2", "\u6b63\u5e38"), CtrlEXTMessages.getMLS("normal2", "\u6b63\u5e38"), CtrlEXTMessages.getMLS("normal2", "\u6b63\u5e38")};
    }

    @Override
    protected void customAttributes(FusionChartDataNode dataNode) {
    }

    @Override
    protected void fillChartNodes(FusionChartDataNode dataNode) throws SyntaxErrorException {
        super.fillChartNodes(dataNode);
        super.applyNumberFormats();
        String[] yAxisSettings = this.parseValue2StringArray(dataNode.getData(FusionChartDataNode.COMBINATION_CHART_RIGHT_YAXIS_SETTINGS));
        if (yAxisSettings != null && yAxisSettings.length > 0) {
            this.chart.sNumberSuffix = yAxisSettings[0];
            this.chart.SYAxisName = yAxisSettings[1];
        }
        this.chart.setAttribute("showLegend", "1");
        if ("dataset".equals(dataNode.getDataFrom())) {
            this.fillChartNodesByDataset(dataNode);
        } else {
            this.fillChartNodesByCell(dataNode);
        }
    }

    protected void fillChartNodesByCell(FusionChartDataNode dataNode) throws SyntaxErrorException {
        String[] yAxis;
        String[] types;
        double[][] dataValues;
        String[] groups;
        Object[] seriesNames = new Object[]{"", ""};
        boolean isFillNullWithZero = dataNode.isFillNullWithZero();
        if (dataNode.getDataWithoutCalc() != null) {
            dataNode.setDirty(false);
            groups = dataNode.getGroupKeys();
            dataValues = (double[][])dataNode.getData();
            seriesNames = (Object[])dataNode.getSeriesKeys();
            types = dataNode.getChartShowTypes();
            yAxis = dataNode.getYAxisPostion();
        } else {
            groups = this.parseStrings(dataNode, dataNode.getGroupFormula(), FusionChartDataNode.COMBINATION_CHART_GROUP_FORMULA);
            String[] seriesFormulas = (String[])dataNode.getFormula(FusionChartDataNode.COMBINATION_CHART_SERIES_FORMULA);
            if (!TransferUtils.isEmptyStringArray(seriesFormulas)) {
                seriesNames = ChartDataTransferUtil.parseStrings(dataNode, seriesFormulas);
            } else {
                Object[] seriesNamesObject = (Object[])dataNode.getData(FusionChartDataNode.COMBINATION_CHART_SERIES_NAMES);
                seriesNames = ChartDataTransferUtil.parseValue2StringArray(seriesNamesObject);
            }
            types = this.parseValue2StringArray(dataNode.getData(FusionChartDataNode.COMBINATION_CHART_SERIES_TYPE));
            yAxis = this.parseValue2StringArray(dataNode.getData(FusionChartDataNode.COMBINATION_CHART_PARENTYAXIS));
            Object[] data = (Object[])dataNode.getData(FusionChartDataNode.COMBINATION_CHART_DATA_FORMULA);
            Object[] datas = new Object[data.length];
            if (dataNode.isSerialByCol()) {
                for (int i = 0; i < data.length; ++i) {
                    datas[i] = ChartDataTransferUtil.povitDoubles((com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][])data[i]);
                }
                dataValues = ChartDataTransferUtil.parseValue2Double(datas, isFillNullWithZero);
                dataNode.setData(dataValues);
            } else {
                dataValues = ChartDataTransferUtil.parseValue2Double(data, isFillNullWithZero);
                dataNode.setData(dataValues);
            }
            dataNode.setGroupKeys(groups);
            dataNode.setSerieskeys(seriesNames);
            dataNode.setChartShowTypes(types);
            dataNode.setYAxisPosition(yAxis);
            dataNode.setDirty(false);
        }
        int tLen = types.length;
        int gLen = groups.length;
        this.categories = new Categories();
        this.categories.categories = new Categories.Category[gLen];
        for (int i = 0; i < gLen; ++i) {
            this.categories.categories[i] = new Categories.Category(groups[i]);
        }
        this.datasets = new Dataset[tLen];
        ArrayList<Dataset> list = new ArrayList<Dataset>();
        for (int i = 0; i < tLen; ++i) {
            int nLen;
            int j;
            this.datasets[i] = new Dataset();
            this.datasets[i].seriesName = seriesNames[i].toString();
            this.datasets[i].renderAs = FusionChartXmlBuilder.getChartRenderName(types[i]);
            this.datasets[i].parentYAxis = FusionChartXmlBuilder.getChartYAxis(yAxis[i]);
            if (!(seriesNames[i] instanceof com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][])) continue;
            int row = ((com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][])seriesNames[i]).length;
            int col = ((com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][])seriesNames[i])[0].length;
            com.kingdee.cosmic.ctrl.extcommon.variant.Variant[] series = new com.kingdee.cosmic.ctrl.extcommon.variant.Variant[row * col];
            int a3 = 0;
            for (int a1 = 0; a1 < row; ++a1) {
                for (int a2 = 0; a2 < col; ++a2) {
                    series[a3++] = ((com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][])seriesNames[i])[a1][a2];
                }
            }
            if (series.length > 1) {
                int sLen = series.length;
                this.datasets[i].dataset = new Dataset[sLen];
                for (j = 0; j < sLen; ++j) {
                    this.datasets[i].dataset[j] = new Dataset();
                    list.add(this.datasets[i].dataset[j]);
                    this.datasets[i].dataset[j].seriesName = series[j].toString();
                    this.datasets[i].dataset[j].renderAs = this.datasets[i].renderAs;
                    this.datasets[i].dataset[j].parentYAxis = this.datasets[i].parentYAxis;
                    nLen = dataValues[i].length;
                    nLen = Math.min(groups.length, nLen);
                    this.datasets[i].dataset[j].nodes = new NodeFunc[nLen];
                    for (int k = 0; k < nLen; ++k) {
                        Set set = new Set();
                        String linkValue = "";
                        set.value = this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? (Double.isNaN(dataValues[i][k]) ? (isFillNullWithZero ? "0" : "") : this.magnify100(String.valueOf(dataValues[i][k]))) : (Double.isNaN(dataValues[i][k]) ? (isFillNullWithZero ? "0" : "") : String.valueOf(dataValues[i][k]));
                        linkValue = String.valueOf(dataValues[i][k]);
                        this.datasets[i].dataset[j].nodes[k] = set;
                        set.link = this.buildLinkProp(groups[k], series[j].toString(), linkValue);
                    }
                }
                this.datasets[i].dataset = null;
                int size = list.size();
                if (size <= 0) continue;
                this.datasets = new Dataset[size];
                list.toArray(this.datasets);
                continue;
            }
            nLen = dataValues[i].length;
            nLen = Math.min(groups.length, nLen);
            this.datasets[i].nodes = new NodeFunc[nLen];
            this.datasets[i].seriesName = ((com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][])seriesNames[i])[0][0].toString();
            for (j = 0; j < nLen; ++j) {
                Set set = new Set();
                String linkValue = "";
                set.value = this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? (Double.isNaN(dataValues[i][j]) ? (isFillNullWithZero ? "0" : "") : this.magnify100(String.valueOf(dataValues[i][j]))) : (Double.isNaN(dataValues[i][j]) ? (isFillNullWithZero ? "0" : "") : String.valueOf(dataValues[i][j]));
                linkValue = String.valueOf(dataValues[i][j]);
                this.datasets[i].nodes[j] = set;
                set.link = this.buildLinkProp(groups[j], this.datasets[i].seriesName, linkValue);
            }
        }
    }

    protected void fillChartNodesByDataset(FusionChartDataNode dataNode) throws SyntaxErrorException {
        String[] groups = dataNode.getGroupKeys();
        Object[] dataValues = (Object[])dataNode.getData();
        String[] seriesNames = (String[])dataNode.getSeriesKeys();
        String[] types = dataNode.getChartShowTypes();
        String[] yAxis = dataNode.getYAxisPostion();
        int gLen = groups.length;
        this.categories = new Categories();
        this.categories.categories = new Categories.Category[gLen];
        for (int i = 0; i < gLen; ++i) {
            this.categories.categories[i] = new Categories.Category(groups[i]);
        }
        int tLen = types.length;
        this.datasets = new Dataset[tLen];
        for (int i = 0; i < tLen; ++i) {
            this.datasets[i] = new Dataset();
            this.datasets[i].seriesName = seriesNames[i];
            this.datasets[i].renderAs = FusionChartXmlBuilder.getChartRenderName(types[i]);
            this.datasets[i].parentYAxis = FusionChartXmlBuilder.getChartYAxis(yAxis[i]);
            double[][] datas = (double[][])dataValues[i];
            double[] temp = datas[0];
            int nLen = temp.length;
            this.datasets[i].nodes = new NodeFunc[nLen];
            for (int j = 0; j < nLen; ++j) {
                Set set = new Set();
                set.value = this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(temp[j])) : String.valueOf(temp[j]);
                this.datasets[i].nodes[j] = set;
                set.link = this.buildLinkProp(groups[j], seriesNames[i], String.valueOf(temp[j]));
            }
        }
    }

    @Override
    protected String[] buildChartCaptions(FusionChartDataNode dataNode) {
        String[] ret = super.buildChartCaptions(dataNode);
        this.chart.PYAxisName = this.chart.yAxisName;
        return ret;
    }

    @Override
    protected void attachHyperLinkImpl(String[] hyperLinks) {
    }

    @Override
    public String calcPlayerID(String cell, int bindingPolicy) {
        String ret = null;
        switch (bindingPolicy) {
            case 2: {
                ret = cell;
                break;
            }
            case 0: {
                break;
            }
        }
        return ret;
    }

    protected com.kingdee.cosmic.ctrl.extcommon.variant.Variant[] parseVariant(com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][] array, boolean isSeriesByCol, int fix) {
        int i;
        ArrayList<com.kingdee.cosmic.ctrl.extcommon.variant.Variant> list = new ArrayList<com.kingdee.cosmic.ctrl.extcommon.variant.Variant>();
        int row = array.length;
        int col = array[0].length;
        if (isSeriesByCol) {
            for (i = 0; i < row; ++i) {
                list.add(array[i][fix]);
            }
        } else {
            for (i = 0; i < col; ++i) {
                list.add(array[fix][i]);
            }
        }
        com.kingdee.cosmic.ctrl.extcommon.variant.Variant[] ret = new com.kingdee.cosmic.ctrl.extcommon.variant.Variant[list.size()];
        list.toArray(ret);
        return ret;
    }

    protected String[] parseStrings(FusionChartDataNode dataNode, String formulas, int flag) {
        if (StringUtil.isEmptyString((String)formulas)) {
            return new String[0];
        }
        com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][] values = dataNode.calcExpr(dataNode, formulas, flag);
        int row = values.length;
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < row; ++i) {
            int col = values[i].length;
            for (int j = 0; j < col; ++j) {
                if (values[i][j] instanceof Variant) {
                    ret.add(((Variant)values[i][j]).getText());
                    continue;
                }
                ret.add(values[i][j].toString());
            }
        }
        String[] str = new String[ret.size()];
        ret.toArray(str);
        return str;
    }

    public String getRightYNumberPrefix() {
        return this.rightYNumberPrefix;
    }

    public void setRightYNumberPrefix(String rightYNumberPrefix) {
        this.rightYNumberPrefix = rightYNumberPrefix;
    }

    public String getRightYNumberAppendix() {
        return this.rightYNumberAppendix;
    }

    public void setRightYNumberAppendix(String rightYNumberAppendix) {
        this.rightYNumberAppendix = rightYNumberAppendix;
    }

    protected String[] arrayVariant2String(com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][] seriesNames) {
        String[] series = null;
        int row = seriesNames.length;
        int col = seriesNames[0].length;
        series = new String[row * col];
        int a3 = 0;
        for (int a1 = 0; a1 < row; ++a1) {
            for (int a2 = 0; a2 < col; ++a2) {
                series[a3++] = seriesNames[a1][a2].toString();
            }
        }
        return series;
    }

    public String getDemoXML(List colors, HashMap numberFormats, String[] types, String[] yAxis) {
        int i;
        SecureRandom random = new SecureRandom();
        String[] groups = DefaultCombinationSeriesBean.getDemoLabels();
        Object[] dataValues = new Object[groups.length];
        com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][] v0 = new com.kingdee.cosmic.ctrl.extcommon.variant.Variant[3][1];
        com.kingdee.cosmic.ctrl.extcommon.variant.Variant[] v1 = new com.kingdee.cosmic.ctrl.extcommon.variant.Variant[groups.length];
        for (int j = 0; j < v1.length; ++j) {
            v1[j] = new com.kingdee.cosmic.ctrl.extcommon.variant.Variant(BigDecimal.valueOf(random.nextDouble() * 10.0), 10);
        }
        for (int i2 = 0; i2 < dataValues.length; ++i2) {
            v0 = new com.kingdee.cosmic.ctrl.extcommon.variant.Variant[1][1];
            v0[0] = v1;
            dataValues[i2] = v0;
        }
        Object[] seriesNames = new Object[3];
        for (int i3 = 0; i3 < seriesNames.length; ++i3) {
            v1 = new com.kingdee.cosmic.ctrl.extcommon.variant.Variant[1];
            switch (i3) {
                case 0: {
                    v1[0] = new com.kingdee.cosmic.ctrl.extcommon.variant.Variant(CtrlEXTMessages.getMLS("salesPerformance", "\u9500\u552e\u4e1a\u7ee9"), 11);
                    break;
                }
                case 1: {
                    v1[0] = new com.kingdee.cosmic.ctrl.extcommon.variant.Variant(CtrlEXTMessages.getMLS("profit", "\u5229\u6da6"), 11);
                    break;
                }
                case 2: {
                    v1[0] = new com.kingdee.cosmic.ctrl.extcommon.variant.Variant(CtrlEXTMessages.getMLS("customerSatisfaction", "\u5ba2\u6237\u6ee1\u610f\u5ea6"), 11);
                }
            }
            v0 = new com.kingdee.cosmic.ctrl.extcommon.variant.Variant[1][1];
            v0[0] = v1;
            seriesNames[i3] = v0;
        }
        if (types == null) {
            types = DefaultCombinationSeriesBean.getStaticTypes();
        }
        if (yAxis == null) {
            yAxis = DefaultCombinationSeriesBean.getStaticYAxis();
        }
        Chart chart = new Chart();
        Dataset[] datasets = null;
        try {
            datasets = this.createChartNodes(chart, dataValues, seriesNames, groups, types, yAxis);
        }
        catch (SyntaxErrorException e1) {
            logger.error((Object)"err", (Throwable)e1);
        }
        for (Map.Entry entry : numberFormats.entrySet()) {
            String value = (String)entry.getValue();
            if (StringUtil.isEmptyString((String)value)) continue;
            if (Boolean.toString(true).equals(value)) {
                value = "1";
            } else if (Boolean.toString(false).equals(value)) {
                value = "0";
            }
            chart.setAttribute((String)entry.getKey(), value);
        }
        chart.setAttribute("formatNumberScale", "0");
        Dataset[] nodes = datasets;
        int colorIndex = 0;
        if (colors.size() > 0 && nodes != null) {
            for (int i4 = 0; i4 < nodes.length; ++i4) {
                String nextColor = (String)colors.get(colorIndex++);
                String color = nextColor.substring(0, 6);
                if (nodes[i4] instanceof Dataset) {
                    Dataset ds = nodes[i4];
                    if (ds.dataset == null) {
                        ds.color = color;
                        if (!this._fillColor) {
                            ds.alpha = "0";
                        }
                    } else {
                        for (int j = ds.dataset.length - 1; j >= 0; --j) {
                            ds.dataset[j].color = color = nextColor.substring(0, 6);
                            if (!this._fillColor) {
                                ds.dataset[j].alpha = "0";
                            }
                            if (colorIndex == colors.size()) {
                                colorIndex = 0;
                            }
                            nextColor = (String)colors.get(colorIndex++);
                        }
                    }
                }
                if (colorIndex != colors.size()) continue;
                colorIndex = 0;
            }
        }
        int gLen = groups.length;
        Categories categories = new Categories();
        categories.categories = new Categories.Category[gLen];
        for (i = 0; i < gLen; ++i) {
            categories.categories[i] = new Categories.Category(groups[i]);
        }
        if (categories != null && datasets != null) {
            chart.setAttribute(categories);
            int length = datasets.length;
            for (i = 0; i < length; ++i) {
                chart.setAttribute(datasets[i]);
            }
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        buffer.reset();
        IXmlElement root = chart.toXML();
        try {
            XmlUtil.save((IXmlElement)root, (OutputStream)buffer);
            return new String(buffer.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)"err", (Throwable)e);
        }
        return "";
    }

    protected Dataset[] createChartNodes(Chart chart, Object[] dataValues, Object[] seriesNames, String[] groups, String[] types, String[] yAxis) throws SyntaxErrorException {
        boolean isSeriesByCol = false;
        boolean isFillNullWithZero = true;
        int tLen = types.length;
        Dataset[] datasets = new Dataset[tLen];
        ArrayList<Dataset> list = new ArrayList<Dataset>();
        for (int i = 0; i < tLen; ++i) {
            int nLen;
            datasets[i] = new Dataset();
            datasets[i].seriesName = seriesNames[i].toString();
            datasets[i].renderAs = FusionChartXmlBuilder.getChartRenderName(types[i]);
            datasets[i].parentYAxis = FusionChartXmlBuilder.getChartYAxis(yAxis[i]);
            if (!(seriesNames[i] instanceof com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][])) continue;
            int row = ((com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][])seriesNames[i]).length;
            int col = ((com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][])seriesNames[i])[0].length;
            com.kingdee.cosmic.ctrl.extcommon.variant.Variant[] series = new com.kingdee.cosmic.ctrl.extcommon.variant.Variant[row * col];
            int a3 = 0;
            for (int a1 = 0; a1 < row; ++a1) {
                for (int a2 = 0; a2 < col; ++a2) {
                    series[a3++] = ((com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][])seriesNames[i])[a1][a2];
                }
            }
            if (series.length > 1) {
                int sLen = series.length;
                datasets[i].dataset = new Dataset[sLen];
                for (int j = 0; j < sLen; ++j) {
                    com.kingdee.cosmic.ctrl.extcommon.variant.Variant[] temp = this.parseVariant((com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][])dataValues[i], isSeriesByCol, j);
                    datasets[i].dataset[j] = new Dataset();
                    list.add(datasets[i].dataset[j]);
                    datasets[i].dataset[j].seriesName = series[j].toString();
                    datasets[i].dataset[j].renderAs = datasets[i].renderAs;
                    datasets[i].dataset[j].parentYAxis = datasets[i].parentYAxis;
                    nLen = temp.length;
                    datasets[i].dataset[j].nodes = new NodeFunc[nLen];
                    for (int k = 0; k < nLen; ++k) {
                        Set set = new Set();
                        String linkValue = "";
                        try {
                            set.value = chart.percent != null && Integer.parseInt(chart.percent) == 1 ? (temp[k].equals(com.kingdee.cosmic.ctrl.extcommon.variant.Variant.emptyVariant) ? (isFillNullWithZero ? "0" : "") : this.magnify100(String.valueOf(temp[k].doubleValue()))) : (temp[k].equals(com.kingdee.cosmic.ctrl.extcommon.variant.Variant.emptyVariant) ? (isFillNullWithZero ? "0" : "") : String.valueOf(temp[k].doubleValue()));
                            linkValue = String.valueOf(temp[k].doubleValue());
                        }
                        catch (SyntaxErrorException e) {
                            set.value = "0";
                            linkValue = "0";
                        }
                        datasets[i].dataset[j].nodes[k] = set;
                        set.link = this.buildLinkProp(groups[k], series[j].toString(), linkValue);
                    }
                }
                datasets[i].dataset = null;
                int size = list.size();
                if (size <= 0) continue;
                datasets = new Dataset[size];
                list.toArray(datasets);
                continue;
            }
            com.kingdee.cosmic.ctrl.extcommon.variant.Variant[] temp = this.parseVariant((com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][])dataValues[i], isSeriesByCol, 0);
            nLen = temp.length;
            datasets[i].nodes = new NodeFunc[nLen];
            datasets[i].seriesName = ((com.kingdee.cosmic.ctrl.extcommon.variant.Variant[][])seriesNames[i])[0][0].toString();
            for (int j = 0; j < nLen; ++j) {
                Set set = new Set();
                String linkValue = "";
                try {
                    set.value = chart.percent != null && Integer.parseInt(chart.percent) == 1 ? (temp[j].equals(com.kingdee.cosmic.ctrl.extcommon.variant.Variant.emptyVariant) ? (isFillNullWithZero ? "0" : "") : this.magnify100(String.valueOf(temp[j].doubleValue()))) : (temp[j].equals(com.kingdee.cosmic.ctrl.extcommon.variant.Variant.emptyVariant) ? (isFillNullWithZero ? "0" : "") : String.valueOf(temp[j].doubleValue()));
                    linkValue = String.valueOf(temp[j].doubleValue());
                }
                catch (SyntaxErrorException e) {
                    set.value = "0";
                    linkValue = "0";
                }
                datasets[i].nodes[j] = set;
                set.link = this.buildLinkProp(groups[j], datasets[i].seriesName, linkValue);
            }
        }
        return datasets;
    }

    @Override
    public void setChart_showValues(BooleanVFPair chartShowValues) {
        this.chart_showValues = chartShowValues;
    }

    @Override
    public void setChart_showPlotBorder(BooleanVFPair chartShowPlotBorder) {
        this.chart_showPlotBorder = chartShowPlotBorder;
    }

    @Override
    public void setChart_canvasBorderAlpha(BooleanVFPair chartCanvasBorderAlpha) {
        this.chart_canvasBorderAlpha = chartCanvasBorderAlpha;
    }

    @Override
    public void setChart_canvasBorderThickness(IntegerVFPair chartCanvasBorderThickness) {
        this.chart_canvasBorderThickness = chartCanvasBorderThickness;
    }

    @Override
    public void setChart_showLegend(BooleanVFPair chartShowLegend) {
        this.chart_showLegend = chartShowLegend;
    }

    @Override
    public void setChart_legendPosition(String chartLegendPosition) {
        this.chart_legendPosition = chartLegendPosition;
    }

    @Override
    public void setTextScale(String testScale) {
        this.textScale = testScale;
    }

    @Override
    public void setChart_nullValueDisplayMode(String chart_nullValueDisplayMode) {
        this.chart_nullValueDisplayMode = chart_nullValueDisplayMode;
    }

    @Override
    public void setChartBaseFontName(String chartBaseFontName) {
        this.chartBaseFontName = chartBaseFontName;
    }

    @Override
    public void setChart_divLineAlpha(IntegerVFPair chartDivLineAlpha) {
        this.chart_divLineAlpha = chartDivLineAlpha;
    }

    @Override
    public void setChart_alternateHGridAlpha(IntegerVFPair chartAlternateHGridAlpha) {
        this.chart_alternateHGridAlpha = chartAlternateHGridAlpha;
    }

    @Override
    public void setTrendlineStartValue(String trendlineStartValue) {
        this.trendlineStartValue = trendlineStartValue;
    }

    @Override
    public void setTrendlineEndValue(String trendlineEndValue) {
        this.trendlineEndValue = trendlineEndValue;
    }

    @Override
    public void setTrendlineColor(ColorVFPair trendlineColor) {
        this.trendlineColor = trendlineColor;
    }

    @Override
    public void setTrendlineDisplayValue(String trendlineDisplayValue) {
        this.trendlineDisplayValue = trendlineDisplayValue;
    }

    @Override
    public void setTrendlineDashed(String trendlineDashed) {
        this.trendlineDashed = trendlineDashed;
    }

    @Override
    public void setTrendlineTrendzone(BooleanVFPair trendlineTrendzone) {
        this.trendlineTrendzone = trendlineTrendzone;
    }

    @Override
    public void setTrendlineOnTop(BooleanVFPair trendlineOnTop) {
        this.trendlineOnTop = trendlineOnTop;
    }

    @Override
    public void setTrendlineDisplayRight(String trendlineDisplayRight) {
        this.trendlineDisplayRight = trendlineDisplayRight;
    }

    @Override
    public void setShowTrendLineValue(BooleanVFPair showTrendLineValue) {
        this.showTrendLineValue = showTrendLineValue;
    }

    @Override
    public void setChartYStartValue(String chartYStartValue) {
        this.chartYStartValue = chartYStartValue;
    }

    @Override
    public void setChartYEndValue(String chartYEndValue) {
        this.chartYEndValue = chartYEndValue;
    }

    @Override
    public void setChart_showYAxisValues(BooleanVFPair chartShowYAxisValues) {
        this.chart_showYAxisValues = chartShowYAxisValues;
    }
}

