/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl;

import chrriis.dj.nativeswing.common.Utils;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Categories;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Dataset;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.NodeFunc;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Set;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.echarts.transfer.ChartDataTransferUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.qingcharts.QingChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;
import java.util.HashMap;
import java.util.List;

public abstract class DefaultMultiSeiresBean
extends AbstractFusionBean {
    public DefaultMultiSeiresBean() {
        this.isHyperLinkEnabled = false;
    }

    @Override
    protected void fillChartNodes(FusionChartDataNode dataNode) throws SyntaxErrorException {
        super.applyNumberFormats();
        super.fillChartNodes(dataNode);
        boolean isSeriesByCol = dataNode.isSerialByCol();
        Object[] group = dataNode.getGroupKeys();
        String[] series = (String[])dataNode.getSeriesKeys();
        double[][] data = (double[][])dataNode.getData();
        if (data == null || group == null || series == null) {
            return;
        }
        if ((dataNode.getChartType().equals(QingChartType.QING_CT_P_COLUMN) || dataNode.getChartType().equals(QingChartType.QING_CT_P_BAR)) && this.isNeedSort(dataNode)) {
            ChartDataTransferUtil.sortedPChart(data, this.sortType, group);
        } else if (this.isNeedSort(dataNode)) {
            ChartDataTransferUtil.sortedMSTChart(data, this.sortType, group);
        }
        Sheet sheet = dataNode.getSheet();
        CellBlockNode[] cb = null;
        String dataFormula = dataNode.getDataFormula();
        if (!StringUtil.isEmptyString((String)dataFormula)) {
            cb = SheetBaseMath.getArrayBlockNodes(sheet, dataNode.getDataFormula(), sheet.getBook().getDeps().isA1Style());
        }
        int cbLength = cb == null ? 0 : cb.length;
        this.categories = new Categories();
        this.categories.categories = new Categories.Category[group.length];
        int len = group.length;
        for (int i = 0; i < len; ++i) {
            this.categories.categories[i] = new Categories.Category((String)group[i]);
        }
        this.datasets = new Dataset[series.length];
        String cellRef = null;
        int len2 = series.length;
        for (int i = 0; i < len2; ++i) {
            this.datasets[i] = new Dataset();
            this.datasets[i].nodes = new NodeFunc[data[i].length];
            this.datasets[i].seriesName = series[i];
            for (int j = 0; j < data[i].length; ++j) {
                Set s = new Set();
                this.datasets[i].nodes[j] = s;
                if (this.isHyperLinkEnabled && this.hyperLinks != null && this.hyperLinks.length > 0) {
                    if (cbLength > 1 && null != cb) {
                        cellRef = isSeriesByCol ? cb[i].getSheet().getCell(cb[i].getRow() + j, cb[i].getCol(), true).getName(false, false) : cb[j].getSheet().getCell(cb[j].getRow(), cb[j].getCol() + j, true).getName(false, false);
                    } else if (cbLength == 1 && null != cb) {
                        cellRef = isSeriesByCol ? cb[0].getSheet().getCell(cb[0].getRow() + j, cb[0].getCol() + i, true).getName(false, false) : cb[0].getSheet().getCell(cb[0].getRow() + i, cb[0].getCol() + j, true).getName(false, false);
                    }
                    this.datasets[i].nodes[j].setCellRef(cellRef);
                }
                s.value = this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(data[i][j])) : String.valueOf(data[i][j]);
                s.link = this.buildLinkProp((String)group[j], series[i], String.valueOf(data[i][j]));
            }
        }
        this.chart.setAttribute("showValues", "1");
    }

    @Override
    protected void customAttributes(FusionChartDataNode dataNode) {
    }

    @Override
    protected void attachHyperLinkImpl(String[] hyperLinks) {
        int datasetSize = this.datasets.length;
        int index = hyperLinks[0].indexOf("[cell]");
        int index2 = index + 6;
        for (int i = 0; i < datasetSize; ++i) {
            int nodesSize = this.datasets[i].nodes.length;
            for (int j = 0; j < nodesSize; ++j) {
                if (this.datasets[i].nodes[j].getCellRef() == null) continue;
                ((Set)this.datasets[i].nodes[j]).link = Utils.encodeURL((String)(hyperLinks[0].substring(0, index) + "[" + this.datasets[i].nodes[j].getCellRef() + "]" + hyperLinks[0].substring(index2)));
            }
        }
    }

    @Override
    public String calcPlayerID(String cell, int bindingPolicy) {
        String ret = null;
        int series = this.datasets.length;
        switch (bindingPolicy) {
            case 2: {
                ret = cell;
                break;
            }
            case 0: {
                for (int i = 0; i < series; ++i) {
                    int n = this.datasets[i].nodes.length;
                    for (int j = 0; j < n; ++j) {
                        if (!cell.equals(this.datasets[i].nodes[j].getCellRef())) continue;
                        return "G" + j;
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < series; ++i) {
                    int n = this.datasets[i].nodes.length;
                    for (int j = 0; j < n; ++j) {
                        if (!cell.equals(this.datasets[i].nodes[j].getCellRef())) continue;
                        return "S" + i;
                    }
                }
                break;
            }
        }
        return ret;
    }

    public static String getDemoXML(int categories, String chartTypeName, List colors, HashMap numberFormats) {
        boolean isDecline = categories < 0;
        categories = Math.abs(categories);
        StringBuilder sb = new StringBuilder(DefaultMultiSeiresBean.generateCommonDemoChartTtile(chartTypeName, numberFormats));
        sb.append("<categories>");
        StringBuilder sb2 = new StringBuilder();
        for (int i = 0; i < categories; ++i) {
            sb.append("<category label='");
            sb.append(CtrlEXTMessages.getMLS("group", "\u5206\u7ec4"));
            sb.append(i + 1);
            sb.append("' />");
        }
        int step = 20;
        int setValue = isDecline ? categories * colors.size() * step : 0;
        String[] demoLabels = DefaultMultiSeiresBean.getDemoLabels();
        int lenSeries = demoLabels.length;
        int len = colors.size();
        for (int j = 0; j < len; ++j) {
            String nextColor = (String)colors.get(j);
            String color = nextColor.substring(0, 6);
            String alpha = String.valueOf((int)((double)Integer.parseInt(nextColor.substring(6, nextColor.length())) * 0.4));
            sb2.append("<dataset seriesName='");
            if (j < lenSeries) {
                sb2.append(demoLabels[j]);
            } else {
                sb2.append(demoLabels[lenSeries - 1]);
            }
            sb2.append("' color='");
            sb2.append(color);
            sb2.append("' alpha='");
            sb2.append(alpha);
            sb2.append("' >");
            for (int k = 0; k < categories; ++k) {
                sb2.append("<set value='");
                sb2.append(isDecline ? setValue - step : setValue + step);
                sb2.append("' />");
            }
            sb2.append("</dataset>");
        }
        sb.append("</categories>");
        sb.append((CharSequence)sb2);
        sb.append("</chart>");
        return sb.toString();
    }
}

