/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.defaultImpl;

import chrriis.dj.nativeswing.common.Utils;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.beans.AbstractFusionBean;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Categories;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Dataset;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.NodeFunc;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.chart.model.struct.Set;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FlashChartType;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.flashchart.FusionChartDataNode;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;

public abstract class DefaultScrollSeriesBean
extends AbstractFusionBean {
    public DefaultScrollSeriesBean() {
        this.isHyperLinkEnabled = false;
    }

    @Override
    protected void customAttributes(FusionChartDataNode dataNode) {
    }

    @Override
    protected void fillChartNodes(FusionChartDataNode dataNode) throws SyntaxErrorException {
        int i;
        super.applyNumberFormats();
        super.fillChartNodes(dataNode);
        boolean isSeriesByCol = dataNode.isSerialByCol();
        String[] group = dataNode.getGroupKeys();
        String[] series = (String[])dataNode.getSeriesKeys();
        double[][] data = (double[][])dataNode.getData();
        if (data == null || group == null || series == null) {
            return;
        }
        Sheet sheet = dataNode.getSheet();
        String formula = dataNode.getDataFormula();
        int cbLength = 0;
        CellBlockNode[] cb = null;
        if (!StringUtil.isEmptyString((String)formula)) {
            cb = SheetBaseMath.getArrayBlockNodes(sheet, formula, sheet.getBook().getDeps().isA1Style());
            cbLength = cb.length;
        }
        this.categories = new Categories();
        this.categories.categories = new Categories.Category[group.length];
        int len = group.length;
        for (i = 0; i < len; ++i) {
            this.categories.categories[i] = new Categories.Category(group[i]);
        }
        if (this.chartType != FlashChartType.FLASH_CT_SCROLL_ST_COLUMN2D) {
            this.datasets = new Dataset[series.length];
            String cellRef = null;
            int len1 = series.length;
            for (int i2 = 0; i2 < len1; ++i2) {
                this.datasets[i2] = new Dataset();
                this.datasets[i2].nodes = new NodeFunc[data[i2].length];
                this.datasets[i2].seriesName = series[i2];
                for (int j = 0; j < data[i2].length; ++j) {
                    Set s = new Set();
                    this.datasets[i2].nodes[j] = s;
                    if (this.isHyperLinkEnabled && this.hyperLinks != null && this.hyperLinks.length > 0) {
                        if (cbLength > 1 && null != cb) {
                            cellRef = isSeriesByCol ? cb[i2].getSheet().getCell(cb[i2].getRow() + j, cb[i2].getCol(), true).getName(false, false) : cb[j].getSheet().getCell(cb[j].getRow(), cb[j].getCol() + j, true).getName(false, false);
                        } else if (cbLength == 1 && null != cb) {
                            cellRef = isSeriesByCol ? cb[0].getSheet().getCell(cb[0].getRow() + j, cb[0].getCol() + i2, true).getName(false, false) : cb[0].getSheet().getCell(cb[0].getRow() + i2, cb[0].getCol() + j, true).getName(false, false);
                        }
                        this.datasets[i2].nodes[j].setCellRef(cellRef);
                    }
                    s.value = Double.isNaN(data[i2][j]) ? "" : (this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? this.magnify100(String.valueOf(data[i2][j])) : String.valueOf(data[i2][j]));
                    s.link = this.buildLinkProp(group[j], series[i2], String.valueOf(data[i2][j]));
                }
            }
        } else {
            this.datasets = new Dataset[data.length];
            int len1 = data.length;
            for (i = 0; i < len1; ++i) {
                this.datasets[i] = new Dataset();
                this.datasets[i].nodes = new NodeFunc[data[i].length];
                this.datasets[i].seriesName = series[i];
                for (int j = 0; j < data[i].length; ++j) {
                    Set s = new Set();
                    this.datasets[i].nodes[j] = s;
                    s.value = Double.isNaN(data[i][j]) ? "" : (this.chart.percent != null && Integer.parseInt(this.chart.percent) == 1 ? (Double.isNaN(data[i][j]) ? "" : this.magnify100(String.valueOf(data[i][j]))) : String.valueOf(data[i][j]));
                    s.link = this.buildLinkProp(group[j], series[i], String.valueOf(data[i][j]));
                }
            }
        }
        this.chart.setAttribute("showLegend", 1);
    }

    @Override
    protected void attachHyperLinkImpl(String[] hyperLinks) {
        int datasetSize = this.datasets.length;
        int index = hyperLinks[0].indexOf("[cell]");
        int index2 = index + 6;
        for (int i = 0; i < datasetSize; ++i) {
            int nodesSize = this.datasets[i].nodes.length;
            for (int j = 0; j < nodesSize; ++j) {
                if (this.datasets[i].nodes[j].getCellRef() == null) continue;
                ((Set)this.datasets[i].nodes[j]).link = Utils.encodeURL((String)(hyperLinks[0].substring(0, index) + "[" + this.datasets[i].nodes[j].getCellRef() + "]" + hyperLinks[0].substring(index2)));
            }
        }
    }

    @Override
    public String calcPlayerID(String cell, int bindingPolicy) {
        String ret = null;
        int series = this.datasets.length;
        switch (bindingPolicy) {
            case 2: {
                ret = cell;
                break;
            }
            case 0: {
                for (int i = 0; i < series; ++i) {
                    int n = this.datasets[i].nodes.length;
                    for (int j = 0; j < n; ++j) {
                        if (!cell.equals(this.datasets[i].nodes[j].getCellRef())) continue;
                        return "G" + j;
                    }
                }
                break;
            }
            case 1: {
                for (int i = 0; i < series; ++i) {
                    int n = this.datasets[i].nodes.length;
                    for (int j = 0; j < n; ++j) {
                        if (!cell.equals(this.datasets[i].nodes[j].getCellRef())) continue;
                        return "S" + i;
                    }
                }
                break;
            }
        }
        return ret;
    }
}

