/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.convenientkeys;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.convenientkeys.ConvenientKeysWizzard;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.convenientkeys.ExtConvenientKeysSync;
import com.kingdee.cosmic.ctrl.kdf.table.ICell;
import com.kingdee.cosmic.ctrl.kdf.table.IRow;
import com.kingdee.cosmic.ctrl.kdf.table.KDTable;
import com.kingdee.cosmic.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.KeyStroke;

public class ConvenientKeysUtil {
    static HashMap styleMap;
    static HashMap wizzardMap;
    static HashMap viewMap;
    static ExtConvenientKeysSync sync;
    static final int STYLE_MAP = 0;
    static final int WIZZARD_MAP = 1;
    static final int VIEW_MAP = 2;
    static ConvenientKeysWizzard wizzard;

    private static void initActionNameMap() {
        if (styleMap != null) {
            return;
        }
        styleMap = new HashMap();
        wizzardMap = new HashMap();
        viewMap = new HashMap();
        styleMap.put("Font_Bold", CtrlEXTMessages.getMLS("bold2", "\u7c97\u4f53"));
        styleMap.put("Font_Italic", CtrlEXTMessages.getMLS("italic2", "\u659c\u4f53"));
        styleMap.put("Font_UnderLine", CtrlEXTMessages.getMLS("KEY_UNDERLINE", "\u4e0b\u5212\u7ebf"));
        styleMap.put("Alignment_Center", CtrlEXTMessages.getMLS("KEY_ALIGNCENTER", "\u5c45\u4e2d"));
        styleMap.put("Alignment_Left", CtrlEXTMessages.getMLS("KEY_ALIGNLEFT", "\u5de6\u5bf9\u9f50"));
        styleMap.put("Alignment_Right", CtrlEXTMessages.getMLS("KEY_ALIGNRIGHT", "\u53f3\u5bf9\u9f50"));
        wizzardMap.put("Redo", CtrlEXTMessages.getMLS("KEY_UNDO", "\u64a4\u9500"));
        wizzardMap.put("Undo", CtrlEXTMessages.getMLS("redo2", "\u91cd\u505a"));
        wizzardMap.put("Sort_Ascending", CtrlEXTMessages.getMLS("KEY_AutoFilter_Asc", "\u5347\u5e8f\u6392\u5217"));
        wizzardMap.put("Sort_Descending", CtrlEXTMessages.getMLS("KEY_AutoFilter_Desc", "\u964d\u5e8f\u6392\u5217"));
        wizzardMap.put("Freeze", CtrlEXTMessages.getMLS("freeze2", "\u51bb\u7ed3"));
        wizzardMap.put("Unfreeze", CtrlEXTMessages.getMLS("cancelFreeze", "\u53d6\u6d88\u51bb\u7ed3"));
        wizzardMap.put("inner_CancelEditing", CtrlEXTMessages.getMLS("cancelEdit", "\u53d6\u6d88\u7f16\u8f91"));
        wizzardMap.put("inner_StopEditing", CtrlEXTMessages.getMLS("stopEdit", "\u505c\u6b62\u7f16\u8f91"));
        viewMap.put("JUMP_DOWN_DATA_CELL", CtrlEXTMessages.getMLS("focusDown", "\u7126\u70b9\u4e0b\u79fb"));
        viewMap.put("JUMP_UP_DATA_CELL", CtrlEXTMessages.getMLS("focusUp", "\u7126\u70b9\u4e0a\u79fb"));
        viewMap.put("JUMP_RIGHT_DATA_CELL", CtrlEXTMessages.getMLS("focusRight", "\u7126\u70b9\u53f3\u79fb"));
        viewMap.put("JUMP_LEFT_DATA_CELL", CtrlEXTMessages.getMLS("focusLeft", "\u7126\u70b9\u5de6\u79fb"));
        viewMap.put("JUMP_DOWN_CELL", CtrlEXTMessages.getMLS("moveDown", "\u4e0b\u79fb\u4e00\u683c"));
        viewMap.put("JUMP_UP_CELL", CtrlEXTMessages.getMLS("moveUp", "\u4e0a\u79fb\u4e00\u683c"));
        viewMap.put("JUMP_RIGHT_CELL", CtrlEXTMessages.getMLS("moveRight", "\u53f3\u79fb\u4e00\u683c"));
        viewMap.put("JUMP_LEFT_CELL", CtrlEXTMessages.getMLS("moveLeft", "\u5de6\u79fb\u4e00\u683c"));
        wizzardMap.put("JUMP_ACTIVE_CELL_DOWN", CtrlEXTMessages.getMLS("iterateDown", "\u5411\u4e0b\u8fed\u4ee3"));
        wizzardMap.put("JUMP_ACTIVE_CELL_UP", CtrlEXTMessages.getMLS("iterateUp", "\u5411\u4e0a\u8fed\u4ee3"));
        wizzardMap.put("JUMP_ACTIVE_CELL_RIGHT", CtrlEXTMessages.getMLS("iterateRight", "\u5411\u53f3\u8fed\u4ee3"));
        wizzardMap.put("JUMP_ACTIVE_CELL_LEFT", CtrlEXTMessages.getMLS("iterateLeft", "\u5411\u5de6\u8fed\u4ee3"));
        viewMap.put("SELECTION_EXTEND_RIGHT", CtrlEXTMessages.getMLS("extendRight", "\u5411\u53f3\u5ef6\u4f38"));
        viewMap.put("SELECTION_EXTEND_LEFT", CtrlEXTMessages.getMLS("extendLeft", "\u5411\u5de6\u5ef6\u4f38"));
        viewMap.put("SELECTION_EXTEND_UP", CtrlEXTMessages.getMLS("extendUp", "\u5411\u4e0a\u5ef6\u4f38"));
        viewMap.put("SELECTION_EXTEND_DOWN", CtrlEXTMessages.getMLS("extendDown", "\u5411\u4e0b\u5ef6\u4f38"));
        viewMap.put("SELECTION_EXTEND_RIGHT_DATA", CtrlEXTMessages.getMLS("extendToDataRight", "\u53f3\u5ef6\u5230\u6570\u636e"));
        viewMap.put("SELECTION_EXTEND_LEFT_DATA", CtrlEXTMessages.getMLS("extendToDataLeft", "\u5de6\u5ef6\u5230\u6570\u636e"));
        viewMap.put("SELECTION_EXTEND_UP_DATA", CtrlEXTMessages.getMLS("extendToDataUp", "\u4e0a\u5ef6\u5230\u6570\u636e"));
        viewMap.put("SELECTION_EXTEND_DOWN_DATA", CtrlEXTMessages.getMLS("extendToDataDown", "\u4e0b\u5ef6\u5230\u6570\u636e"));
        viewMap.put("CHANGE_TO_NEXT_SHEET", CtrlEXTMessages.getMLS("nextWorksheet", "\u4e0b\u4e00\u5de5\u4f5c\u8868"));
        viewMap.put("CHANGE_TO_LAST_SHEET", CtrlEXTMessages.getMLS("previousWorksheet", "\u4e0a\u4e00\u5de5\u4f5c\u8868"));
        viewMap.put("JUMP_NEXT_PAGE", CtrlEXTMessages.getMLS("pageDown", "\u5411\u4e0b\u7ffb\u9875"));
        viewMap.put("JUMP_LAST_PAGE", CtrlEXTMessages.getMLS("pageUp", "\u5411\u4e0a\u7ffb\u9875"));
        viewMap.put("SELECTION_EXTEND_NEXT_PAGE", CtrlEXTMessages.getMLS("extendPageDown", "\u5ef6\u4f38\u5411\u4e0b\u7ffb\u9875"));
        viewMap.put("SELECTION_EXTEND_LAST_PAGE", CtrlEXTMessages.getMLS("extendPageUp", "\u5ef6\u4f38\u5411\u4e0a\u7ffb\u9875"));
        viewMap.put("JUMP_UP_LEFT_CELL", CtrlEXTMessages.getMLS("jumpToTopLeft", "\u8df3\u8f6c\u5230\u5de6\u4e0a"));
        viewMap.put("JUMP_DOWN_RIGHT_CELL", CtrlEXTMessages.getMLS("jumpToBottomRight", "\u8df3\u8f6c\u5230\u53f3\u4e0b"));
        viewMap.put("JUMP_HOME_CELL", CtrlEXTMessages.getMLS("jumpToLeft", "\u8df3\u8f6c\u5230\u5de6"));
        viewMap.put("JUMP_END_CELL", CtrlEXTMessages.getMLS("jumpToRight", "\u8df3\u8f6c\u5230\u53f3"));
        viewMap.put("SELECTION_EXTEND_HOME_CELL", CtrlEXTMessages.getMLS("extendSelectBlockLeft", "\u5ef6\u4f38\u9009\u62e9\u5757:\u5de6"));
        viewMap.put("SELECTION_EXTEND_END_CELL", CtrlEXTMessages.getMLS("extendSelectBlockRight", "\u5ef6\u4f38\u9009\u62e9\u5feb:\u53f3"));
        viewMap.put("SELECTION_EXTEND_UPLEFT_CELL", CtrlEXTMessages.getMLS("extendSelectBlockTopLeft", "\u5ef6\u4f38\u9009\u62e9\u5757:\u5de6\u4e0a"));
        viewMap.put("SELECTION_EXTEND_DOWNRIGHT_CELL", CtrlEXTMessages.getMLS("extendSelectBlockBottomRight", "\u5ef6\u4f38\u9009\u62e9\u5757:\u53f3\u4e0b"));
    }

    public static void initTable(SpreadContext context, KDTable table, int index) {
        ConvenientKeysUtil.initTableKeyListener(table);
        InputMap inputMap = context.getSpread().getInputMap(1);
        InputMap inputMap2 = context.getSpread().getInputMap();
        KeyStroke[] strokes = inputMap.allKeys();
        KeyStroke[] strokes2 = inputMap2.allKeys();
        ActionMap actionMap = context.getSpread().getActionMap();
        ConvenientKeysUtil.initActionNameMap();
        HashMap map = index == 0 ? styleMap : (index == 1 ? wizzardMap : viewMap);
        Set entrySet = map.entrySet();
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            int i;
            IRow row = table.addRow();
            ICell cell = row.getCell(0);
            Map.Entry entry = iter.next();
            Object temp = entry.getKey();
            cell.setValue(entry.getValue());
            cell.setUserObject(temp);
            cell = row.getCell(1);
            ConvenientKeysWizzard.CellContent content = new ConvenientKeysWizzard.CellContent();
            String value = null;
            for (i = 0; i < strokes.length; ++i) {
                if (!temp.equals(inputMap.get(strokes[i]))) continue;
                value = strokes[i].toString();
                break;
            }
            if (value == null) {
                for (i = 0; i < strokes2.length; ++i) {
                    if (!temp.equals(inputMap2.get(strokes2[i]))) continue;
                    value = strokes[i].toString();
                    break;
                }
            }
            if (value != null && actionMap.get(temp) == null) {
                value = null;
            }
            if (value != null) {
                content.isCtrl = (value = value.toLowerCase(Locale.ENGLISH)).indexOf("ctrl") != -1;
                content.isAlt = value.indexOf("alt") != -1;
                content.isShift = value.indexOf("shift") != -1;
                content.key = value.substring(value.lastIndexOf(32), value.length());
            }
            cell.setValue((Object)ConvenientKeysUtil.getFormatString(content));
            cell.setUserObject((Object)content);
        }
    }

    public static String getFormatString(ConvenientKeysWizzard.CellContent content) {
        String txt = "";
        if (content.isShift) {
            txt = txt + "Shift + ";
        }
        if (content.isCtrl) {
            txt = txt + "Ctrl + ";
        }
        if (content.isAlt) {
            txt = txt + "Alt + ";
        }
        txt = txt + (content.key == null ? "" : content.key);
        return txt;
    }

    private static void initTableKeyListener(final KDTable table) {
        table.getListeners(KeyListener.class);
        table.addKeyListener((KeyListener)new KeyAdapter(){
            KDTable refer;
            {
                this.refer = table;
            }

            @Override
            public void keyReleased(KeyEvent e) {
                IRow row = KDTableUtil.getSelectedRow((KDTable)this.refer);
                if (row == null) {
                    return;
                }
                ICell cell = row.getCell(1);
                ConvenientKeysWizzard.CellContent content = (ConvenientKeysWizzard.CellContent)cell.getUserObject();
                if (e.getKeyCode() == 17) {
                    content.isCtrl = !content.isCtrl;
                } else if (e.getKeyCode() == 18) {
                    content.isAlt = !content.isAlt;
                } else if (e.getKeyCode() == 16) {
                    content.isShift = !content.isShift;
                } else {
                    String keyText = KeyEvent.getKeyText(e.getKeyCode());
                    if (ConvenientKeysUtil.checkContainedKey(keyText, ConvenientKeysUtil.wizzard.keyComboLetter, content, 0) || ConvenientKeysUtil.checkContainedKey(keyText, ConvenientKeysUtil.wizzard.keyComboControl, content, 1) || ConvenientKeysUtil.checkContainedKey(keyText, ConvenientKeysUtil.wizzard.keyComboArrow, content, 2) || !ConvenientKeysUtil.checkContainedKey(keyText, ConvenientKeysUtil.wizzard.keyComboNumber, content, 3)) {
                        // empty if block
                    }
                }
                ConvenientKeysUtil.updateTableAndItems(cell, content);
                System.out.println("keyReleased" + KeyEvent.getKeyText(e.getKeyCode()));
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    private static boolean checkContainedKey(String keyText, KDComboBox box, ConvenientKeysWizzard.CellContent content, int comboIndex) {
        int index = box.getItemCount();
        for (int i = 0; i < index; ++i) {
            if (!keyText.equals(box.getItemAt(i))) continue;
            content.index = comboIndex;
            content.key = keyText.equals(content.key) ? "" : keyText;
            return true;
        }
        return false;
    }

    private static void updateTableAndItems(ICell cell, ConvenientKeysWizzard.CellContent content) {
        if (wizzard == null) {
            return;
        }
        String format = ConvenientKeysUtil.getFormatString(content);
        cell.setValue((Object)format);
        ConvenientKeysUtil.wizzard.altCheckBox.setSelected(content.isAlt);
        ConvenientKeysUtil.wizzard.ctrlCheckBox.setSelected(content.isCtrl);
        ConvenientKeysUtil.wizzard.shiftCheckBox.setSelected(content.isShift);
        if (content.index == 0) {
            ConvenientKeysUtil.wizzard.keyComboLetter.setSelectedItem((Object)content.key);
        } else if (content.index == 1) {
            ConvenientKeysUtil.wizzard.keyComboControl.setSelectedItem((Object)content.key);
        } else if (content.index == 2) {
            ConvenientKeysUtil.wizzard.keyComboArrow.setSelectedItem((Object)content.key);
        } else {
            ConvenientKeysUtil.wizzard.keyComboNumber.setSelectedItem((Object)content.key);
        }
    }

    public static void syncTable(KDTable table) {
        if (sync == null) {
            sync = new ExtConvenientKeysSync(table);
        }
        sync.sync();
    }
}

