/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.exprdoc.chm;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.ui.formulawizard.Group;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.exprdoc.chm.HHC;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.exprdoc.chm.HTM;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.exprdoc.chm.XmlConstants;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.exprdoc.chm.exception.ExportCHMException;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class CHMFacade
extends XmlConstants {
    private static final Logger logger = LogUtil.getPackageLogger(CHMFacade.class);
    private static String SPECIAL_USAGE_HTM;
    private static DefaultKingdeeTreeNode nodes;

    public static void export2CHM(Group[] groups) throws ExportCHMException {
        try {
            CHMFacade.addConstantsGroup(groups[0]);
            new HHC().exportDirectory(groups);
        }
        catch (IOException ex) {
            throw new ExportCHMException(ExportCHMException.ErrorType.ErrorType_001, ex);
        }
        if (nodes != null) {
            groups[0].removeNodeFromParent(nodes);
        }
        nodes = null;
    }

    private static void addConstantsGroup(Group group) throws IOException, ExportCHMException {
        if (SPECIAL_USAGE_HTM == null) {
            return;
        }
        File file = new File(FilenameUtils.normalize((String)TEMP_ITEM_PATH));
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(FilenameUtils.normalize((String)TEMP_IMAGE_PATH))).exists()) {
            file.mkdirs();
        }
        file = new File(FilenameUtils.normalize((String)SPECIAL_USAGE_HTM));
        String[] childList = null;
        String parent = null;
        if (file.exists() && file.isDirectory()) {
            childList = file.list();
            parent = file.getPath() + File.separator;
        } else if (file.exists() && !file.renameTo(new File(FilenameUtils.normalize((String)(TEMP_ITEM_PATH + File.separator + file.getName()))))) {
            logger.warn((Object)(file.getName() + "\u6587\u4ef6\u91cd\u547d\u540d\u5931\u8d25"));
        }
        nodes = group.addNode(group.getRoot(), CtrlEXTMessages.getMLS("specialUsage", "\u7279\u6b8a\u7528\u6cd5"));
        if (childList != null) {
            for (int i = 0; i < childList.length; ++i) {
                if (childList[i].equals(IMAGES_WORD) || (file = new File(FilenameUtils.normalize((String)(parent + childList[i])))).isDirectory()) continue;
                CHMFacade.copyFile(file, new File(FilenameUtils.normalize((String)(TEMP_ITEM_PATH + File.separator + file.getName()))));
                group.addNode(nodes, file.getName().substring(0, file.getName().indexOf(HTM_FILE_SUFF)));
            }
        }
        if ((file = new File(FilenameUtils.normalize((String)SPECIAL_USAGE_HTM))).exists()) {
            if (file.getName().endsWith(HTM_FILE_SUFF)) {
                file = new File(FilenameUtils.normalize((String)(file.getParent() + IMAGES_DIR)));
            } else {
                if (!file.isDirectory()) {
                    throw new ExportCHMException(ExportCHMException.ErrorType.ErrorType_004, null);
                }
                file = new File(FilenameUtils.normalize((String)(file.getPath() + IMAGES_DIR)));
            }
            File[] images = file.listFiles();
            for (int i = 0; i < images.length; ++i) {
                CHMFacade.copyFile(images[i], new File(FilenameUtils.normalize((String)(TEMP_IMAGE_PATH + File.separator + images[i].getName()))));
            }
        }
    }

    private static void copyFile(File src, File dst) throws ExportCHMException {
        FileOutputStream out = null;
        FileInputStream in = null;
        try {
            try {
                if (dst.exists() && !dst.delete()) {
                    logger.warn((Object)(dst.getName() + "\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
                }
                out = new FileOutputStream(dst);
                in = new FileInputStream(src);
                byte[] buffer = new byte[1024];
                int len = 0;
                while ((len = in.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                    out.flush();
                }
            }
            catch (IOException ex) {
                throw new ExportCHMException(ExportCHMException.ErrorType.ErrorType_001, ex);
            }
            finally {
                if (out != null) {
                    out.close();
                }
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (IOException ex) {
            throw new ExportCHMException(ExportCHMException.ErrorType.ErrorType_001, ex);
        }
    }

    public static void setSpecialUsageHtm(String path) {
        SPECIAL_USAGE_HTM = path;
    }

    public static void setImageDir(String imageDir) {
        HTM.TEMP_ITEM_IMAGES_PATH = imageDir + File.separator;
    }
}

