/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.exprdoc.chm;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.ui.formulawizard.Formula;
import com.kingdee.cosmic.ctrl.common.ui.formulawizard.Group;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.exprdoc.chm.HHK;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.exprdoc.chm.HHP;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.exprdoc.chm.HTM;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.exprdoc.chm.XmlConstants;
import com.kingdee.cosmic.ctrl.swing.tree.DefaultKingdeeTreeNode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

class HHC
extends XmlConstants {
    private static final Logger logger = LogUtil.getPackageLogger(HHC.class);
    private ArrayList index;
    private ArrayList appendIndex;

    public synchronized void exportDirectory(Group[] groups) throws IOException {
        this.index = new ArrayList(8);
        for (int i = 0; i < groups.length; ++i) {
            this.parseElement(groups[i]);
        }
    }

    private void parseElement(Group group) throws IOException {
        DefaultKingdeeTreeNode root = group.getRoot();
        Item item = new Item();
        item.level = 1;
        item.title = CtrlEXTMessages.getMLS("functionReference", "\u51fd\u6570\u53c2\u8003");
        this.index.add(item);
        item.ref = this.parseGroup(root);
        this.createIndexHHK();
        this.createIndexHHC();
        this.createIndexHHP();
        this.index = null;
    }

    private String parseGroup(DefaultKingdeeTreeNode ele) throws IOException {
        int childCount = ele.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)ele.getChildAt(i);
            Item item = new Item();
            item.level = 2;
            item.title = child.getText();
            this.index.add(item);
            item.ref = this.parseNodes(child);
        }
        File file = new File(FilenameUtils.normalize((String)(TEMP_ITEM_PATH + File.separator + CtrlEXTMessages.getMLS("functionReference", "\u51fd\u6570\u53c2\u8003") + ".htm")));
        if (file.exists() && !file.delete()) {
            logger.warn((Object)(file.getName() + "\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
        }
        if (!file.createNewFile()) {
            logger.warn((Object)(file.getName() + "\u6587\u4ef6\u521b\u5efa\u5931\u8d25"));
        }
        new HTM(file, ele).parseGroupFile();
        return "items" + File.separator + file.getName();
    }

    private String parseNodes(DefaultKingdeeTreeNode ele) throws IOException {
        int childCount = ele.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultKingdeeTreeNode child = (DefaultKingdeeTreeNode)ele.getChildAt(i);
            Item item = new Item();
            item.level = 3;
            item.title = child.getText();
            item.ref = this.parseNode(child);
            this.index.add(item);
        }
        File file = new File(FilenameUtils.normalize((String)(TEMP_ITEM_PATH + File.separator + ele.getText() + ".htm")));
        if (file.exists() && !file.delete()) {
            logger.warn((Object)(file.getName() + "\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
        }
        if (!file.createNewFile()) {
            logger.warn((Object)(file.getName() + "\u6587\u4ef6\u521b\u5efa\u5931\u8d25"));
        }
        new HTM(file, ele).parseNodesFile();
        return "items" + File.separator + file.getName();
    }

    private String parseNode(DefaultKingdeeTreeNode node) throws IOException {
        File file = new File(FilenameUtils.normalize((String)(TEMP_ITEM_PATH + File.separator + node.getText() + ".htm")));
        Object uo = node.getUserObject();
        if (file.exists() && uo != null && ((Formula)uo).getExample() != null) {
            if (!file.delete()) {
                logger.warn((Object)(file.getName() + "\u6587\u4ef6\u5220\u9664\u5931\u8d25"));
            }
            if (!file.createNewFile()) {
                logger.warn((Object)(file.getName() + "\u6587\u4ef6\u521b\u5efa\u5931\u8d25"));
            }
        }
        new HTM(file, node).parseNodeFile();
        return "items" + File.separator + file.getName();
    }

    private void createIndexHHK() throws FileNotFoundException {
        new HHK(this.index).createHHKFile();
    }

    private void createIndexHHP() throws FileNotFoundException {
        new HHP(this.index).createIndexHHP();
    }

    private void printHtmlStart(PrintWriter pw) {
        pw.println(HTM_CONSTANTS_HEAD);
        pw.print(LEFT_BRACKET);
        pw.print(HTML);
        pw.println(RIGHT_BRACKET);
        pw.print(LEFT_BRACKET);
        pw.print(HEAD);
        pw.println(RIGHT_BRACKET);
        pw.print(LEFT_BRACKET);
        pw.print(META);
        pw.print(INDENT);
        pw.print(NAME);
        pw.print(EQUAL);
        pw.print(LEFT_QUOTE);
        pw.print(GENERATOR);
        pw.print(RIGHT_QUOTE);
        pw.print(INDENT);
        pw.print(CONTENT);
        pw.print(EQUAL);
        pw.print(LEFT_QUOTE);
        pw.print(VALUE_CONTENT);
        pw.print(RIGHT_QUOTE);
        pw.println(RIGHT_BRACKET);
        this.printEndTag(pw, HEAD);
        pw.print(LEFT_BRACKET);
        pw.print(BODY);
        pw.println(RIGHT_BRACKET);
        pw.print(LEFT_BRACKET);
        pw.print(OBJECT);
        pw.print(INDENT);
        pw.print(TYPE);
        pw.print(EQUAL);
        pw.print(LEFT_QUOTE);
        pw.print(HEAD_TYPE);
        pw.print(RIGHT_QUOTE);
        pw.println(RIGHT_BRACKET);
        this.printParam(pw, WINDOW_STYLE, COLOR1);
        this.printParam(pw, FONT, TAHOMA);
        this.printEndTag(pw, OBJECT);
        pw.print(LEFT_BRACKET);
        pw.print(UL);
        pw.println(RIGHT_BRACKET);
    }

    private String createIndexHHC() throws FileNotFoundException {
        File file = new File(FilenameUtils.normalize((String)HHC_FILE_NAME));
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter(new FileOutputStream(file)));){
            this.printHtmlStart(pw);
            boolean[] endLastTag = new boolean[]{false, false};
            block15: for (Item item : this.index) {
                switch (item.level) {
                    case 0: {
                        continue block15;
                    }
                    case 1: {
                        if (endLastTag[0]) {
                            this.printEndTag(pw, UL);
                        }
                        this.printLIObject(pw);
                        this.printParam(pw, NAME, item.title);
                        this.printParam(pw, LOCAL, item.ref);
                        this.printEndTag(pw, OBJECT);
                        pw.print(LEFT_BRACKET);
                        pw.print(UL);
                        pw.println(RIGHT_BRACKET);
                        endLastTag[0] = true;
                        continue block15;
                    }
                    case 2: {
                        if (endLastTag[1]) {
                            this.printEndTag(pw, UL);
                        }
                        this.printLIObject(pw);
                        this.printParam(pw, NAME, item.title);
                        this.printParam(pw, LOCAL, item.ref);
                        this.printEndTag(pw, OBJECT);
                        pw.print(LEFT_BRACKET);
                        pw.print(UL);
                        pw.println(RIGHT_BRACKET);
                        endLastTag[1] = true;
                        continue block15;
                    }
                    case 3: {
                        this.printLIObject(pw);
                        this.printParam(pw, NAME, item.title);
                        this.printParam(pw, LOCAL, item.ref);
                        this.printEndTag(pw, OBJECT);
                        continue block15;
                    }
                }
                throw new IllegalArgumentException("wrong state!");
            }
            if (endLastTag[1]) {
                this.printEndTag(pw, UL);
            }
            if (endLastTag[0]) {
                this.printEndTag(pw, UL);
            }
            this.printEndTag(pw, UL);
            this.printEndTag(pw, HTML);
            pw.flush();
        }
        return file.getPath();
    }

    private void printLIObject(PrintWriter pw) {
        pw.print(LEFT_BRACKET);
        pw.print(LI);
        pw.print(RIGHT_BRACKET);
        pw.print(LEFT_BRACKET);
        pw.print(OBJECT);
        pw.print(INDENT);
        pw.print(TYPE);
        pw.print(EQUAL);
        pw.print(LEFT_QUOTE);
        pw.print(BODY_TYPE);
        pw.print(RIGHT_QUOTE);
        pw.println(RIGHT_BRACKET);
    }

    private void printEndTag(PrintWriter pw, String endTag) {
        pw.print(LEFT_BRACKET);
        pw.print(TAG_END);
        pw.print(endTag);
        pw.println(RIGHT_BRACKET);
    }

    private void printParam(PrintWriter pw, String name, String value) {
        pw.print(LEFT_BRACKET);
        pw.print(PARAM);
        pw.print(INDENT);
        pw.print(NAME);
        pw.print(EQUAL);
        pw.print(LEFT_QUOTE);
        pw.print(name);
        pw.print(RIGHT_QUOTE);
        pw.print(INDENT);
        pw.print(VALUE);
        pw.print(EQUAL);
        pw.print(LEFT_QUOTE);
        pw.print(value);
        pw.print(RIGHT_QUOTE);
        pw.println(RIGHT_BRACKET);
    }

    public void appendDirectory(String fileName, HHC append) {
        this.appendIndex = append.appendIndex;
    }

    static class Item {
        String title;
        String ref;
        int level;

        Item() {
        }
    }
}

