/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.configpen;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.layout.table2.TableLayout2;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.bizmodel.AbstractParamBizModel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.configpen.DataTypeUI;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDLabelContainer;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDSpinner;
import com.kingdee.cosmic.ctrl.swing.KDTextArea;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class ParamUI
extends KDPanel {
    private KDTextField _txtName;
    private KDTextArea _txtDesc;
    private KDTextField _txtPrompt;
    private KDCheckBox _chkPrompt;
    private DataTypeUI _dataType;
    private KDComboBox _cmbClass;
    private KDPanel _panClassInner;
    private KDComboBox _cmbMatchArray;
    private KDCheckBox _chkOption;
    private INameChangedListener _nameChangeHandler;
    private boolean _isPrepareCtrlValue;

    public ParamUI(INameChangedListener l) {
        this._nameChangeHandler = l;
        this.init();
        this.installListener();
        this.setOpaque(false);
        this.setCustomInsets(new Insets(3, 8, 0, 8));
    }

    private void init() {
        this._txtName = new KDTextField();
        this._txtDesc = new KDTextArea();
        this._txtPrompt = new KDTextField();
        this._chkPrompt = new KDCheckBox(CtrlEXTMessages.getMLS("showInFunctionDescription", "\u51fd\u6570\u8bf4\u660e\u4e2d\u663e\u793a\u4e3a\u540d\u79f0 "));
        this._dataType = new DataTypeUI(CtrlEXTMessages.getMLS("dataType", "\u6570\u636e\u7c7b\u578b"));
        this._cmbClass = new KDComboBox();
        this.initClassItem();
        this._panClassInner = new KDPanel((LayoutManager)new BorderLayout());
        this._panClassInner.setCustomInsets(new Insets(3, 20, 0, 20));
        this._panClassInner.setOpaque(false);
        this._cmbMatchArray = new KDComboBox((Object[])new String[]{CtrlEXTMessages.getMLS("ignore", "\u5ffd\u7565"), "\u5fc5\u987b\u662f\u6570\u7ec4", "\u5fc5\u987b\u4e0d\u662f\u6570\u7ec4"});
        this._chkOption = new KDCheckBox(CtrlEXTMessages.getMLS("parameterOptional", "\u6b64\u53c2\u6570\u53ef\u7701\u7565"));
        KDLabelContainer lbcName = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtName, (String)CtrlEXTMessages.getMLS("KEY_NAME", "\u540d\u79f0"), (int)60);
        KDLabelContainer lbcPrompt = CtrlSwingUtilities.createLabelContainer((JComponent)this._txtPrompt, (String)CtrlEXTMessages.getMLS("functionDescriptionDisplay", "\u51fd\u6570\u8bf4\u660e\u4e2d\u663e\u793a\u4e3a"), (int)100);
        KDLabel labDesc = new KDLabel(CtrlEXTMessages.getMLS("descriptionWithColon", "\u63cf\u8ff0\uff1a"));
        labDesc.setVerticalAlignment(3);
        KDLabelContainer lbcClass = CtrlSwingUtilities.createLabelContainer((JComponent)this._cmbClass, (String)CtrlEXTMessages.getMLS("logicalParameterClass", "\u903b\u8f91\u53c2\u6570\u7c7b"), (int)80);
        KDLabelContainer lbcMatchArray = CtrlSwingUtilities.createLabelContainer((JComponent)this._cmbMatchArray, (String)CtrlEXTMessages.getMLS("matchingArray", "\u5339\u914d\u6570\u7ec4"), (int)60);
        TableLayout2 ly = new TableLayout2(8, 2);
        ly.setRatableWidth(0, 45);
        ly.setRatableWidth(1, 55);
        ly.setColsSpacing(TableLayout2.ALL, 20);
        ly.setFixedHeight(0, 20);
        ly.setFixedHeight(1, 20);
        ly.setFixedHeight(2, 5);
        ly.setFixedHeight(3, 40);
        ly.setFixedHeight(4, 70);
        ly.setFixedHeight(5, 20);
        ly.setRatableHeight(6, 100);
        ly.setFixedHeight(7, 20);
        this.setLayout((LayoutManager)ly);
        this.add((Component)lbcName, TableLayout2.param((int)0, (int)0));
        this.add((Component)lbcPrompt, TableLayout2.param((int)0, (int)1));
        this.add((Component)labDesc, TableLayout2.param((int)1, (int)0, (int)2, (int)0));
        this.add((Component)this._chkPrompt, TableLayout2.param((int)1, (int)1));
        this.add((Component)new KDScrollPane((Component)this._txtDesc), TableLayout2.param((int)3, (int)0, (int)3, (int)1));
        this.add((Component)((Object)this._dataType), TableLayout2.param((int)4, (int)0, (int)4, (int)1));
        this.add((Component)lbcClass, TableLayout2.param((int)5, (int)0));
        this.add((Component)lbcMatchArray, TableLayout2.param((int)5, (int)1));
        this.add((Component)this._panClassInner, TableLayout2.param((int)6, (int)0, (int)6, (int)1));
        this.add((Component)this._chkOption, TableLayout2.param((int)7, (int)0));
    }

    private void installListener() {
        this._cmbClass.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamUI.this.syncClassInner();
            }
        });
        this._chkPrompt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParamUI.this.syncPrompt();
            }
        });
        this._txtName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.syncListItem();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.syncListItem();
            }

            private void syncListItem() {
                if (ParamUI.this._isPrepareCtrlValue) {
                    return;
                }
                ParamUI.this._nameChangeHandler.nameChanged(ParamUI.this._txtName.getText());
            }
        });
    }

    private void syncClassInner() {
        Item item = (Item)this._cmbClass.getSelectedItem();
        this._panClassInner.removeAll();
        if (item.getUi() != null) {
            this._panClassInner.add((Component)((Object)item.getUi()), (Object)"Center");
        }
        this._panClassInner.validate();
        this._panClassInner.repaint();
    }

    private void syncPrompt() {
        this._txtPrompt.setEnabled(!this._chkPrompt.isSelected());
    }

    private void initClassItem() {
        Item item = new Item(CtrlEXTMessages.getMLS("any", "\u4efb\u610f"), "any");
        item.setUi(null);
        this._cmbClass.addItem((Object)item);
        item = new Item(CtrlEXTMessages.getMLS("specifiedIndex", "\u6307\u5b9a\u5e8f\u53f7"), "appoint");
        item.setUi(new ParamClassUI_Appoint());
        this._cmbClass.addItem((Object)item);
        item = new Item(CtrlEXTMessages.getMLS("multipleGroups", "\u591a\u7ec4\uff08\u4e2a\uff09\u91cd\u590d"), "atGroup");
        item.setUi(new ParamClassUI_AtGroup());
        this._cmbClass.addItem((Object)item);
        item = new Item(CtrlEXTMessages.getMLS("lastOdd", "\u6700\u540e\u4e00\u4e2a\uff08\u5947\u6570\u4e2a\uff09"), "oddLast");
        item.setUi(null);
        this._cmbClass.addItem((Object)item);
    }

    public void setModel(IXmlElement xml) {
        this._isPrepareCtrlValue = true;
        this._txtName.setText(xml.getAttribute("name"));
        this._txtDesc.setText(xml.getText().trim());
        String prompt = xml.getAttribute("prompt");
        this._txtPrompt.setText(prompt);
        this._chkPrompt.setSelected(StringUtil.isEmptyString((String)prompt));
        this.syncPrompt();
        String type = xml.getAttribute("type");
        this._dataType.setModel(AbstractParamBizModel.decodeDataType(type));
        AbstractParamClassUI classUi = null;
        for (int i = this._cmbClass.getItemCount() - 1; i >= 0; --i) {
            Item item = (Item)this._cmbClass.getItemAt(i);
            if (!StringUtil.equals((String)item.getValue(), (String)xml.getAttribute("class"))) continue;
            this._cmbClass.setSelectedIndex(i);
            this.syncClassInner();
            classUi = item.getUi();
            break;
        }
        if (classUi != null) {
            classUi.setModel(xml);
        }
        String matchArray = xml.getAttribute("matchArray");
        this._cmbMatchArray.setSelectedIndex(0);
        if (matchArray != null) {
            if ("true".equals(matchArray)) {
                this._cmbMatchArray.setSelectedIndex(1);
            } else if ("false".equals(matchArray)) {
                this._cmbMatchArray.setSelectedIndex(2);
            }
        }
        this._chkOption.setSelected("true".equals(xml.getAttribute("option")));
        this._isPrepareCtrlValue = false;
    }

    public IXmlElement getModel() {
        String dt;
        String name = this._txtName.getText();
        if (StringUtil.isEmptyString((String)name)) {
            return null;
        }
        IXmlElement xml = XmlUtil.createNode((String)"param");
        xml.setAttribute("name", name);
        xml.addCData(this._txtDesc.getText());
        if (!this._chkPrompt.isSelected()) {
            xml.setAttribute("prompt", this._txtPrompt.getText());
        }
        if (!StringUtil.isEmptyString((String)(dt = AbstractParamBizModel.encodeDataType(this._dataType.getModel())))) {
            xml.setAttribute("type", dt);
        }
        Item item = (Item)this._cmbClass.getSelectedItem();
        xml.setAttribute("class", item.getValue());
        AbstractParamClassUI classUi = item.getUi();
        if (classUi != null) {
            classUi.acceptEditing(xml);
        }
        switch (this._cmbMatchArray.getSelectedIndex()) {
            case 1: {
                xml.setAttribute("matchArray", "true");
                break;
            }
            case 2: {
                xml.setAttribute("matchArray", "false");
                break;
            }
        }
        if (this._chkOption.isSelected()) {
            xml.setAttribute("option", "true");
        }
        return xml;
    }

    private static class ParamClassUI_AtGroup
    extends AbstractParamClassUI {
        private KDSpinner _spnMoreThanIdx;
        private KDSpinner _spnCountAtGroup;
        private KDSpinner _spnIdxAtGroup;

        private ParamClassUI_AtGroup() {
        }

        @Override
        protected void init() {
            super.init();
            this._spnMoreThanIdx = new KDSpinner((SpinnerModel)new SpinnerNumberModel(-1, -1, 16, 1));
            KDLabelContainer lbcMoreThanIdx = CtrlSwingUtilities.createLabelContainer((JComponent)this._spnMoreThanIdx, (String)CtrlEXTMessages.getMLS("greaterThanIndex", "\u5927\u4e8e\u5e8f\u53f7"), (int)80);
            this._spnCountAtGroup = new KDSpinner((SpinnerModel)new SpinnerNumberModel(1, 1, 10, 1));
            KDLabelContainer lbcCountAtGroup = CtrlSwingUtilities.createLabelContainer((JComponent)this._spnCountAtGroup, (String)CtrlEXTMessages.getMLS("howManyInGroup", "\u51e0\u4e2a\u4e3a\u4e00\u7ec4"), (int)80);
            this._spnIdxAtGroup = new KDSpinner((SpinnerModel)new SpinnerNumberModel(0, 0, 9, 1));
            KDLabelContainer lbsIdxAtGroup = CtrlSwingUtilities.createLabelContainer((JComponent)this._spnIdxAtGroup, (String)CtrlEXTMessages.getMLS("inGroup", "\u4f4d\u4e8e\u7ec4\u4e2d"), (int)80);
            TableLayout2 ly = new TableLayout2(3, 3);
            ly.setColsSpacing(TableLayout2.ALL, 20);
            ly.setFixedWidth(0, 160);
            ly.setFixedWidth(1, 160);
            ly.setRatableWidth(2, 100);
            ly.setRowsSpacing(TableLayout2.ALL, 3);
            ly.setFixedHeight(0, 20);
            ly.setFixedHeight(1, 20);
            ly.setRatableHeight(2, 100);
            this.setLayout((LayoutManager)ly);
            this.add((Component)lbcMoreThanIdx, TableLayout2.param((int)0, (int)0));
            this.add((Component)lbcCountAtGroup, TableLayout2.param((int)1, (int)0));
            this.add((Component)lbsIdxAtGroup, TableLayout2.param((int)1, (int)1));
        }

        @Override
        public void setModel(IXmlElement xml) {
            this._spnMoreThanIdx.setValue((Object)Integer.valueOf(xml.getAttribute("moreThanIdx")));
            this._spnCountAtGroup.setValue((Object)Integer.valueOf(xml.getAttribute("countAtGroup")));
            this._spnIdxAtGroup.setValue((Object)Integer.valueOf(xml.getAttribute("idxAtGroup")));
        }

        @Override
        public void acceptEditing(IXmlElement xml) {
            xml.setAttribute("moreThanIdx", this._spnMoreThanIdx.getValue().toString());
            xml.setAttribute("countAtGroup", this._spnCountAtGroup.getValue().toString());
            xml.setAttribute("idxAtGroup", this._spnIdxAtGroup.getValue().toString());
        }
    }

    private static class ParamClassUI_Appoint
    extends AbstractParamClassUI {
        private KDSpinner _spnIdx;
        private KDSpinner _spnCount;

        private ParamClassUI_Appoint() {
        }

        @Override
        protected void init() {
            super.init();
            this._spnIdx = new KDSpinner((SpinnerModel)new SpinnerNumberModel(0, 0, 31, 1));
            KDLabelContainer lbcIdx = CtrlSwingUtilities.createLabelContainer((JComponent)this._spnIdx, (String)CtrlEXTMessages.getMLS("serialNumber", "\u5e8f\u53f7"), (int)60);
            this._spnCount = new KDSpinner((SpinnerModel)new SpinnerNumberModel(-1, -1, 32, 1));
            KDLabelContainer lbcCount = CtrlSwingUtilities.createLabelContainer((JComponent)this._spnCount, (String)CtrlEXTMessages.getMLS("totalCount", "\u603b\u6570"), (int)60);
            TableLayout2 ly = new TableLayout2(3, 2);
            ly.setFixedWidth(0, 120);
            ly.setRatableWidth(1, 100);
            ly.setColsSpacing(TableLayout2.ALL, 10);
            ly.setFixedHeight(0, 20);
            ly.setFixedHeight(1, 20);
            ly.setRatableHeight(2, 100);
            ly.setRowsSpacing(TableLayout2.ALL, 3);
            this.setLayout((LayoutManager)ly);
            this.add((Component)lbcIdx, TableLayout2.param((int)0, (int)0));
            this.add((Component)lbcCount, TableLayout2.param((int)1, (int)0));
            this.add((Component)new KDLabel(CtrlEXTMessages.getMLS("skipTotalCheck", "\uff08-1\u8868\u793a\u4e0d\u6821\u9a8c\u603b\u6570\uff09")), TableLayout2.param((int)1, (int)1));
        }

        @Override
        public void setModel(IXmlElement xml) {
            this._spnIdx.setValue((Object)Integer.valueOf(xml.getAttribute("idx")));
            String strCount = xml.getAttribute("count");
            if (strCount == null) {
                this._spnCount.setValue((Object)-1);
            } else {
                this._spnCount.setValue((Object)Integer.valueOf(strCount));
            }
        }

        @Override
        public void acceptEditing(IXmlElement xml) {
            xml.setAttribute("idx", this._spnIdx.getValue().toString());
            String strCount = this._spnCount.getValue().toString();
            if (Integer.parseInt(strCount) > 0) {
                xml.setAttribute("count", strCount);
            }
        }
    }

    private static abstract class AbstractParamClassUI
    extends KDPanel {
        public AbstractParamClassUI() {
            this.init();
        }

        protected void init() {
            this.setOpaque(false);
        }

        public abstract void setModel(IXmlElement var1);

        public abstract void acceptEditing(IXmlElement var1);
    }

    static interface INameChangedListener {
        public void nameChanged(String var1);
    }

    private static class Item {
        private String _text;
        private String _value;
        private AbstractParamClassUI _ui;

        public Item(String text, String value) {
            this._text = text;
            this._value = value;
        }

        public String getValue() {
            return this._value;
        }

        public void setUi(AbstractParamClassUI ui) {
            this._ui = ui;
        }

        public AbstractParamClassUI getUi() {
            return this._ui;
        }

        public String toString() {
            return this._text;
        }
    }
}

