/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.navigator;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.bizmodel.IParamBizModel;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.bizmodel.ParamsModelSet;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.expr.AnonymousFunc;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.expr.IFuncUnit;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.navigator.Breadcrumb;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.navigator.INavigatorListener;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.formula.senior.navigator.ParamsList;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class Navigator
implements INavigatorListener {
    private KDPanel _panAll;
    private Breadcrumb _breadcrumb;
    private ParamsList _paramsList;
    private IEditorDependency _listener;
    private IFuncUnit _lastFunc;
    private int _lastParamsCount = -256;
    private int _lastParamIdx = -256;

    public Navigator(IEditorDependency listener) {
        this._listener = listener;
        this.init();
    }

    private void init() {
        KDLabel labBreadcrumb = new KDLabel(CtrlEXTMessages.getMLS("cursorAtFunction", "\u5149\u6807\u6240\u5728\u51fd\u6570\uff1a"));
        labBreadcrumb.setToolTipText(null);
        this._breadcrumb = new Breadcrumb(this._listener);
        JComponent breadcrumbCtrl = this._breadcrumb.getCtrl();
        breadcrumbCtrl.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        KDLabel labParamsList = new KDLabel(CtrlEXTMessages.getMLS("parametersWithColon", "\u53c2\u6570\uff1a"));
        labParamsList.setToolTipText(null);
        this._paramsList = new ParamsList();
        KDScrollPane scp = new KDScrollPane((Component)this._paramsList.getCtrl());
        scp.setHorizontalScrollBarPolicy(31);
        scp.setBorder(BorderFactory.createLineBorder(Color.LIGHT_GRAY));
        KDPanel panTemp = new KDPanel((LayoutManager)new BorderLayout());
        panTemp.add((Component)labBreadcrumb, (Object)"North");
        panTemp.add((Component)breadcrumbCtrl, (Object)"Center");
        panTemp.add((Component)labParamsList, (Object)"South");
        this._panAll = new KDPanel((LayoutManager)new BorderLayout());
        this._panAll.add((Component)panTemp, (Object)"North");
        this._panAll.add((Component)scp, (Object)"Center");
    }

    public JComponent getCtrl() {
        return this._panAll;
    }

    @Override
    public void update(IFuncUnit func, int paramIdx) {
        if (this._lastFunc != func) {
            this._breadcrumb.preUpdate();
            if (func != null) {
                IFuncUnit f = func;
                while (f.getParent() != null) {
                    int caretGotoBefore = f.getNameStartPos();
                    int caretGotoAfter = f.getNameStartPos() + f.getNameLength();
                    if (f instanceof AnonymousFunc) {
                        caretGotoAfter = f.getLpPos() + 1;
                    }
                    this._breadcrumb.insertFunc(f.getDisplayName(), caretGotoBefore, caretGotoAfter);
                    f = f.getParent();
                }
            }
            this._breadcrumb.postUpdate();
            this._lastFunc = func;
            this._lastParamsCount = -256;
            this._lastParamIdx = -256;
            if (func == null) {
                this._paramsList.setParams(0);
                this._paramsList.postUpdate();
                this._listener.updateWizardExample(null);
            } else {
                IFuncUnit funcToShow = func;
                while (funcToShow instanceof AnonymousFunc) {
                    funcToShow = funcToShow.getParent();
                }
                this._listener.updateWizardExample(funcToShow.getFuncName());
            }
        }
        if (func == null) {
            return;
        }
        int paramsCount = func.getParamsCount();
        if (this._lastParamsCount != paramsCount) {
            int[][] validParamsPos = this._listener.getValidParamsPos(func);
            IParamBizModel[] mos = ParamsModelSet.getExtInstance().getBizModels(func, paramsCount);
            while (mos.length == 0 && func instanceof AnonymousFunc) {
                IFuncUnit parent = func.getParent();
                validParamsPos = this._listener.getValidParamsPos(parent);
                paramsCount = parent.getParamsCount();
                mos = ParamsModelSet.getExtInstance().getBizModels(parent, paramsCount);
                paramIdx = parent.getIndexOfParam(func);
                func = parent;
            }
            this._paramsList.setParams(mos.length);
            for (int i = 0; i < mos.length; ++i) {
                int[] ps = new int[]{-1, -1};
                if (i < validParamsPos.length) {
                    ps = validParamsPos[i];
                }
                this._paramsList.addParam(mos[i], i, new ParamsCaretLocateHandler(ps));
            }
            this._paramsList.setCurrentCount(paramsCount);
            this._paramsList.postUpdate();
            this._lastParamsCount = paramsCount;
            this._lastParamIdx = -256;
        }
        if (this._lastParamIdx != paramIdx) {
            this._paramsList.setCurrentIdx(paramIdx);
            this._paramsList.postUpdate();
            this._lastParamIdx = paramIdx;
        }
    }

    @Override
    public void reset() {
        this._lastFunc = null;
    }

    public IFuncUnit getCurrentFunc() {
        return this._lastFunc;
    }

    public static interface IEditorDependency {
        public void caretGoto(int var1);

        public void caretSelect(int var1, int var2);

        public int[][] getValidParamsPos(IFuncUnit var1);

        public void updateWizardExample(String var1);
    }

    private class ParamsCaretLocateHandler
    implements ActionListener {
        private int fromPos;
        private int toPos;

        public ParamsCaretLocateHandler(int[] pos) {
            this.fromPos = pos[0];
            this.toPos = pos[1];
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Navigator.this._listener.caretSelect(this.fromPos, this.toPos);
        }
    }
}

