/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.io;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExecutorUtil;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.swing.KDFileChooser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileFilter;
import org.apache.commons.io.FilenameUtils;

public class ExportSnapshotAction
extends AbstractAction {
    private Book _book;
    private SpreadContext _ctx;
    private KDFileChooser _chooser;

    public ExportSnapshotAction(Book book, SpreadContext context) {
        this._book = book;
        this._ctx = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        int mark;
        if (this._chooser == null) {
            this._chooser = this.getChooser();
        }
        if ((mark = this._chooser.showSaveDialog((Component)SwingUtilities.getWindowAncestor((Component)((Object)this._ctx)))) != 0) {
            return;
        }
        File file = this._chooser.getSelectedFile();
        try {
            String fileName = file.getAbsolutePath();
            fileName = fileName.endsWith(".snap") ? fileName : fileName + ".snap";
            FileOutputStream out = new FileOutputStream(FilenameUtils.normalize((String)fileName));
            try {
                byte[] data = ExecutorUtil.generateSnapShot(this._book);
                out.write(data);
            }
            catch (Exception e1) {
                MessageUtil.msgboxWarning((Component)((Object)this._ctx), "generateSnapShot" + CtrlEXTMessages.getMLS("executionFailed", "\u6267\u884c\u5931\u8d25\uff01"));
            }
            finally {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (FileNotFoundException e1) {
            MessageUtil.msgboxWarning((Component)((Object)this._ctx), CtrlEXTMessages.getMLS("fileNotFound2", "\u627e\u4e0d\u5230\u6587\u4ef6\uff01"));
        }
    }

    protected KDFileChooser getChooser() {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.putClientProperty(KDFileChooser.NO_PATH_MESS_ON_JVM6, KDFileChooser.NO_PATH_MESS_ON_JVM6);
        fileChooser.setCurrentDirectory(new File("C:" + File.separator + "kd" + File.separator + "kds"));
        fileChooser.setFileSelectionMode(2);
        fileChooser.addChoosableFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName();
                return f.isDirectory() || name.endsWith(".snap");
            }

            @Override
            public String getDescription() {
                return CtrlEXTMessages.getMLS("snapshotFile", "\u5feb\u7167\u6587\u4ef6\uff08*.snap\uff09");
            }
        });
        return fileChooser;
    }
}

