/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.io;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.fulfil.ExtGuiExecutor;
import com.kingdee.cosmic.ctrl.ext.immit.IExtRuntimeDataProvider;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.io.BookIOUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.Book;
import com.kingdee.cosmic.ctrl.swing.KDFileChooser;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.AbstractAction;
import javax.swing.filechooser.FileFilter;

public class OpenSnapshotAction
extends AbstractAction {
    private KDFileChooser _chooser;
    private SpreadContext _ctx;
    private IExtRuntimeDataProvider _dataProvider;

    public OpenSnapshotAction(SpreadContext ctx, IExtRuntimeDataProvider dataProvider) {
        this._ctx = ctx;
        this._dataProvider = dataProvider;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int mark;
        if (this._chooser == null) {
            this._chooser = this.getChooser();
        }
        if ((mark = this._chooser.showOpenDialog((Component)((Object)this._ctx))) != 0) {
            return;
        }
        File file = this._chooser.getSelectedFile();
        if (!file.exists()) {
            MessageUtil.msgboxWarning((Component)((Object)this._ctx), CtrlEXTMessages.getMLS("importFileNotExist", "\u5bfc\u5165\u6587\u4ef6\u4e0d\u5b58\u5728\uff01"));
            return;
        }
        this.openFile(file);
    }

    public void openFile(File file) {
        try (FileInputStream in = new FileInputStream(file);){
            byte[] data = new byte[(int)file.length()];
            ((InputStream)in).read(data);
            try {
                Book book = BookIOUtil.unpack(data);
                new ExtGuiExecutor(book, (IExtRuntimeDataProvider)this._dataProvider.clone(this._dataProvider.fetchCurrentReportProperties()), false).executeWithinWindow();
            }
            catch (Exception e) {
                MessageUtil.msgboxWarning((Component)((Object)this._ctx), CtrlEXTMessages.getMLS("unzipFileError", "\u89e3\u538b\u6587\u4ef6\u9519\u8bef\uff01"));
            }
        }
        catch (FileNotFoundException e1) {
            MessageUtil.msgboxWarning((Component)((Object)this._ctx), CtrlEXTMessages.getMLS("fileNotFound2", "\u627e\u4e0d\u5230\u6587\u4ef6\uff01"));
        }
        catch (IOException exception) {
            MessageUtil.msgboxWarning((Component)((Object)this._ctx), CtrlEXTMessages.getMLS("readSnapshotFileFailed", "\u8bfb\u5feb\u7167\u6587\u4ef6\u5931\u8d25\uff01"));
        }
    }

    protected KDFileChooser getChooser() {
        KDFileChooser fileChooser = new KDFileChooser();
        fileChooser.putClientProperty(KDFileChooser.NO_PATH_MESS_ON_JVM6, KDFileChooser.NO_PATH_MESS_ON_JVM6);
        fileChooser.setCurrentDirectory(new File("C:" + File.separator + "kd" + File.separator + "kds"));
        fileChooser.setFileSelectionMode(2);
        FileFilter kdsFilter = new FileFilter(){

            @Override
            public boolean accept(File f) {
                String name = f.getName();
                return f.isDirectory() || name.endsWith(".snap");
            }

            @Override
            public String getDescription() {
                return CtrlEXTMessages.getMLS("snapshotFile", "\u5feb\u7167\u6587\u4ef6\uff08*.snap\uff09");
            }
        };
        fileChooser.addChoosableFileFilter(kdsFilter);
        return fileChooser;
    }
}

