/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.pic;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.pic.ImageFilter;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.pic.ImagePreview;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.pic.ImageUtils;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.kds.impl.SpreadContext;
import com.kingdee.cosmic.ctrl.kds.impl.facade.wizzard.ISpreadWizzard;
import com.kingdee.cosmic.ctrl.kds.model.struct.CellBlock;
import com.kingdee.cosmic.ctrl.kds.model.struct.Range;
import com.kingdee.cosmic.ctrl.kds.model.struct.Sheet;
import com.kingdee.cosmic.ctrl.kds.model.struct.SheetBaseMath;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.EmbedhLayer;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.EmbedImage;
import com.kingdee.cosmic.ctrl.kds.model.struct.embed.image.StaticURLImageModel;
import com.kingdee.cosmic.ctrl.swing.KDFileChooser;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class InsertPicWizzard
implements ISpreadWizzard {
    private KDExt _ext;
    private KDFileChooser fileChooser;
    private SpreadContext _context;
    private static final long PIC_MAX_SIZE = 0x200000L;

    public InsertPicWizzard(KDExt ext) {
        this._ext = ext;
        this.initComponents();
    }

    private void initComponents() {
        this.fileChooser = new KDFileChooser();
        this.fileChooser.setApproveButtonText(CtrlEXTMessages.getMLS("KEY_INSERT", "\u63d2\u5165"));
        ImageFilter picFilter = new ImageFilter();
        this.fileChooser.addChoosableFileFilter((FileFilter)picFilter);
        this.fileChooser.setFileFilter((FileFilter)picFilter);
        this.fileChooser.setAccessory((JComponent)new ImagePreview((JFileChooser)this.fileChooser));
    }

    @Override
    public void commit() {
    }

    @Override
    public boolean isModal() {
        return true;
    }

    @Override
    public boolean prepare() {
        return true;
    }

    @Override
    public void show() {
        URL url;
        int mark = this.fileChooser.showOpenDialog((Component)((Object)this._ext));
        if (mark != 0) {
            return;
        }
        try {
            url = this.selectedURL();
        }
        catch (MalformedURLException e) {
            MessageUtil.msgboxWarning((Component)this.fileChooser, CtrlEXTMessages.getMLS("filePathException", "\u6587\u4ef6\u8def\u5f84\u5f02\u5e38\uff1a") + e);
            return;
        }
        if (!ImageUtils.checkURL(url, 0x200000L)) {
            MessageUtil.msgboxWarning((Component)this.fileChooser, CtrlEXTMessages.getMLS("importFileError", "\u5bfc\u5165\u6b64\u6587\u4ef6\u65f6\u51fa\u9519\u3002") + url);
            return;
        }
        Sheet sheet = this._context.getBook().getActiveSheet();
        Range range = sheet.getSelectionRange();
        CellBlock block = range.getBounds();
        int x = SheetBaseMath.getColX(sheet, block.getCol());
        int y = SheetBaseMath.getRowY(sheet, block.getRow());
        EmbedImage embedImage = new EmbedImage(sheet, new StaticURLImageModel(url));
        embedImage.setBounds(x, y, Integer.MAX_VALUE, Integer.MAX_VALUE);
        EmbedhLayer layer = sheet.getEmbedments(true);
        layer.addEmbed(embedImage);
        layer.selectEmbed(embedImage, 2);
    }

    public URL selectedURL() throws MalformedURLException {
        File selectedFile = this.fileChooser.getSelectedFile();
        String path = selectedFile.getAbsolutePath();
        try {
            selectedFile.getCanonicalPath();
        }
        catch (IOException e) {
            int schemaBegin = path.indexOf("http:");
            String protocal = "http";
            if (schemaBegin < 0) {
                return null;
            }
            path = path.substring(schemaBegin + 6);
            path = path.replace('\\', '/');
            path = protocal + "://" + path;
            return new URL(path);
        }
        return new URL("file:\\\\\\" + path);
    }

    public void setContext(SpreadContext context) {
        this._context = context;
    }

    public KDFileChooser getFileChooser() {
        return this.fileChooser;
    }
}

