/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.propelling.kpi;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.propelling.kpi.KPIDefine;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

public class ExtKPIModel {
    private ArrayList<KPIDefine> defines;

    public ExtKPIModel() {
    }

    public ExtKPIModel(ArrayList<KPIDefine> defines) {
        this.defines = defines;
    }

    public ExtKPIModel fromXml(String xmlContent) {
        IXmlElement root;
        this.defines = new ArrayList();
        try {
            root = XmlUtil.loadRootElement((InputStream)new ByteArrayInputStream(xmlContent.getBytes("UTF-8")));
        }
        catch (Throwable e) {
            return this;
        }
        List children = root.getChildren();
        for (Object obj : children) {
            if (!(obj instanceof IXmlElement)) continue;
            IXmlElement param = (IXmlElement)obj;
            this.defines.add(new KPIDefine(param.getAttribute("name"), param.getAttribute("value"), param.getAttribute("format")));
        }
        return this;
    }

    public String toXml() {
        IXmlElement root = XmlUtil.createNode((String)"root");
        if (this.defines != null) {
            for (KPIDefine define : this.defines) {
                IXmlElement element = XmlUtil.createNode((String)"define");
                element.setAttribute("name", define.kpiName());
                element.setAttribute("value", define.kpiValue());
                String numberFormat = define.numberFormat();
                if (numberFormat != null) {
                    element.setAttribute("format", numberFormat);
                }
                root.addChild(element);
            }
        }
        return XmlUtil.toString((IXmlElement)root);
    }

    public KPIDefine[] defines() {
        return this.defines.toArray(new KPIDefine[0]);
    }
}

