/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.report;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.ext.IExtWizardManager;
import com.kingdee.cosmic.ctrl.ext.KDExt;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.data.DatasetImporter;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.data.DatasetImporterWizard;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.GroupReportComposer;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.IWizardStep;
import com.kingdee.cosmic.ctrl.ext.ui.wizards.report.ReportComposerWizard;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kds.expans.model.data.ExtDataSet;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDSeparator;
import com.kingdee.cosmic.ctrl.swing.KDWorkButton;
import java.awt.Component;
import java.awt.Container;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jdesktop.layout.GroupLayout;

public class GroupReportColumnFilter
extends KDPanel
implements IWizardStep {
    public static final String KEY_MSG1 = "wizardTips";
    public static final String KEY_MSG_TITLE = "msgTitle";
    public static final String KEY_LABEL_CREATE = "createGroupReport";
    public static final String KEY_LABEL_AVAILABLE_FIELDS = "availableFields";
    public static final String KEY_LABEL_CREATE_COL = "createCol";
    private KDWorkButton up;
    private KDWorkButton down;
    private KDLabel jLabel1;
    private KDLabel jLabel2;
    private KDLabel jLabel3;
    private KDList leftList;
    private KDList rightList;
    private KDScrollPane jScrollPane1;
    private KDScrollPane jScrollPane2;
    private KDSeparator jSeparator1;
    private KDWorkButton add;
    private KDWorkButton addAll;
    private KDWorkButton remove;
    private KDWorkButton removeAll;
    private KDExt _ext;
    private GroupReportComposer next;
    private DatasetImporter prev;

    public static String getLocalText(String key, String defaultStr) {
        return CtrlEXTMessages.getMLS(key, defaultStr);
    }

    public GroupReportColumnFilter(KDExt ext) {
        this._ext = ext;
        this.initComponents();
        this.initListeners();
    }

    @Override
    public boolean prepare() {
        this.leftList.removeAllElements();
        DatasetImporter importer = (DatasetImporter)this.getPrevStep();
        List list = importer.getAllExtDataSets();
        List selected = importer.getSelectedExtDataSets();
        if (list.size() == 0) {
            this.rightList.removeAllElements();
            return true;
        }
        if (selected.size() > 1) {
            this.showMessage(GroupReportColumnFilter.getLocalText(KEY_MSG1, "\u62a5\u8868\u5411\u5bfc\u53ea\u652f\u6301\u5355\u6570\u636e\u96c6\uff0c\u5411\u5bfc\u5c06\u4f7f\u7528\u6240\u9009\u7684\u7b2c\u4e00\u4e2a\u6570\u636e\u96c6\u5b8c\u6210\u540e\u7eed\u6b65\u9aa4\u3002"));
        }
        ExtDataSet ds = (ExtDataSet)selected.get(0);
        String[] sawtooth = importer.getEditingInfo(ds);
        Object[] cols = MiscUtil.sortColumnsByIndex(ds.getColumns());
        for (int j = 0; j < cols.length; ++j) {
            String colEditingAlias = sawtooth[j + 1];
            this.leftList.addElement((Object)new GroupReportComposer.BinaryElement(colEditingAlias, colEditingAlias));
        }
        for (int i = this.rightList.getElementCount() - 1; i >= 0; --i) {
            Object o = this.rightList.getElement(i);
            if (this.leftList.getIndexOfElement(o) != -1) continue;
            this.rightList.removeElement(o);
        }
        this.leftList.setSelectedIndex(0);
        return true;
    }

    @Override
    public IWizardStep getNextStep() {
        if (this.next == null) {
            this.next = (GroupReportComposer)((ReportComposerWizard)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_ReportComposer)).getGroupReportComposer();
        }
        return this.next;
    }

    @Override
    public IWizardStep getPrevStep() {
        if (this.prev == null) {
            this.prev = ((DatasetImporterWizard)this._ext.getExtWizardManager().getWizard(IExtWizardManager.Wizard_DatasetImporter)).getDatasetImporter();
        }
        return this.prev;
    }

    public List getListFields() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (int i = 0; i < this.rightList.getElementCount(); ++i) {
            result.add(this.rightList.getElement(i));
        }
        return result;
    }

    private void showMessage(String message) {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().clearGlobalFocusOwner();
        MessageUtil.msgboxInfo((Component)((Object)this), message);
    }

    private void initListeners() {
        this.leftList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    GroupReportColumnFilter.this.addSelectedElement2Right();
                }
            }
        });
        this.rightList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && e.getButton() == 1) {
                    GroupReportColumnFilter.this.removeSelectedElementFromRight();
                }
            }
        });
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupReportColumnFilter.this.addSelectedElement2Right();
            }
        });
        this.addAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupReportColumnFilter.this.addAllElement2Right();
            }
        });
        this.remove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupReportColumnFilter.this.removeSelectedElementFromRight();
            }
        });
        this.removeAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GroupReportColumnFilter.this.removeAllElementFromRight();
            }
        });
        this.up.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = GroupReportColumnFilter.this.rightList.getSelectedIndex();
                if (index != -1 && index != 0) {
                    Object selected = GroupReportColumnFilter.this.rightList.getSelectedValue();
                    GroupReportColumnFilter.this.rightList.removeElement(selected);
                    int newindex = index - 1;
                    GroupReportColumnFilter.this.rightList.insertElement(selected, newindex);
                    GroupReportColumnFilter.this.rightList.setSelectedIndex(newindex);
                }
            }
        });
        this.down.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = GroupReportColumnFilter.this.rightList.getSelectedIndex();
                if (index != -1 && index != GroupReportColumnFilter.this.rightList.getElementCount() - 1) {
                    Object selected = GroupReportColumnFilter.this.rightList.getSelectedValue();
                    GroupReportColumnFilter.this.rightList.removeElement(selected);
                    int newindex = index + 1;
                    GroupReportColumnFilter.this.rightList.insertElement(selected, newindex);
                    GroupReportColumnFilter.this.rightList.setSelectedIndex(newindex);
                }
            }
        });
    }

    private void addSelectedElement2Right() {
        Object[] list = this.leftList.getSelectedValues();
        int size = list.length;
        if (size == 0) {
            return;
        }
        for (int i = 0; i < size; ++i) {
            Object ele = list[i];
            if (ele == null || this.rightList.getIndexOfElement(ele) != -1) continue;
            this.rightList.addElement(ele);
        }
        this.rightList.setSelectedValue(list[0], true);
        if (size == 1) {
            int nextIndex = this.leftList.getIndexOfElement(list[0]) + 1;
            if (nextIndex < 0) {
                nextIndex = 0;
            } else if (nextIndex >= this.leftList.getElementCount()) {
                nextIndex = this.leftList.getElementCount() - 1;
            }
            this.leftList.setSelectedIndex(nextIndex);
        }
    }

    private void addAllElement2Right() {
        this.rightList.removeAllElements();
        for (int i = 0; i < this.leftList.getElementCount(); ++i) {
            this.rightList.addElement(this.leftList.getElement(i));
        }
        this.rightList.setSelectedIndex(0);
        this.rightList.requestFocusInWindow();
    }

    private void removeSelectedElementFromRight() {
        int[] indices = this.rightList.getSelectedIndices();
        int size = indices.length;
        if (size == 0) {
            return;
        }
        for (int i = size - 1; i >= 0; --i) {
            this.rightList.removeElementAt(indices[i]);
        }
        this.rightList.setSelectedIndex(indices[0]);
    }

    private void removeAllElementFromRight() {
        this.rightList.removeAllElements();
    }

    private void initComponents() {
        this.add = new KDWorkButton();
        this.addAll = new KDWorkButton();
        this.remove = new KDWorkButton();
        this.removeAll = new KDWorkButton();
        this.add.setFocusable(false);
        this.addAll.setFocusable(false);
        this.remove.setFocusable(false);
        this.removeAll.setFocusable(false);
        this.add.setIcon((Icon)ResourceManager.getImageIcon("tbtn_move_right.gif"));
        this.addAll.setIcon((Icon)ResourceManager.getImageIcon("tbtn_moveall_right.gif"));
        this.remove.setIcon((Icon)ResourceManager.getImageIcon("tbtn_move_left.gif"));
        this.removeAll.setIcon((Icon)ResourceManager.getImageIcon("tbtn_moveall_left.gif"));
        this.jLabel1 = new KDLabel();
        this.jSeparator1 = new KDSeparator();
        this.jLabel2 = new KDLabel();
        this.jScrollPane1 = new KDScrollPane();
        this.leftList = new KDList();
        this.jScrollPane2 = new KDScrollPane();
        this.rightList = new KDList();
        this.jLabel3 = new KDLabel();
        this.up = new KDWorkButton();
        this.down = new KDWorkButton();
        this.up.setFocusable(false);
        this.down.setFocusable(false);
        this.up.setIcon((Icon)ResourceManager.getImageIcon("tbtn_moveup.gif"));
        this.down.setIcon((Icon)ResourceManager.getImageIcon("tbtn_movedown.gif"));
        this.jLabel1.setText(GroupReportColumnFilter.getLocalText(KEY_LABEL_CREATE, "\u5efa\u7acb\u5206\u7ec4\u6c47\u603b\u62a5\u8868 - \uff081\uff09\u9009\u62e9\u660e\u7ec6\u884c\u7684\u5217"));
        this.jLabel2.setText(GroupReportColumnFilter.getLocalText(KEY_LABEL_AVAILABLE_FIELDS, "\u53ef\u9009\u5b57\u6bb5"));
        this.jScrollPane1.setViewportView((Component)this.leftList);
        this.jScrollPane2.setViewportView((Component)this.rightList);
        this.jLabel3.setText(GroupReportColumnFilter.getLocalText(KEY_LABEL_CREATE_COL, "\u521b\u5efa\u5217"));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator1, -1, 779, Short.MAX_VALUE).add((Component)this.jLabel1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -2, 319, -2).add(46, 46, 46).add((GroupLayout.Group)layout.createParallelGroup(2).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.addAll, -1, -1, Short.MAX_VALUE).add((Component)this.add)).add((GroupLayout.Group)layout.createParallelGroup(2, false).add((Component)this.removeAll, -1, -1, Short.MAX_VALUE).add((Component)this.remove)))).add((Component)this.jLabel2, -2, 140, -2)).addPreferredGap(0, 47, Short.MAX_VALUE).add((GroupLayout.Group)layout.createParallelGroup(1, false).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel3).addPreferredGap(0, -1, Short.MAX_VALUE).add((Component)this.up, -2, 21, -2).addPreferredGap(0).add((Component)this.down, -2, 21, -2)).add(2, (Component)this.jScrollPane2, -2, 328, -2)))).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1, -2, 15, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add(151, 151, 151).add((Component)this.add).addPreferredGap(0).add((Component)this.addAll).add(121, 121, 121).add((Component)this.remove, -2, 23, -2).addPreferredGap(0).add((Component)this.removeAll)).add((GroupLayout.Group)layout.createSequentialGroup().add(6, 6, 6).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 576, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.up, -2, 21, -2).add((Component)this.down, -2, 21, -2).add((Component)this.jLabel3)).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 570, Short.MAX_VALUE))).addContainerGap()));
    }

    @Override
    public boolean checkValid() {
        return true;
    }
}

