/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.ui.wizards.showcase;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.immit.SavedSpan;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfig;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfigCollection;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseType;
import com.kingdee.cosmic.ctrl.ext.ui.icons.ResourceManager;
import com.kingdee.cosmic.ctrl.ext.util.MessageUtil;
import com.kingdee.cosmic.ctrl.swing.KDButton;
import com.kingdee.cosmic.ctrl.swing.KDButtonGroup;
import com.kingdee.cosmic.ctrl.swing.KDCheckBox;
import com.kingdee.cosmic.ctrl.swing.KDComboBox;
import com.kingdee.cosmic.ctrl.swing.KDDialog;
import com.kingdee.cosmic.ctrl.swing.KDFrame;
import com.kingdee.cosmic.ctrl.swing.KDLabel;
import com.kingdee.cosmic.ctrl.swing.KDList;
import com.kingdee.cosmic.ctrl.swing.KDPanel;
import com.kingdee.cosmic.ctrl.swing.KDRadioButton;
import com.kingdee.cosmic.ctrl.swing.KDScrollPane;
import com.kingdee.cosmic.ctrl.swing.KDTextField;
import com.kingdee.cosmic.ctrl.swing.KDToolBar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JToolBar;
import javax.swing.border.Border;

public class ShowcaseChooser
extends KDDialog {
    private AbstractAction newAction;
    private AbstractAction saveAction;
    private AbstractAction renameSaveAction;
    private AbstractAction deleteAction;
    private AbstractAction changeAction;
    private KDComboBox combo;
    private KDCheckBox box;
    private KDButton confirm;
    private KDButton cancle;
    private int returnValue = -1;
    private KDToolBar bar;
    private KDPanel controlPanel;
    private ShowcaseConfig current;
    private ShowcaseConfig last;
    private KDList showcaseList;
    private KDScrollPane scrollPane;
    private ShowcaseType level;
    private Hashtable table;
    private ShowcaseType[] cases;
    private KDDialog nameGet = new KDDialog((Dialog)((Object)this));
    private KDTextField nameBox = new KDTextField();
    private KDLabel nameLabel = new KDLabel(CtrlEXTMessages.getMLS("schemeName", "\u65b9\u6848\u540d\u79f0:"));
    private ShowcaseConfigCollection collection;
    private KDPanel constraintsPanel;
    private KDCheckBox editable;
    private KDCheckBox showFormula;
    private KDCheckBox rowCount;
    private KDCheckBox columnCount;
    private KDCheckBox hideEditable;
    private KDButtonGroup group;
    private KDRadioButton cellSelect;
    private KDRadioButton rowSelect;
    private SavedSpan[] rowSpan;
    private SavedSpan[] colSpan;

    public ShowcaseChooser(KDFrame parent, ShowcaseConfigCollection collection, ShowcaseType[] types, SavedSpan[] rowSpan, SavedSpan[] colSpan) {
        super((Frame)parent);
        if (collection != null) {
            this.current = collection.getDefaultConfig();
        }
        this.collection = collection;
        this.cases = types;
        this.rowSpan = rowSpan;
        this.colSpan = colSpan;
        if (this.cases != null) {
            this.level = this.cases[0];
        }
        this.initComponents();
        this.initComponents2();
        this.initNameGetDialog();
        this.initListeners();
        this.setSize(400, 400);
        this.setResizable(false);
        this.setDefaultCloseOperation(0);
        this.setModal(true);
        this.setLocationRelativeTo(null);
        this.setTitle(CtrlEXTMessages.getMLS("reportDisplayScheme", "\u62a5\u8868\u663e\u793a\u65b9\u6848"));
    }

    private void initComponents2() {
        this.editable = new KDCheckBox(CtrlEXTMessages.getMLS("editableResults", "\u7ed3\u679c\u53ef\u7f16\u8f91"));
        this.showFormula = new KDCheckBox(CtrlEXTMessages.getMLS("showFormula", "\u663e\u793a\u516c\u5f0f"));
        this.hideEditable = new KDCheckBox(CtrlEXTMessages.getMLS("draggableHiddenRowsAndColumns", "\u9690\u85cf\u7684\u884c,\u5217\u53ef\u62d6\u52a8"));
        this.rowCount = new KDCheckBox(CtrlEXTMessages.getMLS("hideRowNumbers", "\u4e0d\u663e\u793a\u884c\u53f7"));
        this.rowCount.setBounds(10, 40, 100, 20);
        this.columnCount = new KDCheckBox(CtrlEXTMessages.getMLS("hideColumnLabels", "\u4e0d\u663e\u793a\u5217\u6807"));
        this.columnCount.setBounds(10, 100, 100, 20);
        KDPanel panel = new KDPanel();
        panel.setBounds(8, 180, 180, 100);
        panel.setLayout(null);
        this.rowSelect = new KDRadioButton(CtrlEXTMessages.getMLS("selectedRow", "\u9009\u4e2d\u884c"));
        this.rowSelect.setBounds(20, 60, 100, 20);
        this.cellSelect = new KDRadioButton(CtrlEXTMessages.getMLS("selectedCell", "\u9009\u4e2d\u5355\u5143\u683c"));
        this.cellSelect.setBounds(20, 30, 100, 20);
        panel.setBorder((Border)BorderFactory.createTitledBorder(CtrlEXTMessages.getMLS("browsingMode", "\u6d4f\u89c8\u6a21\u5f0f")));
        panel.add((Component)this.cellSelect);
        panel.add((Component)this.rowSelect);
        this.group = new KDButtonGroup();
        this.group.add((AbstractButton)this.cellSelect);
        this.group.add((AbstractButton)this.rowSelect);
        this.constraintsPanel = new KDPanel(){

            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                Graphics temp = g.create();
                temp.setColor(Color.lightGray);
                temp.drawLine(2, 2, 2, 294);
                temp.drawLine(2, 2, 190, 2);
                temp.drawLine(190, 2, 190, 294);
                temp.drawLine(2, 294, 190, 294);
                temp.dispose();
            }
        };
        this.constraintsPanel.setLayout(null);
        this.constraintsPanel.add((Component)this.rowCount);
        this.constraintsPanel.add((Component)this.columnCount);
        this.constraintsPanel.add((Component)panel);
        this.constraintsPanel.setPreferredSize(new Dimension(200, 400));
        this.getContentPane().add((Component)this.constraintsPanel);
        if (this.current != null) {
            this.rowCount.setSelected(this.current.isRowCountVisible());
            this.columnCount.setSelected(this.current.isColCountVisible());
            this.group.setValue(this.current.isCellSelect() ? 0 : 1);
        } else {
            this.group.setValue(0);
        }
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout());
        this.bar = new KDToolBar();
        this.newAction = new NewAction(CtrlEXTMessages.getMLS("new", "\u65b0\u5efa"));
        this.saveAction = new SaveAction(CtrlEXTMessages.getMLS("save", "\u4fdd\u5b58"));
        this.saveAction.setEnabled(false);
        this.renameSaveAction = new RenameSaveAction(CtrlEXTMessages.getMLS("saveAs", "\u53e6\u5b58\u4e3a"));
        this.renameSaveAction.setEnabled(false);
        this.deleteAction = new DeleteAction(CtrlEXTMessages.getMLS("KEY_DELETE", "\u5220\u9664"));
        this.deleteAction.setEnabled(false);
        this.changeAction = new ChangeAction(CtrlEXTMessages.getMLS("modify", "\u4fee\u6539"));
        this.changeAction.setEnabled(false);
        if (this.cases == null) {
            this.combo = new KDComboBox();
        } else {
            this.combo = new KDComboBox((Object[])this.cases);
            this.combo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ShowcaseChooser.this.box.setSelected(false);
                    ShowcaseChooser.this.box.setEnabled(false);
                    ShowcaseChooser.this.level = (ShowcaseType)ShowcaseChooser.this.combo.getSelectedItem();
                    ArrayList list = (ArrayList)ShowcaseChooser.this.table.get(ShowcaseChooser.this.level);
                    ShowcaseConfig[] temp = ShowcaseChooser.this.collection.fetchAllShowcaseConfigByLevel(ShowcaseChooser.this.level);
                    ShowcaseChooser.this.showcaseList.removeAllElements();
                    if (temp == null) {
                        return;
                    }
                    int k = temp.length;
                    for (int i = 0; i < k; ++i) {
                        list.add(temp[i]);
                        ShowcaseChooser.this.showcaseList.addElement((Object)temp[i]);
                    }
                }
            });
        }
        this.combo.setFocusable(false);
        this.initList();
        this.bar.add((Action)this.newAction);
        this.bar.add((Action)this.saveAction);
        this.bar.add((Action)this.renameSaveAction);
        this.bar.add((Action)this.deleteAction);
        this.bar.add((Action)this.changeAction);
        this.bar.add((Component)new KDLabel(CtrlEXTMessages.getMLS("schemeLevelSelection", "             \u65b9\u6848\u7ea7\u522b\u9009\u62e9: ")));
        this.bar.add((Component)this.combo);
        this.addToolBar((JToolBar)this.bar);
        this.initControlPanel();
        this.getContentPane().add((Component)this.controlPanel, "South");
    }

    private void initControlPanel() {
        this.box = new KDCheckBox(CtrlEXTMessages.getMLS("nextTimeEnterWithScheme", "\u4e0b\u6b21\u76f4\u63a5\u4ee5\u8be5\u65b9\u6848\u8fdb\u5165"));
        this.box.setEnabled(false);
        this.confirm = new KDButton(CtrlEXTMessages.getMLS("KEY_OK", "\u786e\u5b9a"));
        this.cancle = new KDButton(CtrlEXTMessages.getMLS("KEY_CANCEL", "\u53d6\u6d88"));
        this.controlPanel = new KDPanel();
        this.controlPanel.setLayout(null);
        this.box.setBounds(0, 0, 200, 20);
        this.confirm.setBounds(210, 15, 80, 20);
        this.cancle.setBounds(310, 15, 80, 20);
        this.controlPanel.add((Component)this.box);
        this.controlPanel.add((Component)this.confirm);
        this.controlPanel.add((Component)this.cancle);
        this.controlPanel.setPreferredSize(new Dimension(400, 50));
    }

    private void initList() {
        this.table = new Hashtable();
        this.scrollPane = new KDScrollPane();
        this.showcaseList = new KDList();
        this.scrollPane.setViewportView((Component)this.showcaseList);
        this.scrollPane.setPreferredSize(new Dimension(200, 400));
        this.scrollPane.setBounds(20, 80, 200, 200);
        if (this.cases == null) {
            return;
        }
        int size = this.cases.length;
        for (int i = 0; i < size; ++i) {
            this.table.put(this.cases[i], new ArrayList());
        }
        ShowcaseConfig[] configs = this.collection.fetchAllShowcaseConfigByLevel(this.cases[0]);
        if (configs != null) {
            size = configs.length;
            ArrayList list = (ArrayList)this.table.get(this.cases[0]);
            for (int i = 0; i < size; ++i) {
                list.add(configs[i].getShowcaseName());
                this.showcaseList.addElement((Object)configs[i]);
            }
        }
        this.getContentPane().add((Component)this.scrollPane, "West");
        this.showcaseList.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                Object obj = ShowcaseChooser.this.showcaseList.getSelectedValue();
                if (obj == null) {
                    return;
                }
                ShowcaseChooser.this.box.setSelected(false);
                if (ShowcaseChooser.this.level == ShowcaseChooser.this.cases[0]) {
                    ShowcaseChooser.this.box.setEnabled(true);
                }
                ShowcaseChooser.this.saveAction.setEnabled(true);
                ShowcaseChooser.this.renameSaveAction.setEnabled(true);
                ShowcaseChooser.this.deleteAction.setEnabled(true);
                ShowcaseChooser.this.changeAction.setEnabled(true);
                if (null != ShowcaseChooser.this.collection.fetchShowcaseConfig((ShowcaseConfig)obj) && ((ShowcaseConfig)obj).isDefault()) {
                    ShowcaseChooser.this.box.setSelected(true);
                }
                ShowcaseChooser.this.setCheckBoxbySelection((ShowcaseConfig)obj);
            }
        });
    }

    private void initNameGetDialog() {
        this.nameGet.setResizable(false);
        this.nameGet.setDefaultCloseOperation(0);
        this.nameGet.setModal(true);
        this.nameGet.setSize(280, 120);
        this.nameGet.setLocationRelativeTo((Component)((Object)this));
        KDPanel container = new KDPanel();
        container.setLayout(null);
        this.nameLabel.setBounds(20, 20, 80, 20);
        this.nameBox.setBounds(100, 20, 140, 20);
        container.add((Component)this.nameLabel);
        container.add((Component)this.nameBox);
        KDButton button = new KDButton(CtrlEXTMessages.getMLS("KEY_OK", "\u786e\u5b9a"));
        KDButton cancle = new KDButton(CtrlEXTMessages.getMLS("KEY_CANCEL", "\u53d6\u6d88"));
        button.setBounds(110, 65, 65, 20);
        cancle.setBounds(195, 65, 65, 20);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowcaseChooser.this.nameGet.setVisible(false);
                ShowcaseChooser.this.nameGet.dispose();
            }
        });
        cancle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowcaseChooser.this.nameBox.setText("");
                ShowcaseChooser.this.nameGet.setVisible(false);
                ShowcaseChooser.this.nameGet.dispose();
            }
        });
        container.add((Component)button);
        container.add((Component)cancle);
        this.nameGet.getContentPane().add((Component)container);
        this.nameGet.addWindowListener((WindowListener)new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ShowcaseChooser.this.nameBox.setText("");
                ShowcaseChooser.this.nameGet.setVisible(false);
                ShowcaseChooser.this.nameGet.dispose();
            }
        });
    }

    private void initListeners() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ShowcaseChooser.this.setVisible(false);
                ShowcaseChooser.this.dispose();
            }
        });
        this.confirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int listSize = 0;
                Iterator iter = ShowcaseChooser.this.table.keySet().iterator();
                while (iter.hasNext()) {
                    listSize += ((ArrayList)ShowcaseChooser.this.table.get(iter.next())).size();
                }
                Object obj = ShowcaseChooser.this.showcaseList.getSelectedValue();
                if (listSize == 0) {
                    ShowcaseChooser.this.setVisible(false);
                    ShowcaseChooser.this.dispose();
                    return;
                }
                if (obj == null && ShowcaseChooser.this.showcaseList.getElementCount() > 0) {
                    obj = ShowcaseChooser.this.showcaseList.getElement(0);
                }
                if (obj == null) {
                    ShowcaseChooser.this.setVisible(false);
                    ShowcaseChooser.this.dispose();
                    return;
                }
                ShowcaseChooser.this.last = ShowcaseChooser.this.current;
                ShowcaseChooser.this.current = (ShowcaseConfig)obj;
                ShowcaseChooser.this.returnValue = 1;
                ShowcaseChooser.this.setVisible(false);
                ShowcaseChooser.this.dispose();
            }
        });
        this.cancle.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowcaseChooser.this.current = ShowcaseChooser.this.last;
                ShowcaseChooser.this.returnValue = -1;
                ShowcaseChooser.this.setVisible(false);
                ShowcaseChooser.this.dispose();
            }
        });
        this.rowCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = ShowcaseChooser.this.showcaseList.getSelectedValue();
                if (obj != null) {
                    ShowcaseChooser.this.updateConfig2((ShowcaseConfig)obj);
                } else {
                    ShowcaseChooser.this.updateConfig2(ShowcaseChooser.this.current);
                }
            }
        });
        this.columnCount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = ShowcaseChooser.this.showcaseList.getSelectedValue();
                if (obj != null) {
                    ShowcaseChooser.this.updateConfig2((ShowcaseConfig)obj);
                } else {
                    ShowcaseChooser.this.updateConfig2(ShowcaseChooser.this.current);
                }
            }
        });
        this.cellSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = ShowcaseChooser.this.showcaseList.getSelectedValue();
                if (obj != null) {
                    ShowcaseChooser.this.updateConfig2((ShowcaseConfig)obj);
                } else {
                    ShowcaseChooser.this.updateConfig2(ShowcaseChooser.this.current);
                }
            }
        });
        this.rowSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object obj = ShowcaseChooser.this.showcaseList.getSelectedValue();
                if (obj != null) {
                    ShowcaseChooser.this.updateConfig2((ShowcaseConfig)obj);
                } else {
                    ShowcaseChooser.this.updateConfig2(ShowcaseChooser.this.current);
                }
            }
        });
        this.combo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowcaseChooser.this.rowCount.setSelected(false);
                ShowcaseChooser.this.columnCount.setSelected(false);
                ShowcaseChooser.this.group.setValue(0);
            }
        });
    }

    private void updateConfig2(ShowcaseConfig config) {
        if (config != null) {
            boolean[] user = this.fetchUserSettings();
            config.setRowCountVisible(user[2]);
            config.setColCountVisible(user[3]);
            config.setCellSelect(user[5]);
        }
    }

    private boolean[] fetchUserSettings() {
        boolean editable = this.editable.isSelected();
        boolean showFormula = this.showFormula.isSelected();
        boolean rowCount = this.rowCount.isSelected();
        boolean columnCount = this.columnCount.isSelected();
        boolean hideEditable = this.hideEditable.isSelected();
        boolean cell = this.group.getValue() == 0;
        return new boolean[]{editable, showFormula, rowCount, columnCount, hideEditable, cell};
    }

    private boolean checkName(String name) {
        boolean flag = false;
        int size = this.showcaseList.getElementCount();
        for (int i = 0; i < size; ++i) {
            if (!name.equals(this.showcaseList.getElement(i).toString())) continue;
            flag = true;
        }
        return flag;
    }

    private void setCheckBoxbySelection(ShowcaseConfig config) {
        if (config != null) {
            this.editable.setSelected(config.isEditable());
            this.showFormula.setSelected(config.isShowFormula());
            this.rowCount.setSelected(config.isRowCountVisible());
            this.columnCount.setSelected(config.isColCountVisible());
            this.hideEditable.setSelected(config.isHideEditable());
            if (config.isCellSelect()) {
                this.group.setValue(0);
            } else {
                this.group.setValue(1);
            }
        }
    }

    public void showDialog(SavedSpan[] rowSpan, SavedSpan[] colSpan) {
        this.box.setEnabled(false);
        if (this.collection.getLastFilePath() == null) {
            MessageUtil.msgboxOkCancel(this.getParent(), CtrlEXTMessages.getMLS("reportNotSaved", "\u5f53\u524d\u62a5\u8868\u672a\u4fdd\u5b58,\u8bf7\u4fdd\u5b58\u540e\u7f16\u8f91\u663e\u793a\u65b9\u6848!"));
            return;
        }
        this.last = this.current;
        this.current = this.collection.getDefaultConfig();
        if (this.current != null) {
            this.showcaseList.setSelectedValue((Object)this.current, true);
            if (this.current.isDefault()) {
                this.box.setEnabled(true);
                this.box.setSelected(true);
            }
        }
        this.rowSpan = rowSpan;
        this.colSpan = colSpan;
        this.show();
    }

    public ShowcaseConfig getCurrentShowcaseConfig() {
        return this.current;
    }

    public int fetchReturnValue() {
        return this.returnValue;
    }

    class ChangeAction
    extends AbstractAction {
        public ChangeAction(String name) {
            this.putValue("ShortDescription", CtrlEXTMessages.getMLS("rename", "\u91cd\u547d\u540d"));
            this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_edit.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ShowcaseChooser.this.nameGet.setTitle(CtrlEXTMessages.getMLS("schemeRename", "\u65b9\u6848\u91cd\u547d\u540d"));
            ShowcaseChooser.this.nameGet.show();
            KDTextField filed = ShowcaseChooser.this.nameBox;
            String name = filed.getText();
            if (name == null || name.trim().equals("")) {
                return;
            }
            if (ShowcaseChooser.this.checkName(name)) {
                MessageUtil.msgboxOkCancel((Component)((Object)ShowcaseChooser.this), CtrlEXTMessages.getMLS("fileWithSameNameExistsModify", "\u5b58\u5728\u540c\u540d\u6587\u4ef6,\u8bf7\u786e\u8ba4\u540e\u4fee\u6539!"));
                return;
            }
            Object obj = ShowcaseChooser.this.showcaseList.getSelectedValue();
            ShowcaseConfig config = (ShowcaseConfig)obj;
            if (config == null) {
                return;
            }
            config.setShowcaseName(name);
            ShowcaseChooser.this.showcaseList.setElement((Object)config, ShowcaseChooser.this.showcaseList.getSelectedIndex());
        }
    }

    class DeleteAction
    extends AbstractAction {
        public DeleteAction(String name) {
            this.putValue("ShortDescription", CtrlEXTMessages.getMLS("delete", "\u5220\u9664"));
            this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_Delete.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int size;
            Object obj = ShowcaseChooser.this.showcaseList.getSelectedValue();
            if (obj == null) {
                return;
            }
            ShowcaseConfig deleteConfig = (ShowcaseConfig)obj;
            if (ShowcaseChooser.this.collection.deleteConfig(deleteConfig)) {
                int k = ShowcaseChooser.this.showcaseList.getElementCount();
                for (int i = 0; i < k; ++i) {
                    ShowcaseChooser.this.showcaseList.removeElementAt(0);
                    ((ArrayList)ShowcaseChooser.this.table.get(ShowcaseChooser.this.level)).remove(0);
                }
                ShowcaseConfig[] configs = ShowcaseChooser.this.collection.fetchAllShowcaseConfigByLevel(ShowcaseChooser.this.level);
                if (configs != null) {
                    int k2 = configs.length;
                    for (int i = 0; i < k2; ++i) {
                        ShowcaseChooser.this.showcaseList.addElement((Object)configs[i]);
                        ((ArrayList)ShowcaseChooser.this.table.get(ShowcaseChooser.this.level)).add(configs[i]);
                    }
                }
            }
            if ((size = ShowcaseChooser.this.showcaseList.getElementCount()) == 0) {
                ShowcaseChooser.this.last = ShowcaseChooser.this.current;
                ShowcaseChooser.this.current = new ShowcaseConfig();
            } else {
                ShowcaseChooser.this.showcaseList.setSelectedIndex(size - 1);
                ShowcaseChooser.this.last = ShowcaseChooser.this.current;
                ShowcaseChooser.this.current = (ShowcaseConfig)ShowcaseChooser.this.showcaseList.getSelectedValue();
            }
            ShowcaseChooser.this.setCheckBoxbySelection(ShowcaseChooser.this.current);
        }
    }

    class RenameSaveAction
    extends AbstractAction {
        public RenameSaveAction(String name) {
            this.putValue("ShortDescription", CtrlEXTMessages.getMLS("saveAs", "\u53e6\u5b58\u4e3a"));
            this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_Saveas.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = ShowcaseChooser.this.showcaseList.getSelectedValue();
            if (obj == null) {
                obj = ShowcaseChooser.this.current;
            } else {
                ShowcaseChooser.this.nameBox.setText(obj.toString());
            }
            ShowcaseChooser.this.nameGet.setTitle(CtrlEXTMessages.getMLS("schemeSaveAs", "\u65b9\u6848\u53e6\u5b58\u4e3a"));
            ShowcaseChooser.this.nameGet.show();
            KDTextField filed = ShowcaseChooser.this.nameBox;
            String name = filed.getText();
            if (StringUtil.isEmptyString((String)name)) {
                return;
            }
            ShowcaseConfig config = (ShowcaseConfig)obj;
            if (config != null) {
                ShowcaseConfig copy = new ShowcaseConfig();
                copy.setEditable(config.isEditable());
                copy.setCellSelect(config.isCellSelect());
                copy.setHideEditable(config.isHideEditable());
                copy.setColCountVisible(config.isColCountVisible());
                copy.setRowCountVisible(config.isRowCountVisible());
                copy.setShowFormula(config.isShowFormula());
                copy.setRowSpans(config.getRowSpans());
                copy.setColSpans(config.getColSpans());
                copy.setShowcaseName(name);
                copy.setLevel(ShowcaseChooser.this.level);
                ShowcaseChooser.this.showcaseList.addElement((Object)copy);
                ShowcaseChooser.this.collection.saveShowcaseConfig(copy);
            }
        }
    }

    class SaveAction
    extends AbstractAction {
        public SaveAction(String name) {
            this.putValue("ShortDescription", CtrlEXTMessages.getMLS("save", "\u4fdd\u5b58"));
            this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_Save.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = ShowcaseChooser.this.showcaseList.getSelectedValue();
            if (obj == null) {
                MessageUtil.msgboxOkCancel((Component)((Object)ShowcaseChooser.this), CtrlEXTMessages.getMLS("pleaseSelectNode", "\u8bf7\u9009\u62e9\u5c06\u8981\u4fdd\u5b58\u7684\u8282\u70b9"));
                return;
            }
            ShowcaseConfig config = (ShowcaseConfig)obj;
            if (config != null) {
                config.setEditable(ShowcaseChooser.this.current.isEditable());
                config.setCellSelect(ShowcaseChooser.this.group.getValue() == 0);
                config.setHideEditable(ShowcaseChooser.this.current.isHideEditable());
                config.setColCountVisible(ShowcaseChooser.this.columnCount.isSelected());
                config.setRowCountVisible(ShowcaseChooser.this.rowCount.isSelected());
                config.setShowFormula(ShowcaseChooser.this.current.isShowFormula());
                config.setRowSpans(ShowcaseChooser.this.rowSpan);
                config.setColSpans(ShowcaseChooser.this.colSpan);
                boolean isDefault = ShowcaseChooser.this.box.isSelected();
                if (isDefault) {
                    ShowcaseConfig temp = ShowcaseChooser.this.collection.fetchShowcaseConfig(null);
                    temp.setDefault(false);
                    if (!temp.equals(config)) {
                        ShowcaseChooser.this.collection.saveShowcaseConfig(temp);
                    }
                }
                config.setDefault(isDefault);
                ShowcaseChooser.this.collection.saveShowcaseConfig(config);
            }
        }
    }

    class NewAction
    extends AbstractAction {
        public NewAction(String name) {
            this.putValue("ShortDescription", CtrlEXTMessages.getMLS("new", "\u65b0\u5efa"));
            this.putValue("SmallIcon", ResourceManager.getImageIcon("tbtn_New.gif"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object obj = ShowcaseChooser.this.showcaseList.getSelectedValue();
            if (obj != null) {
                ShowcaseChooser.this.nameBox.setText(obj.toString());
            } else {
                ShowcaseChooser.this.nameBox.setText("");
            }
            ShowcaseChooser.this.nameGet.setTitle(CtrlEXTMessages.getMLS("showSchemeNew", "\u663e\u793a\u65b9\u6848\u65b0\u5efa"));
            ShowcaseChooser.this.nameGet.show();
            KDTextField filed = ShowcaseChooser.this.nameBox;
            String name = filed.getText();
            if (name == null || name.trim().equals("")) {
                return;
            }
            if (ShowcaseChooser.this.checkName(name)) {
                MessageUtil.msgboxOkCancel((Component)((Object)ShowcaseChooser.this), CtrlEXTMessages.getMLS("fileWithSameNameExists", "\u5b58\u5728\u540c\u540d\u6587\u4ef6,\u8bf7\u786e\u8ba4\u540e\u65b0\u5efa!"));
                return;
            }
            ShowcaseConfig config = new ShowcaseConfig();
            config.setRowSpans(ShowcaseChooser.this.rowSpan);
            config.setColSpans(ShowcaseChooser.this.colSpan);
            config.setShowcaseName(name);
            if (ShowcaseChooser.this.current != null) {
                config.setEditable(ShowcaseChooser.this.current.isEditable());
                config.setCellSelect(ShowcaseChooser.this.current.isCellSelect());
                config.setHideEditable(ShowcaseChooser.this.current.isHideEditable());
                config.setColCountVisible(ShowcaseChooser.this.current.isColCountVisible());
                config.setRowCountVisible(ShowcaseChooser.this.current.isRowCountVisible());
                config.setShowFormula(ShowcaseChooser.this.current.isShowFormula());
            }
            config.setDefault(false);
            config.setLevel(ShowcaseChooser.this.level);
            ((ArrayList)ShowcaseChooser.this.table.get(ShowcaseChooser.this.level)).add(config);
            ShowcaseChooser.this.showcaseList.addElement((Object)config);
        }
    }
}

