/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.util;

import com.kingdee.bos.qing.common.xml.IXmlElement;
import com.kingdee.bos.qing.common.xml.XmlUtil;
import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.LogUtil;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.immit.SavedSpan;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfig;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseConfigCollection;
import com.kingdee.cosmic.ctrl.ext.immit.ShowcaseType;
import com.kingdee.cosmic.ctrl.ext.util.MiscUtil;
import com.kingdee.cosmic.ctrl.kds.model.struct.SortedAttributeSpanArray;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.log4j.Logger;

public class ShowcaseUtil {
    private static final Logger logger = LogUtil.getPackageLogger(ShowcaseUtil.class);

    public static IXmlElement parseFromString(String[] str) {
        IXmlElement root = XmlUtil.createNode((String)"report");
        IXmlElement caseNode = null;
        root.setAttribute("name", str[0]);
        for (int i = 1; i < str.length; ++i) {
            IXmlElement span;
            String[] attr;
            int j;
            caseNode = XmlUtil.createNode((String)"case");
            String[] temp = str[i].split(",");
            caseNode.setAttribute("name", temp[0]);
            caseNode.setAttribute("editable", temp[1]);
            caseNode.setAttribute("showformula", temp[2]);
            caseNode.setAttribute("rowCountVisible", temp[3]);
            caseNode.setAttribute("colCountVisible", temp[4]);
            caseNode.setAttribute("hideEditable", temp[5]);
            caseNode.setAttribute("cellSelect", temp[6]);
            caseNode.setAttribute("showcaseLevel", temp[7]);
            caseNode.setAttribute("showcaseID", temp[8]);
            caseNode.setAttribute("isDefault", temp[9]);
            int index = 0;
            IXmlElement rowSpan = XmlUtil.createNode((String)"rowSpans");
            IXmlElement colSpan = XmlUtil.createNode((String)"colSpans");
            caseNode.addChild(rowSpan);
            caseNode.addChild(colSpan);
            for (j = 10; j < temp.length; ++j) {
                if (temp[j].equals("other")) {
                    index = ++j;
                    break;
                }
                attr = temp[j].split(":");
                span = XmlUtil.createNode((String)"span");
                span.setAttribute("start", attr[0]);
                span.setAttribute("end", attr[1]);
                span.setAttribute("length", attr[2]);
                span.setAttribute("visible", attr[3]);
                rowSpan.addChild(span);
            }
            for (j = index; j < temp.length; ++j) {
                attr = temp[j].split(":");
                span = XmlUtil.createNode((String)"span");
                span.setAttribute("start", attr[0]);
                span.setAttribute("end", attr[1]);
                span.setAttribute("length", attr[2]);
                span.setAttribute("visible", attr[3]);
                colSpan.addChild(span);
            }
            root.addChild(caseNode);
        }
        return root;
    }

    public static String[] toShowcaseConfigs(IXmlElement elm) {
        List children = elm.getChildren();
        String[] cList = new String[children.size() + 1];
        cList[0] = elm.getAttribute("name");
        StringBuilder buffer = new StringBuilder();
        IXmlElement temp = null;
        for (int i = 0; i < children.size(); ++i) {
            IXmlElement element;
            AbstractStringBuilder text;
            int j;
            buffer = new StringBuilder();
            temp = (IXmlElement)children.get(i);
            List keys = temp.getAttributeKeys();
            int size = keys.size();
            for (int j2 = 0; j2 < size; ++j2) {
                String key = (String)keys.get(i);
                if (j2 != size - 1) {
                    buffer.append(temp.getAttribute(key)).append(",");
                    continue;
                }
                buffer.append(temp.getAttribute(key));
            }
            List spanList = temp.getChildren();
            IXmlElement row = (IXmlElement)spanList.get(0);
            IXmlElement col = (IXmlElement)spanList.get(1);
            for (j = 0; j < row.getChildren().size(); ++j) {
                text = new StringBuilder();
                element = (IXmlElement)row.getChildren().get(j);
                ((StringBuilder)text).append(element.getAttribute("start"));
                ((StringBuilder)text).append(":").append(element.getAttribute("end"));
                ((StringBuilder)text).append(":").append(element.getAttribute("length"));
                ((StringBuilder)text).append(":").append(element.getAttribute("visible"));
                buffer.append(",").append((CharSequence)text);
            }
            buffer.append(",other");
            for (j = 0; j < col.getChildren().size(); ++j) {
                text = new StringBuffer();
                element = (IXmlElement)col.getChildren().get(j);
                ((StringBuffer)text).append(element.getAttribute("start"));
                ((StringBuffer)text).append(":").append(element.getAttribute("end"));
                ((StringBuffer)text).append(":").append(element.getAttribute("length"));
                ((StringBuffer)text).append(":").append(element.getAttribute("visible"));
                buffer.append(",").append((StringBuffer)text);
            }
            cList[i + 1] = buffer.toString();
        }
        return cList;
    }

    public static ShowcaseConfig toShowcaseConfig(String configFormatString, ShowcaseConfig srcConfig) {
        block9: {
            try {
                SavedSpan span;
                String[] attr;
                int j;
                if (srcConfig == null || configFormatString == null) {
                    throw new NullPointerException(srcConfig == null ? "srcConfig = null " + CtrlEXTMessages.getMLS("invalidParameter", "\u53c2\u6570\u975e\u6cd5") : "configFormatString = null " + CtrlEXTMessages.getMLS("invalidParameter", "\u53c2\u6570\u975e\u6cd5"));
                }
                if (StringUtil.isEmptyString((String)configFormatString)) {
                    configFormatString = ShowcaseUtil.toShowcaseConfig(new ShowcaseConfig().toElement());
                }
                String[] temp = configFormatString.split(",");
                srcConfig.setShowcaseName(temp[0]);
                srcConfig.setEditable(temp[1].equals("true"));
                srcConfig.setShowFormula(temp[2].equals("true"));
                srcConfig.setRowCountVisible(temp[3].equals("true"));
                srcConfig.setColCountVisible(temp[4].equals("true"));
                srcConfig.setHideEditable(temp[5].equals("true"));
                srcConfig.setCellSelect(temp[6].equals("true"));
                int level = 0;
                try {
                    level = Integer.parseInt(temp[7]);
                }
                catch (Exception ex) {
                    level = 1;
                }
                srcConfig.setLevel(new ShowcaseType("default", level));
                srcConfig.setShowcaseID(temp[8]);
                srcConfig.setDefault(temp[9].equals("true"));
                ArrayList<SavedSpan> rowList = new ArrayList<SavedSpan>();
                ArrayList<SavedSpan> colList = new ArrayList<SavedSpan>();
                int index = 0;
                for (j = 10; j < temp.length; ++j) {
                    if (temp[j].equals("other")) {
                        index = ++j;
                        break;
                    }
                    attr = temp[j].split(":");
                    span = new SavedSpan(Integer.parseInt(attr[0]), Integer.parseInt(attr[1]), Integer.parseInt(attr[2]), Boolean.parseBoolean(attr[3]));
                    rowList.add(span);
                }
                for (j = index; j < temp.length; ++j) {
                    attr = temp[j].split(":");
                    span = new SavedSpan(Integer.parseInt(attr[0]), Integer.parseInt(attr[1]), Integer.parseInt(attr[2]), Boolean.parseBoolean(attr[3]));
                    colList.add(span);
                }
                srcConfig.setRowSpans(rowList.toArray());
                srcConfig.setColSpans(colList.toArray());
            }
            catch (Exception ex) {
                logger.error((Object)"err", (Throwable)ex);
                if (!MiscUtil.shouldLog()) break block9;
                MiscUtil.error(ex.getMessage());
            }
        }
        return srcConfig;
    }

    public static String toShowcaseConfig(IXmlElement elm) {
        IXmlElement element;
        AbstractStringBuilder text;
        int j;
        StringBuilder buffer = new StringBuilder();
        List keys = elm.getAttributeKeys();
        int k = keys.size();
        for (int j2 = 0; j2 < k; ++j2) {
            String key = (String)keys.get(j2);
            if (j2 != k - 1) {
                buffer.append(elm.getAttribute(key)).append(",");
                continue;
            }
            buffer.append(elm.getAttribute(key));
        }
        List spanList = elm.getChildren();
        IXmlElement row = (IXmlElement)spanList.get(0);
        IXmlElement col = (IXmlElement)spanList.get(1);
        for (j = 0; j < row.getChildren().size(); ++j) {
            text = new StringBuilder();
            element = (IXmlElement)row.getChildren().get(j);
            ((StringBuilder)text).append(element.getAttribute("start"));
            ((StringBuilder)text).append(":").append(element.getAttribute("end"));
            ((StringBuilder)text).append(":").append(element.getAttribute("length"));
            ((StringBuilder)text).append(":").append(element.getAttribute("visible"));
            buffer.append(",").append((CharSequence)text);
        }
        buffer.append(",other");
        for (j = 0; j < col.getChildren().size(); ++j) {
            text = new StringBuffer();
            element = (IXmlElement)col.getChildren().get(j);
            ((StringBuffer)text).append(element.getAttribute("start"));
            ((StringBuffer)text).append(":").append(element.getAttribute("end"));
            ((StringBuffer)text).append(":").append(element.getAttribute("length"));
            ((StringBuffer)text).append(":").append(element.getAttribute("visible"));
            buffer.append(",").append((StringBuffer)text);
        }
        return buffer.toString();
    }

    public static ShowcaseConfigCollection toShowcaseConfigs(String[] str, ShowcaseType[] levels) {
        if (str == null || str.length == 0) {
            return null;
        }
        ShowcaseConfigCollection collection = new ShowcaseConfigCollection(true);
        collection.setName(str[0]);
        ShowcaseConfig config = null;
        ArrayList<SavedSpan> rowList = new ArrayList<SavedSpan>();
        ArrayList<SavedSpan> colList = new ArrayList<SavedSpan>();
        for (int i = 1; i < str.length; ++i) {
            SavedSpan span;
            String[] attr;
            int j;
            config = new ShowcaseConfig();
            String[] temp = str[i].split(",");
            config.setShowcaseName(temp[0]);
            config.setEditable(temp[1].equals("true"));
            config.setShowFormula(temp[2].equals("true"));
            config.setRowCountVisible(temp[3].equals("true"));
            config.setColCountVisible(temp[4].equals("true"));
            config.setHideEditable(temp[5].equals("true"));
            config.setCellSelect(temp[6].equals("true"));
            int level = Integer.parseInt(temp[7]);
            if (level > 0) {
                for (int k = 0; k < levels.length; ++k) {
                    if (levels[k].getLevel() != level) continue;
                    config.setLevel(levels[k]);
                }
            }
            config.setShowcaseID(temp[8]);
            config.setDefault(temp[9].equals("true"));
            int index = 0;
            for (j = 10; j < temp.length; ++j) {
                if (temp[j].equals("other")) {
                    index = ++j;
                    break;
                }
                attr = temp[j].split(":");
                span = new SavedSpan(Integer.parseInt(attr[0]), Integer.parseInt(attr[1]), Integer.parseInt(attr[2]), Boolean.parseBoolean(attr[3]));
                rowList.add(span);
            }
            for (j = index; j < temp.length; ++j) {
                attr = temp[j].split(":");
                span = new SavedSpan(Integer.parseInt(attr[0]), Integer.parseInt(attr[1]), Integer.parseInt(attr[2]), Boolean.parseBoolean(attr[3]));
                colList.add(span);
            }
            config.setRowSpans(rowList.toArray());
            config.setColSpans(colList.toArray());
            rowList.clear();
            colList.clear();
            if (config.isDefault()) {
                collection.setDefaultConfig(config);
            }
            collection.addShowcaseConfig(config);
        }
        return collection;
    }

    public static void saveFile(String path, IXmlElement root) {
        try {
            File file = new File(FilenameUtils.normalize((String)path));
            if (!file.exists()) {
                if (file.getParentFile() != null) {
                    file.getParentFile().mkdir();
                }
                if (!file.createNewFile()) {
                    logger.warn((Object)(file.getName() + "\u6587\u4ef6\u521b\u5efa\u5931\u8d25"));
                }
            }
            String name = file.getName().substring(0, file.getName().lastIndexOf(46));
            name = name.substring(0, name.lastIndexOf(46));
            root.setAttribute("name", name);
            XmlUtil.saveFile((IXmlElement)root, (File)file);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static IXmlElement loadFile(String path) {
        if (StringUtil.isEmptyString((String)path)) {
            return XmlUtil.createNode((String)"report");
        }
        try {
            File file = new File(FilenameUtils.normalize((String)path));
            if (!file.exists()) {
                return XmlUtil.createNode((String)"report");
            }
            return XmlUtil.loadRootElementFromFile((File)file);
        }
        catch (Exception e) {
            return XmlUtil.createNode((String)"report");
        }
    }

    public static String parseFilePath(String src) {
        if (src == null) {
            return null;
        }
        String newPath = null;
        File file = new File(FilenameUtils.normalize((String)src));
        if (file.getParentFile() != null) {
            newPath = file.getParentFile() + "/showcases/" + file.getName() + ".xml";
        }
        return newPath;
    }

    public static synchronized SavedSpan[] toSavedSpan(SortedAttributeSpanArray array) {
        SavedSpan[] span = null;
        if (array != null) {
            int size = array.size();
            span = new SavedSpan[size];
            for (int i = 0; i < size; ++i) {
                Object obj = array.get(i);
                if (!(obj instanceof SortedAttributeSpanArray.AttributeSpan)) continue;
                SortedAttributeSpanArray.AttributeSpan temp = (SortedAttributeSpanArray.AttributeSpan)obj;
                span[i] = new SavedSpan(temp.getStart(), temp.getEnd(), temp.getLength(), temp.isVisible());
            }
        }
        return span;
    }
}

