/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.ext.util.manage.calculation.model;

import com.kingdee.cosmic.ctrl.common.i18n.CtrlEXTMessages;
import com.kingdee.cosmic.ctrl.common.util.StringUtil;
import com.kingdee.cosmic.ctrl.ext.util.manage.calculation.ThreadDefine;
import com.kingdee.cosmic.ctrl.ext.util.manage.calculation.log.LogManager;
import com.kingdee.cosmic.ctrl.ext.util.manage.calculation.model.CalculationChangedListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class CalcThreadModel {
    private ArrayList calculatingList = new ArrayList();
    private List calculatedList = new LinkedList();
    private List interruptedList = new LinkedList();
    private ArrayList listeners = new ArrayList();
    private ArrayList clientSockets = new ArrayList();
    private static final int RECODE_SIZE = 10;
    private static Logger logger = Logger.getLogger(CalcThreadModel.class);

    public void addCalculatingThread(ThreadDefine td) {
        this.calculatingList.add(td);
        this.fireChange();
    }

    public void addCalculatedThread(ThreadDefine td) {
        if (this.calculatingList.isEmpty()) {
            return;
        }
        int index = this.calculatingList.indexOf(td);
        if (index < 0) {
            return;
        }
        ThreadDefine ing = (ThreadDefine)this.calculatingList.get(index);
        td.setStartTime(ing.getStartTime());
        td.setEndTime(new Date());
        this.calculatingList.remove(td);
        while (this.calculatedList.size() >= 10) {
            ((LinkedList)this.calculatedList).removeLast();
        }
        ((LinkedList)this.calculatedList).addFirst(td);
        td.clear();
        this.fireChange();
    }

    public void addInterruptedThread(ThreadDefine td) {
        if (this.calculatingList.isEmpty()) {
            return;
        }
        int index = this.calculatingList.indexOf(td);
        if (index < 0) {
            return;
        }
        ThreadDefine ing = (ThreadDefine)this.calculatingList.get(index);
        td.setStartTime(ing.getStartTime());
        td.setEndTime(new Date());
        this.calculatingList.remove(td);
        while (this.interruptedList.size() >= 10) {
            ((LinkedList)this.interruptedList).removeLast();
        }
        ((LinkedList)this.interruptedList).addFirst(td);
        td.clear();
        this.fireChange();
    }

    public void addRemoteListener(Socket socket) {
        this.clientSockets.add(socket);
    }

    public void addLocalListener(CalculationChangedListener l) {
        this.listeners.add(l);
    }

    public void removeRemoteListener(Socket socket) {
        this.clientSockets.remove(socket);
    }

    public void removeLocalListener(CalculationChangedListener l) {
        this.listeners.remove(l);
    }

    public int remoteListenersSize() {
        return this.clientSockets.size();
    }

    public int getLocalListenersSize() {
        return this.listeners.size();
    }

    public CalculationChangedListener getLocalCalculationChangedListener(int index) {
        return (CalculationChangedListener)this.listeners.get(index);
    }

    public void interruptedThread(ThreadDefine t) {
        ThreadDefine td = this.findThread(t);
        if (td != null) {
            td.interrupt();
            td.setThreadMessage(CtrlEXTMessages.getMLS("userInitiatedThreadTermination", "\u7528\u6237\u4e3b\u52a8\u7ec8\u6b62\u5f53\u524d\u8ba1\u7b97\u7ebf\u7a0b"));
            this.addInterruptedThread(td);
        }
    }

    private ThreadDefine findThread(ThreadDefine t) {
        if (t == null) {
            return null;
        }
        String userNameTerm = t.getUserName();
        String userIpTerm = t.getUserIp();
        String reportNameTerm = t.getReportName();
        long calcIdTerm = t.getCalculationId();
        int len = this.calculatingList.size();
        for (int i = 0; i < len; ++i) {
            ThreadDefine td = (ThreadDefine)this.calculatingList.get(i);
            String userName = td.getUserName();
            String userIp = td.getUserIp();
            String reportName = td.getReportName();
            long calcId = td.getCalculationId();
            if (calcIdTerm != calcId || !CalcThreadModel.isStringSame(userNameTerm, userName) || !CalcThreadModel.isStringSame(userIpTerm, userIp) || !CalcThreadModel.isStringSame(reportNameTerm, reportName)) continue;
            return td;
        }
        return null;
    }

    private static boolean isStringSame(String val1, String val2) {
        boolean isVal2Empty;
        boolean isVal1Empty = StringUtil.isEmptyString((String)val1);
        if (isVal1Empty == (isVal2Empty = StringUtil.isEmptyString((String)val2))) {
            if (!isVal1Empty) {
                return val1.equals(val2);
            }
            return true;
        }
        return false;
    }

    public void fireChange(Socket s) {
        this.setCurrentTime();
        try {
            ObjectOutputStream out = new ObjectOutputStream(s.getOutputStream());
            out.writeObject(this.calculatedList);
            out.writeObject(this.calculatingList);
            out.writeObject(this.interruptedList);
            out.flush();
        }
        catch (IOException ex) {
            logger.log(Priority.ERROR, (Object)CtrlEXTMessages.getMLS("unableToInteractWithClientMonitoring", "\u65e0\u6cd5\u4e0e\u5ba2\u6237\u7aef\u76d1\u63a7\u4ea4\u4e92"));
        }
    }

    public void fireChange() {
        this.setCurrentTime();
        if (!LogManager.REMOTE_FOUND) {
            for (int i = this.getLocalListenersSize() - 1; i >= 0; --i) {
                final CalculationChangedListener listener = (CalculationChangedListener)this.listeners.get(i);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        listener.calculatedListChanged(CalcThreadModel.this.calculatedList, true);
                        listener.calculatingListChanged(CalcThreadModel.this.calculatingList, true);
                        listener.interruptedListChanged(CalcThreadModel.this.interruptedList, true);
                    }
                });
            }
        } else {
            for (int i = this.clientSockets.size() - 1; i >= 0; --i) {
                Socket client = (Socket)this.clientSockets.get(i);
                if (client.isClosed()) continue;
                this.fireChange(client);
            }
        }
    }

    private void setCurrentTime() {
        int i;
        int len = this.calculatedList.size();
        for (i = 0; i < len; ++i) {
            ((ThreadDefine)this.calculatedList.get(i)).setCurrentTime(new Date());
        }
        len = this.calculatingList.size();
        for (i = 0; i < len; ++i) {
            ((ThreadDefine)this.calculatingList.get(i)).setCurrentTime(new Date());
        }
        len = this.interruptedList.size();
        for (i = 0; i < len; ++i) {
            ((ThreadDefine)this.interruptedList.get(i)).setCurrentTime(new Date());
        }
    }
}

