/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.extcommon.digitalstyle;

import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.FormatResult;
import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.Formats;
import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.Node;
import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.SimpleFormat;
import com.kingdee.cosmic.ctrl.extcommon.variant.Util;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import java.math.BigDecimal;
import java.util.ArrayList;

class GeneralFormat
extends SimpleFormat {
    static final GeneralFormat defaultInstance = new GeneralFormat();

    GeneralFormat() {
    }

    @Override
    public FormatResult format(Variant var, boolean parse) {
        if (var == null) {
            return FormatResult.NullResult;
        }
        String likelyValue = this.getLikelyValue(var);
        StringBuilder sb = new StringBuilder();
        int repeatIndex = -1;
        int size = this._nodes.size();
        for (int i = 0; i < size; ++i) {
            Node node = (Node)this._nodes.get(i);
            if (node.getType() == 26) {
                sb.append(likelyValue);
            } else {
                sb.append(node.getText());
            }
            if (node.getType() != 24) continue;
            repeatIndex = i;
        }
        String result = sb.toString();
        return new FormatResult(result, repeatIndex);
    }

    String getLikelyValue(Variant var) {
        int vt = var.getVt();
        if (vt == 10) {
            BigDecimal bd = (BigDecimal)var.getValue();
            if (bd.scale() > 15) {
                Variant varTmp = new Variant(bd.setScale(15, 4), 10);
                Util.reduceScale(varTmp);
                return varTmp.toString();
            }
        } else if (var.isDate()) {
            return Formats.getFormat("yyyy-mm-dd").format(var).toString();
        }
        return var.toString();
    }

    static {
        GeneralFormat.defaultInstance._nodes = new ArrayList();
        GeneralFormat.defaultInstance._nodes.add(Node.General);
    }
}

