/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.extcommon.digitalstyle;

import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.FormatResult;
import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.Node;
import com.kingdee.cosmic.ctrl.extcommon.digitalstyle.SimpleFormat;
import com.kingdee.cosmic.ctrl.extcommon.variant.IVarReferences;
import com.kingdee.cosmic.ctrl.extcommon.variant.SyntaxErrorException;
import com.kingdee.cosmic.ctrl.extcommon.variant.Util;
import com.kingdee.cosmic.ctrl.extcommon.variant.Variant;
import com.kingdee.cosmic.ctrl.kdf.util.CtrlFormatUtilities;
import com.kingdee.cosmic.ctrl.kds.model.struct.node.CellBlockNode;
import com.kingdee.cosmic.ctrl.swing.util.CtrlSwingUtilities;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;

class NumberFormat
extends SimpleFormat {
    private int _decimalSepIndex;
    private boolean _hasGroupSep;
    private boolean _isPercent;
    private boolean _hasSign;
    private boolean _hasRadixPoint = false;

    NumberFormat() {
    }

    void setPercent(boolean b) {
        this._isPercent = b;
    }

    boolean isPercent() {
        return this._isPercent;
    }

    void setHasGroupSep(boolean b) {
        this._hasGroupSep = b;
    }

    boolean hasGroupSep() {
        return this._hasGroupSep;
    }

    void setHasSign(boolean b) {
        this._hasSign = b;
    }

    boolean hasSign() {
        return this._hasSign;
    }

    void setDecimalSepIndex(int index) {
        this._decimalSepIndex = index;
    }

    int getDecimalSepIndex() {
        return this._decimalSepIndex;
    }

    @Override
    public FormatResult format(Variant var, boolean parse) {
        if (var == null) {
            return FormatResult.NullResult;
        }
        StringBuffer sb = new StringBuffer();
        int repeatIndex = this.formatString(sb, var, parse);
        if (repeatIndex == -2) {
            return FormatResult.NullResult;
        }
        String result = sb.toString();
        return new FormatResult(result, repeatIndex);
    }

    int formatString(StringBuffer toAppend, Variant var, boolean parse) {
        String strNumber = this.toStringNumber(var, parse);
        if (strNumber == null) {
            return -2;
        }
        char c = strNumber.charAt(0);
        if (c == '-') {
            strNumber = strNumber.substring(1);
            if (this.hasSign()) {
                toAppend.append(c);
            }
        }
        int repeatIndex = this.getPointLeft(toAppend, strNumber);
        int repeatIndex2 = -1;
        if (this._decimalSepIndex != -1) {
            repeatIndex2 = this.getPointRight(toAppend, strNumber);
        }
        if (repeatIndex == -1) {
            repeatIndex = repeatIndex2;
        }
        return repeatIndex;
    }

    private int getPointLeft(StringBuffer toAppend, String strNum) {
        int patternSepIndex;
        int numIndex;
        DecimalFormatSymbols symbols = CtrlFormatUtilities.getDecimalFormatSymbols();
        char decimalSeparator = symbols.getDecimalSeparator();
        char groupingSeparator = symbols.getGroupingSeparator();
        StringBuilder leftString = new StringBuilder();
        int repeatIndex = -1;
        int nodeIndex = this._decimalSepIndex == -1 ? this._nodes.size() - 1 : this._decimalSepIndex - 1;
        int numSepIndex = strNum.indexOf(decimalSeparator);
        int n = numIndex = numSepIndex == -1 ? strNum.length() - 1 : numSepIndex - 1;
        if ("0".equals(strNum)) {
            numIndex = -1;
        }
        int patternIndex = (patternSepIndex = this._pattern.indexOf(46)) == -1 ? this._pattern.length() - 1 : patternSepIndex - 1;
        for (int i = nodeIndex; i >= 0; --i) {
            Node node = (Node)this._nodes.get(i);
            if (node.isNumber()) {
                if (numIndex >= 0) {
                    if (patternIndex <= 0) {
                        for (int j = numIndex; j >= 0; --j) {
                            leftString.append(strNum.charAt(j));
                        }
                        numIndex = -1;
                        continue;
                    }
                    char c = strNum.charAt(numIndex);
                    if (c == groupingSeparator) {
                        leftString.append(c);
                        --numIndex;
                    }
                    leftString.append(strNum.charAt(numIndex));
                    --numIndex;
                    --patternIndex;
                    continue;
                }
                if (node.getType() == 2) {
                    leftString.append(' ');
                    continue;
                }
                if (node.getType() != 0) continue;
                leftString.append('0');
                continue;
            }
            if (node.getType() == 24) {
                leftString.append(node.getText());
                repeatIndex = leftString.length() - 1;
                continue;
            }
            if (node.getType() == 28) continue;
            leftString.append((CharSequence)new StringBuilder(node.getText()).reverse());
        }
        if (repeatIndex != -1) {
            repeatIndex = leftString.length() - 1 - repeatIndex + toAppend.length();
        }
        toAppend.append((CharSequence)leftString.reverse());
        return repeatIndex;
    }

    private int getPointRight(StringBuffer toAppend, String strNum) {
        int repeatIndex = -1;
        int nodeIndex = this._decimalSepIndex == -1 ? this._nodes.size() : this._decimalSepIndex + 1;
        int numSepIndex = strNum.indexOf(46);
        int numIndex = numSepIndex == -1 ? strNum.length() : numSepIndex + 1;
        for (int i = nodeIndex; i < this._nodes.size(); ++i) {
            Node node = (Node)this._nodes.get(i);
            if (node.isNumber()) {
                if (numIndex < strNum.length()) {
                    this.addRadixPoint(toAppend);
                    toAppend.append(strNum.charAt(numIndex));
                    ++numIndex;
                    continue;
                }
                if (node.getType() == 2) {
                    toAppend.append(' ');
                    continue;
                }
                if (node.getType() != 0) continue;
                this.addRadixPoint(toAppend);
                toAppend.append('0');
                continue;
            }
            if (node.getType() == 24) {
                this.addRadixPoint(toAppend);
                toAppend.append(node.getText());
                repeatIndex = toAppend.length() - 1;
                continue;
            }
            this.addRadixPoint(toAppend);
            toAppend.append(new StringBuffer(node.getText()));
        }
        return repeatIndex;
    }

    private String toStringNumber(Variant var, boolean parse) {
        Object value = var.getValue();
        if (parse || var.isNumber() || var.isDate() || var.isReferences() && value instanceof CellBlockNode) {
            if (var.getVt() == 0) {
                return null;
            }
            try {
                boolean bminus;
                BigDecimal bd = null;
                bd = this._isPercent ? var.toBigDecimal().multiply(BigDecimal.valueOf(100.0)) : (var.isNumber() ? var.toBigDecimal() : (var.isReferences() && value instanceof CellBlockNode ? ((IVarReferences)value).getActualValue().toBigDecimal() : (var.isDate() ? var.toBigDecimal() : var.toBigDecimal())));
                String pattern = this.toRealPattern(this._pattern);
                int decIndex = pattern.indexOf(46);
                if (decIndex == -1) {
                    bd = bd.setScale(0, 4);
                } else {
                    bd = bd.setScale(pattern.length() - decIndex - 1, 4);
                    bd = Util.reduceScale(bd);
                }
                String ret = CtrlSwingUtilities.bigDecimalToPlainString((BigDecimal)bd);
                boolean bl = bminus = ret.indexOf(45) == 0;
                if (bminus) {
                    ret = ret.substring(1);
                }
                if (this.hasGroupSep()) {
                    int index = ret.indexOf(46);
                    if (index < 0) {
                        index = ret.length();
                    }
                    if (index > 3) {
                        StringBuilder sb = new StringBuilder(ret);
                        for (int i = index -= 3; i > 0; i -= 3) {
                            sb.insert(i, ',');
                        }
                        ret = sb.toString();
                    }
                }
                if (bminus) {
                    ret = '-' + ret;
                }
                return ret;
            }
            catch (SyntaxErrorException e) {
                return null;
            }
        }
        return null;
    }

    private String toRealPattern(String pattern) {
        this._hasRadixPoint = false;
        String newPattern = pattern.replace('0', '#');
        newPattern = newPattern.replace('?', '#');
        return newPattern;
    }

    private void addRadixPoint(StringBuffer toAppend) {
        if (!this._hasRadixPoint) {
            this._hasRadixPoint = true;
            toAppend.append('.');
        }
    }
}

