/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.cosmic.ctrl.extcommon.util;

import com.kingdee.cosmic.ctrl.common.KDToolkit;
import com.kingdee.cosmic.ctrl.extcommon.util.ObjectArray;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;

public class SortedObjectArray
extends ObjectArray
implements Serializable {
    private static final long serialVersionUID = -1419511454121730402L;
    private static final DefaultComparator _defaultComparator = new DefaultComparator();
    private transient Comparator _cmp = _defaultComparator;
    private transient ObjectIterator _iterator;

    public SortedObjectArray() {
    }

    public SortedObjectArray(int initCap) {
        super(initCap);
    }

    public SortedObjectArray(Object[] array) {
        super(array, array.length);
    }

    public void setComparator(Comparator cmp) {
        this._cmp = cmp;
    }

    public Object insert(Object obj) {
        Object old = null;
        if (this._count == 0) {
            this._array[0] = obj;
            this._count = 1;
        } else {
            int cmp = this._cmp.compare(this._array[this._count - 1], obj);
            if (cmp < 0) {
                this.append(obj);
            } else {
                int pos;
                int n = pos = cmp == 0 ? this._count - 1 : this.search(obj);
                if (pos >= 0) {
                    old = this._array[pos];
                    this._array[pos] = obj;
                } else {
                    pos = -(pos + 1);
                    if (this._count + 1 > this._array.length) {
                        Object[] newArray = new Object[this.getIncreasedCellsSize()];
                        KDToolkit.arraycopy((Object[])this._array, (int)0, (Object[])newArray, (int)0, (int)pos);
                        KDToolkit.arraycopy((Object[])this._array, (int)pos, (Object[])newArray, (int)(pos + 1), (int)(this._count - pos));
                        this._array = newArray;
                    } else {
                        KDToolkit.arraycopy((Object[])this._array, (int)pos, (Object[])this._array, (int)(pos + 1), (int)(this._count - pos));
                    }
                    this._array[pos] = obj;
                    ++this._count;
                }
            }
        }
        return old;
    }

    public void insertAll(Object[] objs) {
        if (objs == null || objs.length == 0) {
            return;
        }
        for (int i = 0; i < objs.length; ++i) {
            Object obj = objs[i];
            if (obj == null) continue;
            this.insert(obj);
        }
    }

    public void insertAll(SortedObjectArray soa) {
        if (soa == null || soa.isEmpty()) {
            return;
        }
        this.insertAll(soa._array);
    }

    @Override
    public Object remove(Object obj) {
        if (obj == null) {
            return null;
        }
        return this.removeByPos(this.search(obj));
    }

    public int search(Object obj) {
        if (this.isEmpty()) {
            return -1;
        }
        int low = 0;
        int high = this._count - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            Object midVal = this._array[mid];
            int cmp = this._cmp.compare(midVal, obj);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int getProperPos(Object obj, boolean bLater) {
        int pos = this.search(obj);
        if (pos < 0) {
            pos = -(pos + 1);
            if (bLater) {
                --pos;
            }
        }
        return pos;
    }

    public Iterator iterator(Object o1, Object o2, boolean descent) {
        if (this._iterator == null) {
            this._iterator = new ObjectIterator();
        }
        this._iterator.init(o1, o2, descent);
        return this._iterator;
    }

    class ObjectIterator
    implements Iterator {
        private boolean _descent;
        private int _pos;
        private int _pos2;

        ObjectIterator() {
        }

        public void init(Object o1, Object o2, boolean descent) {
            this._descent = descent;
            this._pos = SortedObjectArray.this.getProperPos(o1, false);
            this._pos2 = SortedObjectArray.this.getProperPos(o2, true);
        }

        @Override
        public boolean hasNext() {
            return this._pos <= this._pos2;
        }

        public Object next() {
            return this._descent ? SortedObjectArray.this._array[this._pos2--] : SortedObjectArray.this._array[this._pos++];
        }

        @Override
        public void remove() {
        }
    }

    static class DefaultComparator
    implements Comparator {
        DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }
    }
}

